/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.view;

import com.android.builder.model.level2.Library;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.tools.idea.gradle.project.build.GradleProjectBuilder;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.setup.module.AndroidModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.NdkModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.android.CompilerOutputModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.android.ContentRootsModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.android.DependenciesAndroidModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.ndk.ContentRootModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BuildVariantUpdater {
    @NotNull
    private final ModuleSetupContext.Factory myModuleSetupContextFactory;
    @NotNull
    private final IdeModifiableModelsProviderFactory myModifiableModelsProviderFactory;
    @NotNull
    private final List<AndroidModuleSetupStep> myAndroidModuleSetupSteps;
    @NotNull
    private final NdkModuleSetupStep[] myNdkModuleSetupSteps;

    BuildVariantUpdater() {
        this(new ModuleSetupContext.Factory(), new IdeModifiableModelsProviderFactory(), Arrays.asList(new ContentRootsModuleSetupStep(), new DependenciesAndroidModuleSetupStep(), new CompilerOutputModuleSetupStep()));
    }

    @VisibleForTesting
    BuildVariantUpdater(@NotNull ModuleSetupContext.Factory moduleSetupContextFactory, @NotNull IdeModifiableModelsProviderFactory modifiableModelsProviderFactory, @NotNull List<AndroidModuleSetupStep> androidModuleSetupSteps) {
        if (moduleSetupContextFactory == null) {
            BuildVariantUpdater.$$$reportNull$$$0(0);
        }
        if (modifiableModelsProviderFactory == null) {
            BuildVariantUpdater.$$$reportNull$$$0(1);
        }
        if (androidModuleSetupSteps == null) {
            BuildVariantUpdater.$$$reportNull$$$0(2);
        }
        this.myNdkModuleSetupSteps = new NdkModuleSetupStep[]{new ContentRootModuleSetupStep()};
        this.myModuleSetupContextFactory = moduleSetupContextFactory;
        this.myModifiableModelsProviderFactory = modifiableModelsProviderFactory;
        this.myAndroidModuleSetupSteps = androidModuleSetupSteps;
    }

    boolean updateSelectedVariant(@NotNull Project project, @NotNull String moduleName, @NotNull String buildVariantName) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(3);
        }
        if (moduleName == null) {
            BuildVariantUpdater.$$$reportNull$$$0(4);
        }
        if (buildVariantName == null) {
            BuildVariantUpdater.$$$reportNull$$$0(5);
        }
        ArrayList affectedAndroidFacets = new ArrayList();
        ArrayList affectedNdkFacets = new ArrayList();
        GradleProjects.executeProjectChanges(project, () -> {
            if (project == null) {
                BuildVariantUpdater.$$$reportNull$$$0(38);
            }
            if (moduleName == null) {
                BuildVariantUpdater.$$$reportNull$$$0(39);
            }
            if (buildVariantName == null) {
                BuildVariantUpdater.$$$reportNull$$$0(40);
            }
            this.doUpdate(project, moduleName, buildVariantName, affectedAndroidFacets, affectedNdkFacets);
            PostSyncProjectSetup.Request setupRequest = new PostSyncProjectSetup.Request();
            setupRequest.generateSourcesAfterSync = false;
            setupRequest.cleanProjectAfterSync = false;
            PostSyncProjectSetup.getInstance(project).setUpProject(setupRequest, (ProgressIndicator)new EmptyProgressIndicator());
            BuildVariantUpdater.generateSourcesIfNeeded(project, affectedAndroidFacets);
        });
        return !affectedAndroidFacets.isEmpty() || !affectedNdkFacets.isEmpty();
    }

    private void doUpdate(@NotNull Project project, @NotNull String moduleName, @NotNull String variant, @NotNull List<AndroidFacet> affectedAndroidFacets, @NotNull List<NdkFacet> affectedNdkFacets) {
        Module moduleToUpdate;
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(6);
        }
        if (moduleName == null) {
            BuildVariantUpdater.$$$reportNull$$$0(7);
        }
        if (variant == null) {
            BuildVariantUpdater.$$$reportNull$$$0(8);
        }
        if (affectedAndroidFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(9);
        }
        if (affectedNdkFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(10);
        }
        if ((moduleToUpdate = BuildVariantUpdater.findModule(project, moduleName)) == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variant, String.format("Cannot find module '%1$s'.", moduleName));
            return;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance(moduleToUpdate);
        NdkFacet ndkFacet = NdkFacet.getInstance(moduleToUpdate);
        if (androidFacet == null && ndkFacet == null) {
            String msg = String.format("Cannot find 'Android' or 'Native-Android-Gradle' facets in module '%1$s'.", moduleToUpdate.getName());
            BuildVariantUpdater.logAndShowUpdateFailure(variant, msg);
        }
        if (ndkFacet != null) {
            NdkModuleModel ndkModuleModel = BuildVariantUpdater.getNativeAndroidModel(ndkFacet, variant);
            if (ndkModuleModel == null || !this.updateSelectedVariant(ndkFacet, ndkModuleModel, variant)) {
                return;
            }
            affectedNdkFacets.add(ndkFacet);
        }
        if (androidFacet != null) {
            AndroidModuleModel androidModel = BuildVariantUpdater.getAndroidModel(androidFacet, variant);
            if (androidModel == null || !this.updateSelectedVariant(androidFacet, androidModel, variant, affectedAndroidFacets)) {
                return;
            }
            affectedAndroidFacets.add(androidFacet);
        }
    }

    @Nullable
    private static Module findModule(@NotNull Project project, @NotNull String moduleName) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(11);
        }
        if (moduleName == null) {
            BuildVariantUpdater.$$$reportNull$$$0(12);
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        return moduleManager.findModuleByName(moduleName);
    }

    private boolean updateSelectedVariant(@NotNull AndroidFacet androidFacet, @NotNull AndroidModuleModel androidModel, @NotNull String variantToSelect, @NotNull List<AndroidFacet> affectedFacets) {
        IdeVariant selectedVariant;
        if (androidFacet == null) {
            BuildVariantUpdater.$$$reportNull$$$0(13);
        }
        if (androidModel == null) {
            BuildVariantUpdater.$$$reportNull$$$0(14);
        }
        if (variantToSelect == null) {
            BuildVariantUpdater.$$$reportNull$$$0(15);
        }
        if (affectedFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(16);
        }
        if (variantToSelect.equals((selectedVariant = androidModel.getSelectedVariant()).getName())) {
            return false;
        }
        androidModel.setSelectedVariantName(variantToSelect);
        androidModel.syncSelectedVariantAndTestArtifact(androidFacet);
        Module module = this.setUpModule(androidFacet.getModule(), androidModel);
        for (Library library : androidModel.getSelectedMainCompileLevel2Dependencies().getModuleDependencies()) {
            String projectVariant;
            String gradlePath = library.getProjectPath();
            if (StringUtil.isEmpty((String)gradlePath) || !StringUtil.isNotEmpty((String)(projectVariant = library.getVariant()))) continue;
            this.ensureVariantIsSelected(module.getProject(), gradlePath, projectVariant, affectedFacets);
        }
        return true;
    }

    private boolean updateSelectedVariant(@NotNull NdkFacet ndkFacet, @NotNull NdkModuleModel ndkModuleModel, @NotNull String variantToSelect) {
        NdkModuleModel.NdkVariant selectedVariant;
        if (ndkFacet == null) {
            BuildVariantUpdater.$$$reportNull$$$0(17);
        }
        if (ndkModuleModel == null) {
            BuildVariantUpdater.$$$reportNull$$$0(18);
        }
        if (variantToSelect == null) {
            BuildVariantUpdater.$$$reportNull$$$0(19);
        }
        if (variantToSelect.equals((selectedVariant = ndkModuleModel.getSelectedVariant()).getName())) {
            return false;
        }
        ndkModuleModel.setSelectedVariantName(variantToSelect);
        ((NdkFacetConfiguration)ndkFacet.getConfiguration()).SELECTED_BUILD_VARIANT = ndkModuleModel.getSelectedVariant().getName();
        this.setUpModule(ndkFacet.getModule(), ndkModuleModel);
        return true;
    }

    private static void generateSourcesIfNeeded(@NotNull Project project, @NotNull List<AndroidFacet> affectedFacets) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(20);
        }
        if (affectedFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(21);
        }
        if (!affectedFacets.isEmpty() && !ApplicationManager.getApplication().isUnitTestMode()) {
            GradleProjectBuilder.getInstance(project).generateSources();
        }
    }

    @NotNull
    private Module setUpModule(@NotNull Module module, @NotNull AndroidModuleModel androidModel) {
        if (module == null) {
            BuildVariantUpdater.$$$reportNull$$$0(22);
        }
        if (androidModel == null) {
            BuildVariantUpdater.$$$reportNull$$$0(23);
        }
        IdeModifiableModelsProvider modelsProvider = this.myModifiableModelsProviderFactory.create(module.getProject());
        ModuleSetupContext context = this.myModuleSetupContextFactory.create(module, modelsProvider);
        try {
            for (AndroidModuleSetupStep setupStep : this.myAndroidModuleSetupSteps) {
                if (!setupStep.invokeOnBuildVariantChange()) continue;
                setupStep.setUpModule(context, androidModel);
            }
            modelsProvider.commit();
        }
        catch (Throwable t) {
            modelsProvider.dispose();
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
        Module module2 = module;
        if (module2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(24);
        }
        return module2;
    }

    private void setUpModule(@NotNull Module module, @NotNull NdkModuleModel ndkModuleModel) {
        if (module == null) {
            BuildVariantUpdater.$$$reportNull$$$0(25);
        }
        if (ndkModuleModel == null) {
            BuildVariantUpdater.$$$reportNull$$$0(26);
        }
        IdeModifiableModelsProviderImpl modelsProvider = new IdeModifiableModelsProviderImpl(module.getProject());
        ModuleSetupContext context = this.myModuleSetupContextFactory.create(module, (IdeModifiableModelsProvider)modelsProvider);
        try {
            for (NdkModuleSetupStep setupStep : this.myNdkModuleSetupSteps) {
                if (!setupStep.invokeOnBuildVariantChange()) continue;
                setupStep.setUpModule(context, ndkModuleModel);
            }
            modelsProvider.commit();
        }
        catch (Throwable t) {
            modelsProvider.dispose();
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
    }

    private void ensureVariantIsSelected(@NotNull Project project, @NotNull String moduleGradlePath, @NotNull String variant, @NotNull List<AndroidFacet> affectedFacets) {
        Module module;
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(27);
        }
        if (moduleGradlePath == null) {
            BuildVariantUpdater.$$$reportNull$$$0(28);
        }
        if (variant == null) {
            BuildVariantUpdater.$$$reportNull$$$0(29);
        }
        if (affectedFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(30);
        }
        if ((module = GradleUtil.findModuleByGradlePath(project, moduleGradlePath)) == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variant, String.format("Cannot find module with Gradle path '%1$s'.", moduleGradlePath));
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variant, String.format("Cannot find 'Android' facet in module '%1$s'.", module.getName()));
            return;
        }
        AndroidModuleModel androidModel = BuildVariantUpdater.getAndroidModel(facet, variant);
        if (androidModel == null) {
            return;
        }
        if (!this.updateSelectedVariant(facet, androidModel, variant, affectedFacets)) {
            return;
        }
        affectedFacets.add(facet);
    }

    @Nullable
    private static AndroidModuleModel getAndroidModel(@NotNull AndroidFacet facet, @NotNull String variantToSelect) {
        AndroidModuleModel androidModel;
        if (facet == null) {
            BuildVariantUpdater.$$$reportNull$$$0(31);
        }
        if (variantToSelect == null) {
            BuildVariantUpdater.$$$reportNull$$$0(32);
        }
        if ((androidModel = AndroidModuleModel.get(facet)) == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variantToSelect, String.format("Cannot find AndroidProject for module '%1$s'.", facet.getModule().getName()));
        }
        return androidModel;
    }

    @Nullable
    private static NdkModuleModel getNativeAndroidModel(@NotNull NdkFacet facet, @NotNull String variantToSelect) {
        NdkModuleModel ndkModuleModel;
        if (facet == null) {
            BuildVariantUpdater.$$$reportNull$$$0(33);
        }
        if (variantToSelect == null) {
            BuildVariantUpdater.$$$reportNull$$$0(34);
        }
        if ((ndkModuleModel = NdkModuleModel.get(facet)) == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variantToSelect, String.format("Cannot find NativeAndroidProject for module '%1$s'.", facet.getModule().getName()));
        }
        return ndkModuleModel;
    }

    private static void logAndShowUpdateFailure(@NotNull String buildVariantName, @NotNull String reason) {
        if (buildVariantName == null) {
            BuildVariantUpdater.$$$reportNull$$$0(35);
        }
        if (reason == null) {
            BuildVariantUpdater.$$$reportNull$$$0(36);
        }
        String prefix = String.format("Unable to select build variant '%1$s':\n", buildVariantName);
        String msg = prefix + reason;
        BuildVariantUpdater.getLog().error(msg);
        msg = msg + ".\n\nConsult IDE log for more details (Help | Show Log)";
        Messages.showErrorDialog((String)msg, (String)"Error");
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(BuildVariantUpdater.class);
        if (logger == null) {
            BuildVariantUpdater.$$$reportNull$$$0(37);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 24: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 24: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleSetupContextFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableModelsProviderFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModuleSetupSteps";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 20: 
            case 27: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 5: 
            case 35: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildVariantName";
                break;
            }
            case 8: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedAndroidFacets";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedNdkFacets";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidFacet";
                break;
            }
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 15: 
            case 19: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantToSelect";
                break;
            }
            case 16: 
            case 21: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedFacets";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkFacet";
                break;
            }
            case 18: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkModuleModel";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 24: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleGradlePath";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "setUpModule";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "updateSelectedVariant";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doUpdate";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "generateSourcesIfNeeded";
                break;
            }
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setUpModule";
                break;
            }
            case 24: 
            case 37: {
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "ensureVariantIsSelected";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidModel";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getNativeAndroidModel";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "logAndShowUpdateFailure";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateSelectedVariant$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 24: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class IdeModifiableModelsProviderFactory {
        IdeModifiableModelsProviderFactory() {
        }

        @NotNull
        IdeModifiableModelsProvider create(@NotNull Project project) {
            if (project == null) {
                IdeModifiableModelsProviderFactory.$$$reportNull$$$0(0);
            }
            IdeModifiableModelsProviderImpl ideModifiableModelsProviderImpl = new IdeModifiableModelsProviderImpl(project);
            if (ideModifiableModelsProviderImpl == null) {
                IdeModifiableModelsProviderFactory.$$$reportNull$$$0(1);
            }
            return ideModifiableModelsProviderImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater$IdeModifiableModelsProviderFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater$IdeModifiableModelsProviderFactory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

