/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.conflict;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.intellij.openapi.module.Module;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class Conflict {
    @NotNull
    private final Module mySource;
    @NotNull
    private final String mySelectedVariant;
    @NotNull
    private final Multimap<String, AffectedModule> myAffectedModulesByExpectedVariant;
    @NotNull
    private final List<AffectedModule> myAffectedModules;
    private boolean myResolved;

    public Conflict(@NotNull Module source, @NotNull String selectedVariant) {
        if (source == null) {
            Conflict.$$$reportNull$$$0(0);
        }
        if (selectedVariant == null) {
            Conflict.$$$reportNull$$$0(1);
        }
        this.myAffectedModulesByExpectedVariant = ArrayListMultimap.create();
        this.myAffectedModules = Lists.newArrayList();
        this.mySource = source;
        this.mySelectedVariant = selectedVariant;
    }

    public void addAffectedModule(@NotNull Module target, @NotNull String expectedVariant) {
        if (target == null) {
            Conflict.$$$reportNull$$$0(2);
        }
        if (expectedVariant == null) {
            Conflict.$$$reportNull$$$0(3);
        }
        AffectedModule affected = new AffectedModule(this, target, expectedVariant);
        this.myAffectedModules.add(affected);
        this.myAffectedModulesByExpectedVariant.put((Object)expectedVariant, (Object)affected);
    }

    @NotNull
    public Collection<String> getVariants() {
        Set set = this.myAffectedModulesByExpectedVariant.keySet();
        if (set == null) {
            Conflict.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Collection<AffectedModule> getModulesExpectingVariant(@NotNull String variant) {
        if (variant == null) {
            Conflict.$$$reportNull$$$0(5);
        }
        Collection collection = this.myAffectedModulesByExpectedVariant.get((Object)variant);
        if (collection == null) {
            Conflict.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    public Module getSource() {
        Module module = this.mySource;
        if (module == null) {
            Conflict.$$$reportNull$$$0(7);
        }
        return module;
    }

    @NotNull
    public String getSelectedVariant() {
        String string = this.mySelectedVariant;
        if (string == null) {
            Conflict.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public List<AffectedModule> getAffectedModules() {
        List<AffectedModule> list = this.myAffectedModules;
        if (list == null) {
            Conflict.$$$reportNull$$$0(9);
        }
        return list;
    }

    public void refreshStatus() {
        int selectedVariantCount = 0;
        block0: for (String variant : this.myAffectedModulesByExpectedVariant.keySet()) {
            for (AffectedModule affected : this.getModulesExpectingVariant(variant)) {
                if (!affected.isSelected()) continue;
                ++selectedVariantCount;
                continue block0;
            }
        }
        this.setResolved(selectedVariantCount <= 1);
    }

    public boolean isResolved() {
        return this.myResolved;
    }

    public void setResolved(boolean resolved) {
        this.myResolved = resolved;
    }

    public String toString() {
        String text = String.format("Module '%1$s' has variant '%2$s' selected, but", this.mySource.getName(), this.mySelectedVariant);
        ArrayList expectedVariants = Lists.newArrayList(this.getVariants());
        if (expectedVariants.size() == 1) {
            String expectedVariant = (String)expectedVariants.get(0);
            Collection<AffectedModule> modules = this.getModulesExpectingVariant(expectedVariant);
            String moduleNames = Conflict.getModuleNames(modules);
            String format = modules.size() == 1 ? " the module '%1$s' depends on variant '%2$s'" : " the modules %1$s depend on variant '%2$s'";
            text = text + String.format(format, moduleNames, expectedVariant);
        } else {
            Collections.sort(expectedVariants);
            for (String expectedVariant : expectedVariants) {
                Collection<AffectedModule> modules = this.getModulesExpectingVariant(expectedVariant);
                String moduleNames = Conflict.getModuleNames(modules);
                text = text + "\n- ";
                String format = modules.size() == 1 ? "Module '%1$s' depends on variant '%2$s'" : "Modules %1$s depend on variant '%2$s'";
                text = text + String.format(format, moduleNames, expectedVariant);
            }
        }
        return text;
    }

    @NotNull
    private static String getModuleNames(@NotNull Collection<AffectedModule> modules) {
        if (modules == null) {
            Conflict.$$$reportNull$$$0(10);
        }
        if (modules.size() == 1) {
            AffectedModule module = (AffectedModule)ContainerUtil.getFirstItem(modules);
            assert (module != null);
            String string = "'" + module.getTarget().getName() + "'";
            if (string == null) {
                Conflict.$$$reportNull$$$0(11);
            }
            return string;
        }
        ArrayList names = Lists.newArrayList();
        for (AffectedModule module : modules) {
            names.add("'" + module.getTarget().getName() + "'");
        }
        Collections.sort(names);
        String string = ((Object)names).toString();
        if (string == null) {
            Conflict.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedVariant";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedVariant";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/variant/conflict/Conflict";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/variant/conflict/Conflict";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesExpectingVariant";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSource";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedVariant";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedModules";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addAffectedModule";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModulesExpectingVariant";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getModuleNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class AffectedModule {
        @NotNull
        private final Conflict myConflict;
        @NotNull
        private final Module myTarget;
        @NotNull
        private final String myExpectedVariant;
        private boolean mySelected;

        AffectedModule(@NotNull Conflict conflict, @NotNull Module target, @NotNull String expectedVariant) {
            if (conflict == null) {
                AffectedModule.$$$reportNull$$$0(0);
            }
            if (target == null) {
                AffectedModule.$$$reportNull$$$0(1);
            }
            if (expectedVariant == null) {
                AffectedModule.$$$reportNull$$$0(2);
            }
            this.mySelected = true;
            this.myConflict = conflict;
            this.myTarget = target;
            this.myExpectedVariant = expectedVariant;
        }

        @NotNull
        public Conflict getConflict() {
            Conflict conflict = this.myConflict;
            if (conflict == null) {
                AffectedModule.$$$reportNull$$$0(3);
            }
            return conflict;
        }

        @NotNull
        public Module getTarget() {
            Module module = this.myTarget;
            if (module == null) {
                AffectedModule.$$$reportNull$$$0(4);
            }
            return module;
        }

        @NotNull
        public String getExpectedVariant() {
            String string = this.myExpectedVariant;
            if (string == null) {
                AffectedModule.$$$reportNull$$$0(5);
            }
            return string;
        }

        public boolean isSelected() {
            return this.mySelected;
        }

        public void setSelected(boolean selected) {
            this.mySelected = selected;
            this.myConflict.refreshStatus();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conflict";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expectedVariant";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/variant/conflict/Conflict$AffectedModule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/variant/conflict/Conflict$AffectedModule";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConflict";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTarget";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpectedVariant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

