/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.google.common.collect.Lists;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.gradle.initialization.BuildLayoutParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class GradleLocalCache {
    @NotNull
    public static GradleLocalCache getInstance() {
        GradleLocalCache gradleLocalCache = (GradleLocalCache)ServiceManager.getService(GradleLocalCache.class);
        if (gradleLocalCache == null) {
            GradleLocalCache.$$$reportNull$$$0(0);
        }
        return gradleLocalCache;
    }

    @Nullable
    public GradleVersion findLatestArtifactVersion(@NotNull GradleCoordinate artifactCoordinate, @Nullable Project project, @Nullable String versionPrefix) {
        if (artifactCoordinate == null) {
            GradleLocalCache.$$$reportNull$$$0(1);
        }
        String groupId = artifactCoordinate.getGroupId();
        String artifactId = artifactCoordinate.getArtifactId();
        if (StringUtil.isNotEmpty((String)groupId) && StringUtil.isNotEmpty((String)artifactId)) {
            return this.findLatestArtifactVersion(groupId, artifactId, project, versionPrefix);
        }
        return null;
    }

    @Nullable
    public GradleVersion findLatestArtifactVersion(@NotNull String groupId, @NotNull String artifactId, @Nullable Project project, @Nullable String versionPrefix) {
        if (groupId == null) {
            GradleLocalCache.$$$reportNull$$$0(2);
        }
        if (artifactId == null) {
            GradleLocalCache.$$$reportNull$$$0(3);
        }
        for (File gradleServicePath : GradleLocalCache.getGradleServicePaths(project)) {
            GradleVersion version = GradleLocalCache.findLatestVersionInGradleCache(gradleServicePath, groupId, artifactId, versionPrefix);
            if (version == null) continue;
            return version;
        }
        return null;
    }

    @Nullable
    private static GradleVersion findLatestVersionInGradleCache(@NotNull File gradleServicePath, @NotNull String groupId, @NotNull String artifactId, @Nullable String versionPrefix) {
        File gradleCacheFolder;
        if (gradleServicePath == null) {
            GradleLocalCache.$$$reportNull$$$0(4);
        }
        if (groupId == null) {
            GradleLocalCache.$$$reportNull$$$0(5);
        }
        if (artifactId == null) {
            GradleLocalCache.$$$reportNull$$$0(6);
        }
        if (!(gradleCacheFolder = new File(gradleServicePath, "caches")).isDirectory()) {
            return null;
        }
        ArrayList versions = Lists.newArrayList();
        for (File moduleFolder : FileUtil.notNullize((File[])gradleCacheFolder.listFiles())) {
            if (!GradleLocalCache.isDirectoryWithNamePrefix(moduleFolder, "modules-")) continue;
            for (File metadataFolder : FileUtil.notNullize((File[])moduleFolder.listFiles())) {
                File versionFolder;
                if (!GradleLocalCache.isDirectoryWithNamePrefix(metadataFolder, "metadata-") || !(versionFolder = new File(metadataFolder, FileUtil.join((String[])new String[]{"descriptors", groupId, artifactId}))).isDirectory()) continue;
                for (File versionFile : FileUtil.notNullize((File[])versionFolder.listFiles())) {
                    GradleVersion parsedVersion;
                    String version = versionFile.getName();
                    if (versionPrefix != null && !version.startsWith(versionPrefix) || version.isEmpty() || !Character.isDigit(version.charAt(0)) || (parsedVersion = GradleVersion.tryParse((String)version)) == null) continue;
                    versions.add(parsedVersion);
                }
            }
        }
        int versionCount = versions.size();
        if (versionCount == 1) {
            return (GradleVersion)versions.get(0);
        }
        if (versionCount > 1) {
            Collections.sort(versions);
            return (GradleVersion)versions.get(versionCount - 1);
        }
        return null;
    }

    private static boolean isDirectoryWithNamePrefix(@NotNull File file, @NotNull String prefix) {
        if (file == null) {
            GradleLocalCache.$$$reportNull$$$0(7);
        }
        if (prefix == null) {
            GradleLocalCache.$$$reportNull$$$0(8);
        }
        return file.getName().startsWith(prefix) && file.isDirectory();
    }

    public boolean containsGradleWrapperVersion(@NotNull String gradleVersion, @NotNull Project project) {
        if (gradleVersion == null) {
            GradleLocalCache.$$$reportNull$$$0(9);
        }
        if (project == null) {
            GradleLocalCache.$$$reportNull$$$0(10);
        }
        String distFolderName = "gradle-" + gradleVersion;
        String wrapperDirNamePrefix = distFolderName + "-";
        String[] wrapperFolderNames = new String[]{wrapperDirNamePrefix + "all", wrapperDirNamePrefix + "bin"};
        for (File gradleServicePath : GradleLocalCache.getGradleServicePaths(project)) {
            for (String wrapperFolderName : wrapperFolderNames) {
                File wrapperFolderPath = new File(gradleServicePath, FileUtil.join((String[])new String[]{"wrapper", "dists", wrapperFolderName}));
                if (!wrapperFolderPath.isDirectory()) continue;
                for (File mayBeDistParent : FileUtil.notNullize((File[])wrapperFolderPath.listFiles())) {
                    if (!mayBeDistParent.isDirectory()) continue;
                    for (File mayBeDistFolder : FileUtil.notNullize((File[])mayBeDistParent.listFiles())) {
                        if (!mayBeDistFolder.isDirectory() || !distFolderName.equals(mayBeDistFolder.getName())) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @NotNull
    private static Collection<File> getGradleServicePaths(@Nullable Project project) {
        File path;
        File file;
        GradleSettings settings;
        String path2;
        LinkedHashSet<File> paths = new LinkedHashSet<File>();
        if (project != null && StringUtil.isNotEmpty((String)(path2 = (settings = GradleSettings.getInstance((Project)project)).getServiceDirectoryPath())) && (file = new File(path2)).isDirectory()) {
            paths.add(file);
        }
        if ((path = new BuildLayoutParameters().getGradleUserHomeDir()).isDirectory()) {
            paths.add(path);
        }
        LinkedHashSet<File> linkedHashSet = paths;
        if (linkedHashSet == null) {
            GradleLocalCache.$$$reportNull$$$0(11);
        }
        return linkedHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/util/GradleLocalCache";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactCoordinate";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleServicePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleVersion";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/util/GradleLocalCache";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleServicePaths";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findLatestArtifactVersion";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findLatestVersionInGradleCache";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isDirectoryWithNamePrefix";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "containsGradleWrapperVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

