/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.quickfix;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import org.jetbrains.annotations.NotNull;

public final class PsLibraryDependencyVersionQuickFixPath
extends PsPath {
    public static final String DEFAULT_QUICK_FIX_TEXT = "[Fix]";
    @NotNull
    private final String myModuleName;
    @NotNull
    private final String myDependency;
    @NotNull
    private final String myVersion;
    @NotNull
    private final String myQuickFixText;

    public PsLibraryDependencyVersionQuickFixPath(@NotNull PsLibraryDependency dependency, @NotNull String quickFixText) {
        if (dependency == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(0);
        }
        if (quickFixText == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(1);
        }
        super(null);
        this.myModuleName = dependency.getParent().getName();
        this.myDependency = PsLibraryDependencyVersionQuickFixPath.getCompactNotation(dependency);
        String version = dependency.getResolvedSpec().getVersion();
        assert (version != null);
        this.myVersion = version;
        this.myQuickFixText = quickFixText;
    }

    public PsLibraryDependencyVersionQuickFixPath(@NotNull PsLibraryDependency dependency, @NotNull String version, @NotNull String quickFixText) {
        if (dependency == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(2);
        }
        if (version == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(3);
        }
        if (quickFixText == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(4);
        }
        super(null);
        this.myModuleName = dependency.getParent().getName();
        this.myDependency = PsLibraryDependencyVersionQuickFixPath.getCompactNotation(dependency);
        this.myVersion = version;
        this.myQuickFixText = quickFixText;
    }

    @NotNull
    private static String getCompactNotation(@NotNull PsLibraryDependency dependency) {
        PsArtifactDependencySpec spec;
        if (dependency == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(5);
        }
        if ((spec = dependency.getDeclaredSpec()) == null) {
            spec = dependency.getResolvedSpec();
        }
        String string = spec.compactNotation();
        if (string == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public String toText(@NotNull PsPath.TexType type) {
        if (type == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(7);
        }
        String string = this.myDependency;
        if (string == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public String getHyperlinkDestination(@NotNull PsContext context) {
        if (context == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(9);
        }
        String path = Joiner.on((char)'/').join((Object)"setLibraryDependency", (Object)this.myModuleName, new Object[]{this.myDependency, this.myVersion});
        String string = "psdFix://" + path;
        if (string == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @NotNull
    public String getHtml(@NotNull PsContext context) {
        if (context == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(11);
        }
        String string = String.format("<a href=\"%s\">%s</a>", this.getHyperlinkDestination(context), this.myQuickFixText);
        if (string == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PsLibraryDependencyVersionQuickFixPath path = (PsLibraryDependencyVersionQuickFixPath)o;
        return Objects.equal((Object)this.myModuleName, (Object)path.myModuleName) && Objects.equal((Object)this.myDependency, (Object)path.myDependency) && Objects.equal((Object)this.myVersion, (Object)path.myVersion) && Objects.equal((Object)this.myQuickFixText, (Object)path.myQuickFixText);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.myModuleName, this.myDependency, this.myVersion, this.myQuickFixText});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/quickfix/PsLibraryDependencyVersionQuickFixPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/quickfix/PsLibraryDependencyVersionQuickFixPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompactNotation";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getHyperlinkDestination";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCompactNotation";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getHyperlinkDestination";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getHtml";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

