/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.android;

import com.android.builder.model.SigningConfig;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.api.android.SigningConfigModel;
import com.android.tools.idea.gradle.structure.model.PsModelCollection;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsSigningConfig;
import com.google.common.collect.Maps;
import com.google.common.collect.MoreCollectors;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsSigningConfigCollection
implements PsModelCollection<PsSigningConfig> {
    @NotNull
    private final Map<String, PsSigningConfig> mySigningConfigsByName;
    @NotNull
    private final PsAndroidModule myParent;

    PsSigningConfigCollection(@NotNull PsAndroidModule parent) {
        AndroidModel android;
        if (parent == null) {
            PsSigningConfigCollection.$$$reportNull$$$0(0);
        }
        this.mySigningConfigsByName = Maps.newLinkedHashMap();
        this.myParent = parent;
        HashMap signingConfigsFromGradle = Maps.newHashMap();
        for (SigningConfig signingConfig : parent.getGradleModel().getAndroidProject().getSigningConfigs()) {
            signingConfigsFromGradle.put(signingConfig.getName(), signingConfig);
        }
        GradleBuildModel parsedModel = parent.getParsedModel();
        if (parsedModel != null && (android = parsedModel.android()) != null) {
            List<SigningConfigModel> parsedSigningConfigs = android.signingConfigs();
            for (SigningConfigModel parsedSigningConfig : parsedSigningConfigs) {
                String name = parsedSigningConfig.name();
                SigningConfig fromGradle = (SigningConfig)signingConfigsFromGradle.remove(name);
                PsSigningConfig model = new PsSigningConfig(parent, fromGradle, parsedSigningConfig);
                this.mySigningConfigsByName.put(name, model);
            }
        }
        if (!signingConfigsFromGradle.isEmpty()) {
            for (SigningConfig signingConfig : signingConfigsFromGradle.values()) {
                PsSigningConfig model = new PsSigningConfig(parent, signingConfig, null);
                this.mySigningConfigsByName.put(signingConfig.getName(), model);
            }
        }
    }

    @Override
    @Nullable
    public <S extends PsSigningConfig> S findElement(@NotNull String name, @NotNull Class<S> type) {
        if (name == null) {
            PsSigningConfigCollection.$$$reportNull$$$0(1);
        }
        if (type == null) {
            PsSigningConfigCollection.$$$reportNull$$$0(2);
        }
        if (PsSigningConfig.class.equals(type)) {
            return (S)((PsSigningConfig)type.cast(this.mySigningConfigsByName.get(name)));
        }
        return null;
    }

    @Override
    public void forEach(@NotNull Consumer<PsSigningConfig> consumer) {
        if (consumer == null) {
            PsSigningConfigCollection.$$$reportNull$$$0(3);
        }
        this.mySigningConfigsByName.values().forEach(consumer);
    }

    @NotNull
    public PsSigningConfig addNew(String name) {
        assert (this.myParent.getParsedModel() != null);
        AndroidModel androidModel = this.myParent.getParsedModel().android();
        assert (androidModel != null);
        androidModel.addSigningConfig(name);
        List<SigningConfigModel> signingConfigs = androidModel.signingConfigs();
        PsSigningConfig model = new PsSigningConfig(this.myParent, null, (SigningConfigModel)signingConfigs.stream().filter(it -> it.name().equals(name)).collect(MoreCollectors.onlyElement()));
        this.mySigningConfigsByName.put(name, model);
        this.myParent.setModified(true);
        PsSigningConfig psSigningConfig = model;
        if (psSigningConfig == null) {
            PsSigningConfigCollection.$$$reportNull$$$0(4);
        }
        return psSigningConfig;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/model/android/PsSigningConfigCollection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/model/android/PsSigningConfigCollection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addNew";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

