/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.android;

import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.api.android.ProductFlavorModel;
import com.android.tools.idea.gradle.structure.model.PsModelCollection;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsProductFlavor;
import com.google.common.collect.Maps;
import com.google.common.collect.MoreCollectors;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PsProductFlavorCollection
implements PsModelCollection<PsProductFlavor> {
    @NotNull
    private final Map<String, PsProductFlavor> myProductFlavorsByName = Maps.newLinkedHashMap();
    private final PsAndroidModule myParent;

    PsProductFlavorCollection(PsAndroidModule parent) {
        AndroidModel android;
        this.myParent = parent;
        HashMap productFlavorsFromGradle = Maps.newHashMap();
        for (ProductFlavorContainer container : parent.getGradleModel().getAndroidProject().getProductFlavors()) {
            ProductFlavor productFlavor = container.getProductFlavor();
            productFlavorsFromGradle.put(productFlavor.getName(), productFlavor);
        }
        GradleBuildModel parsedModel = parent.getParsedModel();
        if (parsedModel != null && (android = parsedModel.android()) != null) {
            List<ProductFlavorModel> parsedProductFlavors = android.productFlavors();
            for (ProductFlavorModel parsedProductFlavor : parsedProductFlavors) {
                String name = parsedProductFlavor.name();
                ProductFlavor fromGradle = (ProductFlavor)productFlavorsFromGradle.remove(name);
                PsProductFlavor model = new PsProductFlavor(parent, fromGradle, parsedProductFlavor);
                this.myProductFlavorsByName.put(name, model);
            }
        }
        if (!productFlavorsFromGradle.isEmpty()) {
            for (ProductFlavor productFlavor : productFlavorsFromGradle.values()) {
                PsProductFlavor model = new PsProductFlavor(parent, productFlavor, null);
                this.myProductFlavorsByName.put(productFlavor.getName(), model);
            }
        }
    }

    @Override
    public void forEach(@NotNull Consumer<PsProductFlavor> consumer) {
        if (consumer == null) {
            PsProductFlavorCollection.$$$reportNull$$$0(0);
        }
        this.myProductFlavorsByName.values().forEach(consumer);
    }

    @Override
    @Nullable
    public <S extends PsProductFlavor> S findElement(@NotNull String name, @NotNull Class<S> type) {
        if (name == null) {
            PsProductFlavorCollection.$$$reportNull$$$0(1);
        }
        if (type == null) {
            PsProductFlavorCollection.$$$reportNull$$$0(2);
        }
        if (PsProductFlavor.class.equals(type)) {
            return (S)((PsProductFlavor)type.cast(this.myProductFlavorsByName.get(name)));
        }
        return null;
    }

    @NotNull
    public PsProductFlavor addNew(@NotNull String name) {
        if (name == null) {
            PsProductFlavorCollection.$$$reportNull$$$0(3);
        }
        assert (this.myParent.getParsedModel() != null);
        AndroidModel androidModel = this.myParent.getParsedModel().android();
        assert (androidModel != null);
        androidModel.addProductFlavor(name);
        List<ProductFlavorModel> productFlavors = androidModel.productFlavors();
        PsProductFlavor model = new PsProductFlavor(this.myParent, null, (ProductFlavorModel)productFlavors.stream().filter(it -> {
            if (name == null) {
                PsProductFlavorCollection.$$$reportNull$$$0(5);
            }
            return it.name().equals(name);
        }).collect(MoreCollectors.onlyElement()));
        this.myProductFlavorsByName.put(name, model);
        this.myParent.setModified(true);
        PsProductFlavor psProductFlavor = model;
        if (psProductFlavor == null) {
            PsProductFlavorCollection.$$$reportNull$$$0(4);
        }
        return psProductFlavor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/model/android/PsProductFlavorCollection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/model/android/PsProductFlavorCollection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addNew";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addNew";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addNew$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

