/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.android;

import com.android.builder.model.BuildType;
import com.android.builder.model.BuildTypeContainer;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.api.android.BuildTypeModel;
import com.android.tools.idea.gradle.structure.model.PsModelCollection;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsBuildType;
import com.google.common.collect.Maps;
import com.google.common.collect.MoreCollectors;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsBuildTypeCollection
implements PsModelCollection<PsBuildType> {
    @NotNull
    private final Map<String, PsBuildType> myBuildTypesByName;
    @NotNull
    private final PsAndroidModule myParent;

    PsBuildTypeCollection(@NotNull PsAndroidModule parent) {
        AndroidModel android;
        if (parent == null) {
            PsBuildTypeCollection.$$$reportNull$$$0(0);
        }
        this.myBuildTypesByName = Maps.newLinkedHashMap();
        this.myParent = parent;
        HashMap buildTypesFromGradle = Maps.newHashMap();
        for (BuildTypeContainer container : parent.getGradleModel().getAndroidProject().getBuildTypes()) {
            BuildType buildType = container.getBuildType();
            buildTypesFromGradle.put(buildType.getName(), buildType);
        }
        GradleBuildModel parsedModel = parent.getParsedModel();
        if (parsedModel != null && (android = parsedModel.android()) != null) {
            List<BuildTypeModel> parsedBuildTypes = android.buildTypes();
            for (BuildTypeModel parsedBuildType : parsedBuildTypes) {
                String name = parsedBuildType.name();
                BuildType fromGradle = (BuildType)buildTypesFromGradle.remove(name);
                PsBuildType model = new PsBuildType(parent, fromGradle, parsedBuildType);
                this.myBuildTypesByName.put(name, model);
            }
        }
        if (!buildTypesFromGradle.isEmpty()) {
            for (BuildType buildType : buildTypesFromGradle.values()) {
                PsBuildType model = new PsBuildType(parent, buildType, null);
                this.myBuildTypesByName.put(buildType.getName(), model);
            }
        }
    }

    @Override
    @Nullable
    public <S extends PsBuildType> S findElement(@NotNull String name, @NotNull Class<S> type) {
        if (name == null) {
            PsBuildTypeCollection.$$$reportNull$$$0(1);
        }
        if (type == null) {
            PsBuildTypeCollection.$$$reportNull$$$0(2);
        }
        if (PsBuildType.class.equals(type)) {
            return (S)((PsBuildType)type.cast(this.myBuildTypesByName.get(name)));
        }
        return null;
    }

    @Override
    public void forEach(@NotNull Consumer<PsBuildType> consumer) {
        if (consumer == null) {
            PsBuildTypeCollection.$$$reportNull$$$0(3);
        }
        this.myBuildTypesByName.values().forEach(consumer);
    }

    @NotNull
    public PsBuildType addNew(@NotNull String name) {
        if (name == null) {
            PsBuildTypeCollection.$$$reportNull$$$0(4);
        }
        assert (this.myParent.getParsedModel() != null);
        AndroidModel androidModel = this.myParent.getParsedModel().android();
        assert (androidModel != null);
        androidModel.addBuildType(name);
        List<BuildTypeModel> buildTypes = androidModel.buildTypes();
        PsBuildType model = new PsBuildType(this.myParent, null, (BuildTypeModel)buildTypes.stream().filter(it -> {
            if (name == null) {
                PsBuildTypeCollection.$$$reportNull$$$0(6);
            }
            return it.name().equals(name);
        }).collect(MoreCollectors.onlyElement()));
        this.myBuildTypesByName.put(name, model);
        this.myParent.setModified(true);
        PsBuildType psBuildType = model;
        if (psBuildType == null) {
            PsBuildTypeCollection.$$$reportNull$$$0(5);
        }
        return psBuildType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/model/android/PsBuildTypeCollection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/model/android/PsBuildTypeCollection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "addNew";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addNew";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addNew$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

