/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.editors;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.structure.editors.KeyValuePane;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProjectConfigurable
extends NamedConfigurable
implements KeyValuePane.ModificationListener {
    private static final Logger LOG = Logger.getInstance(AndroidProjectConfigurable.class);
    private static final String DISPLAY_NAME = "Project";
    private final KeyValuePane myKeyValuePane;
    private final Project myProject;
    private final GradleBuildFile myGradleBuildFile;
    private final Map<BuildFileKey, Object> myProjectProperties = Maps.newHashMap();
    private Set<BuildFileKey> myModifiedKeys = Sets.newHashSet();
    public static final ImmutableList<BuildFileKey> PROJECT_PROPERTIES = ImmutableList.of((Object)((Object)BuildFileKey.GRADLE_WRAPPER_VERSION), (Object)((Object)BuildFileKey.PLUGIN_VERSION), (Object)((Object)BuildFileKey.PLUGIN_REPOSITORY), (Object)((Object)BuildFileKey.ALLPROJECTS_LIBRARY_REPOSITORY));

    public AndroidProjectConfigurable(Project project) {
        if (project.isDefault()) {
            throw new IllegalArgumentException("Can't instantiate an AndroidProjectConfigurable with the default project.");
        }
        this.myKeyValuePane = new KeyValuePane(project, this);
        this.myProject = project;
        VirtualFile projectBaseDir = project.getBaseDir();
        VirtualFile vf = projectBaseDir == null ? null : projectBaseDir.findChild("build.gradle");
        this.myGradleBuildFile = vf != null ? new GradleBuildFile(vf, project) : null;
    }

    public void setDisplayName(String name) {
    }

    public Object getEditableObject() {
        return this.myProject;
    }

    public String getBannerSlogan() {
        return DISPLAY_NAME;
    }

    public JComponent createOptionsPanel() {
        this.myKeyValuePane.init(this.myGradleBuildFile, (Collection<BuildFileKey>)PROJECT_PROPERTIES);
        return this.myKeyValuePane;
    }

    @Nls
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public boolean isModified() {
        return !this.myModifiedKeys.isEmpty();
    }

    @Override
    public void modified(@NotNull BuildFileKey key) {
        if (key == null) {
            AndroidProjectConfigurable.$$$reportNull$$$0(0);
        }
        this.myModifiedKeys.add(key);
    }

    public void apply() throws ConfigurationException {
        if (this.myGradleBuildFile == null) {
            return;
        }
        VirtualFile file = this.myGradleBuildFile.getFile();
        if (!ReadonlyStatusHandler.ensureFilesWritable((Project)this.myProject, (VirtualFile[])new VirtualFile[]{file})) {
            throw new ConfigurationException(String.format("Build file %1$s is not writable", file.getPath()));
        }
        CommandProcessor.getInstance().runUndoTransparentAction(() -> {
            try {
                WriteAction.run(() -> {
                    VirtualFile virtualFile;
                    boolean updated;
                    for (BuildFileKey key : PROJECT_PROPERTIES) {
                        if (key == BuildFileKey.GRADLE_WRAPPER_VERSION || !this.myModifiedKeys.contains((Object)key)) continue;
                        Object value = this.myProjectProperties.get((Object)key);
                        if (value != null) {
                            this.myGradleBuildFile.setValue(key, value);
                            continue;
                        }
                        this.myGradleBuildFile.removeValue(null, key);
                    }
                    Object wrapperVersion = this.myProjectProperties.get((Object)BuildFileKey.GRADLE_WRAPPER_VERSION);
                    GradleWrapper gradleWrapper = GradleWrapper.find(this.myProject);
                    if (wrapperVersion != null && gradleWrapper != null && (updated = gradleWrapper.updateDistributionUrlAndDisplayFailure(wrapperVersion.toString())) && (virtualFile = gradleWrapper.getPropertiesFile()) != null) {
                        virtualFile.refresh(false, false);
                    }
                    this.myModifiedKeys.clear();
                });
            }
            catch (Exception e) {
                LOG.error("Error while applying changes", (Throwable)e);
            }
        });
    }

    public void reset() {
        this.myProjectProperties.clear();
        if (this.myGradleBuildFile == null) {
            return;
        }
        for (BuildFileKey key : PROJECT_PROPERTIES) {
            Object value = this.myGradleBuildFile.getValue(key);
            if (value == null) continue;
            this.myProjectProperties.put(key, value);
        }
        try {
            GradleWrapper gradleWrapper = GradleWrapper.find(this.myProject);
            if (gradleWrapper != null) {
                String wrapperVersion = gradleWrapper.getGradleVersion();
                this.myProjectProperties.put(BuildFileKey.GRADLE_WRAPPER_VERSION, wrapperVersion);
            }
        }
        catch (Exception e) {
            LOG.warn("Error while saving Gradle wrapper properties", (Throwable)e);
        }
        this.myKeyValuePane.setCurrentBuildFileObject(this.myProjectProperties);
        this.myKeyValuePane.updateUiFromCurrentObject();
    }

    @Nullable
    public Icon getIcon(boolean expanded) {
        return AllIcons.Nodes.Project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/gradle/structure/editors/AndroidProjectConfigurable", "modified"));
    }
}

