/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.java.dependencies;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.details.ModuleDependencyDetails;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.details.SingleLibraryDependencyDetails;
import com.android.tools.idea.gradle.structure.configurables.issues.IssuesViewer;
import com.android.tools.idea.gradle.structure.configurables.issues.SingleModuleIssuesRenderer;
import com.android.tools.idea.gradle.structure.configurables.java.dependencies.DeclaredDependenciesTableModel;
import com.android.tools.idea.gradle.structure.configurables.ui.dependencies.AbstractDependenciesPanel;
import com.android.tools.idea.gradle.structure.configurables.ui.dependencies.DeclaredDependenciesTableView;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsModel;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.java.PsJavaDependency;
import com.android.tools.idea.gradle.structure.model.java.PsJavaModule;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MainPanel
extends AbstractDependenciesPanel {
    @NotNull
    private final PsContext myContext;
    @NotNull
    private final DeclaredDependenciesTableModel myDependenciesTableModel;
    @NotNull
    private final DeclaredDependenciesTableView<PsJavaDependency> myDependenciesTable;
    @NotNull
    private final String myPlaceName;

    MainPanel(@NotNull PsJavaModule module, @NotNull PsContext context) {
        if (module == null) {
            MainPanel.$$$reportNull$$$0(0);
        }
        if (context == null) {
            MainPanel.$$$reportNull$$$0(1);
        }
        super("Declared Dependencies", context, module);
        this.myContext = context;
        this.myContext.getAnalyzerDaemon().add((PsModel model) -> {
            if (module == null) {
                MainPanel.$$$reportNull$$$0(7);
            }
            if (model == module) {
                UIUtil.invokeLaterIfNeeded(this::updateDetailsAndIssues);
            }
        }, this);
        this.myPlaceName = MainPanel.createPlaceName(module.getName());
        this.getContentsPanel().add((Component)this.createActionsPanel(), "North");
        this.initializeDependencyDetails();
        this.setIssuesViewer(new IssuesViewer(this.myContext, new SingleModuleIssuesRenderer(this.myContext)));
        this.myDependenciesTableModel = new DeclaredDependenciesTableModel(module, this.myContext);
        this.myDependenciesTable = new DeclaredDependenciesTableView<PsJavaDependency>(this.myDependenciesTableModel, this.myContext);
        module.add((PsModule.DependencyChangedEvent event) -> {
            PsDependency dependency;
            this.myDependenciesTableModel.reset();
            PsJavaDependency toSelect = null;
            if (event instanceof PsModule.LibraryDependencyAddedEvent) {
                this.myDependenciesTable.clearSelection();
                PsArtifactDependencySpec spec = ((PsModule.LibraryDependencyAddedEvent)event).getSpec();
                toSelect = this.myDependenciesTableModel.findDependency(spec);
            } else if (event instanceof PsModule.DependencyModifiedEvent && (dependency = ((PsModule.DependencyModifiedEvent)event).getDependency()) instanceof PsJavaDependency) {
                toSelect = (PsJavaDependency)dependency;
            }
            if (toSelect != null) {
                this.myDependenciesTable.setSelection(Collections.singletonList(toSelect));
            }
        }, this);
        ListSelectionListener tableSelectionListener = e -> this.updateDetailsAndIssues();
        this.myDependenciesTable.getSelectionModel().addListSelectionListener(tableSelectionListener);
        this.myDependenciesTable.selectFirstRow();
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(this.myDependenciesTable);
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        this.getContentsPanel().add((Component)scrollPane, "Center");
        this.myDependenciesTable.updateColumnSizes();
    }

    @NotNull
    private static String createPlaceName(@NotNull String moduleName) {
        if (moduleName == null) {
            MainPanel.$$$reportNull$$$0(2);
        }
        String string = "dependencies." + moduleName + ".place";
        if (string == null) {
            MainPanel.$$$reportNull$$$0(3);
        }
        return string;
    }

    private void initializeDependencyDetails() {
        this.addDetails(new SingleLibraryDependencyDetails());
        this.addDetails(new ModuleDependencyDetails(this.getContext(), true));
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        DeclaredDependenciesTableView<PsJavaDependency> declaredDependenciesTableView = this.myDependenciesTable;
        if (declaredDependenciesTableView == null) {
            MainPanel.$$$reportNull$$$0(4);
        }
        return declaredDependenciesTableView;
    }

    @Override
    @NotNull
    protected String getPlaceName() {
        String string = this.myPlaceName;
        if (string == null) {
            MainPanel.$$$reportNull$$$0(5);
        }
        return string;
    }

    private void updateDetailsAndIssues() {
        PsJavaDependency selected = this.myDependenciesTable.getSelectionIfSingle();
        super.updateDetails(selected);
        this.updateIssues(selected);
        History history = this.getHistory();
        if (history != null) {
            history.pushQueryPlace();
        }
    }

    private void updateIssues(@Nullable PsJavaDependency selected) {
        List<PsIssue> issues = Collections.emptyList();
        if (selected != null) {
            issues = this.myContext.getAnalyzerDaemon().getIssues().findIssues(selected, null);
        }
        this.displayIssues(issues);
    }

    @Override
    public void selectDependency(@Nullable String dependency) {
        if (StringUtil.isEmpty((String)dependency)) {
            this.myDependenciesTable.requestFocusInWindow();
            this.myDependenciesTable.clearSelection();
            return;
        }
        this.doSelectDependency(dependency);
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        String pathText;
        Object path;
        if (place != null && (path = place.getPath(this.myPlaceName)) instanceof String && !(pathText = (String)path).isEmpty()) {
            this.doSelectDependency(pathText);
        }
        return ActionCallback.DONE;
    }

    private void doSelectDependency(@NotNull String toSelect) {
        if (toSelect == null) {
            MainPanel.$$$reportNull$$$0(6);
        }
        this.myDependenciesTable.selectDependency(toSelect);
    }

    public void dispose() {
        Disposer.dispose(this.myDependenciesTable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/configurables/java/dependencies/MainPanel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSelect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/configurables/java/dependencies/MainPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPlaceName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createPlaceName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doSelectDependency";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

