/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables;

import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.structure.FastGradleSync;
import com.android.tools.idea.gradle.structure.daemon.PsAnalyzerDaemon;
import com.android.tools.idea.gradle.structure.daemon.PsLibraryUpdateCheckerDaemon;
import com.android.tools.idea.gradle.structure.model.PsProject;
import com.android.tools.idea.structure.dialog.ProjectStructureConfigurable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsContext
implements Disposable {
    @NotNull
    private final PsProject myProject;
    @NotNull
    private final PsAnalyzerDaemon myAnalyzerDaemon;
    @NotNull
    private final FastGradleSync myGradleSync;
    @NotNull
    private final PsLibraryUpdateCheckerDaemon myLibraryUpdateCheckerDaemon;
    @NotNull
    private final EventDispatcher<ChangeListener> myChangeEventDispatcher;
    @NotNull
    private final EventDispatcher<GradleSyncListener> myGradleSyncEventDispatcher;
    @Nullable
    private String mySelectedModuleName;

    public PsContext(@NotNull PsProject project, @NotNull Disposable parentDisposable) {
        if (project == null) {
            PsContext.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            PsContext.$$$reportNull$$$0(1);
        }
        this.myChangeEventDispatcher = EventDispatcher.create(ChangeListener.class);
        this.myGradleSyncEventDispatcher = EventDispatcher.create(GradleSyncListener.class);
        this.myProject = project;
        this.myGradleSync = new FastGradleSync();
        this.getMainConfigurable().add(this::requestGradleSync, this);
        this.myLibraryUpdateCheckerDaemon = new PsLibraryUpdateCheckerDaemon(this);
        this.myLibraryUpdateCheckerDaemon.reset();
        this.myLibraryUpdateCheckerDaemon.queueAutomaticUpdateCheck();
        this.myAnalyzerDaemon = new PsAnalyzerDaemon(this, this.myLibraryUpdateCheckerDaemon);
        this.myAnalyzerDaemon.reset();
        this.myProject.forEachModule(this.myAnalyzerDaemon::queueCheck);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    private void requestGradleSync() {
        Project project = this.myProject.getResolvedModel();
        ((GradleSyncListener)this.myGradleSyncEventDispatcher.getMulticaster()).syncStarted(project, false, false);
        FastGradleSync.Callback callback = this.myGradleSync.requestProjectSync(project);
        callback.doWhenDone(() -> ((GradleSyncListener)this.myGradleSyncEventDispatcher.getMulticaster()).syncSucceeded(project));
        callback.doWhenRejected(() -> {
            Throwable failure = callback.getFailure();
            assert (failure != null);
            ((GradleSyncListener)this.myGradleSyncEventDispatcher.getMulticaster()).syncFailed(project, ExceptionUtil.getRootCause((Throwable)failure).getMessage());
        });
    }

    public void add(@NotNull GradleSyncListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            PsContext.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            PsContext.$$$reportNull$$$0(3);
        }
        this.myGradleSyncEventDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    @NotNull
    public PsAnalyzerDaemon getAnalyzerDaemon() {
        PsAnalyzerDaemon psAnalyzerDaemon = this.myAnalyzerDaemon;
        if (psAnalyzerDaemon == null) {
            PsContext.$$$reportNull$$$0(4);
        }
        return psAnalyzerDaemon;
    }

    @NotNull
    public PsLibraryUpdateCheckerDaemon getLibraryUpdateCheckerDaemon() {
        PsLibraryUpdateCheckerDaemon psLibraryUpdateCheckerDaemon = this.myLibraryUpdateCheckerDaemon;
        if (psLibraryUpdateCheckerDaemon == null) {
            PsContext.$$$reportNull$$$0(5);
        }
        return psLibraryUpdateCheckerDaemon;
    }

    @Nullable
    public String getSelectedModule() {
        return this.mySelectedModuleName;
    }

    public void setSelectedModule(@NotNull String moduleName, @NotNull Object source) {
        if (moduleName == null) {
            PsContext.$$$reportNull$$$0(6);
        }
        if (source == null) {
            PsContext.$$$reportNull$$$0(7);
        }
        this.mySelectedModuleName = moduleName;
        ((ChangeListener)this.myChangeEventDispatcher.getMulticaster()).moduleSelectionChanged(this.mySelectedModuleName, source);
    }

    public void add(@NotNull ChangeListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            PsContext.$$$reportNull$$$0(8);
        }
        if (parentDisposable == null) {
            PsContext.$$$reportNull$$$0(9);
        }
        this.myChangeEventDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    @NotNull
    public PsProject getProject() {
        PsProject psProject = this.myProject;
        if (psProject == null) {
            PsContext.$$$reportNull$$$0(10);
        }
        return psProject;
    }

    public void dispose() {
    }

    @NotNull
    public ProjectStructureConfigurable getMainConfigurable() {
        ProjectStructureConfigurable projectStructureConfigurable = ProjectStructureConfigurable.getInstance(this.myProject.getResolvedModel());
        if (projectStructureConfigurable == null) {
            PsContext.$$$reportNull$$$0(11);
        }
        return projectStructureConfigurable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/configurables/PsContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/configurables/PsContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnalyzerDaemon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryUpdateCheckerDaemon";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ChangeListener
    extends EventListener {
        public void moduleSelectionChanged(@NotNull String var1, @NotNull Object var2);
    }
}

