/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.refactoring;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ModuleDependencyModel;
import com.android.tools.idea.gradle.parser.GradleSettingsFile;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.RenameHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleRenameModuleHandler
implements RenameHandler,
TitledHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        Module module;
        if (dataContext == null) {
            GradleRenameModuleHandler.$$$reportNull$$$0(0);
        }
        return (module = GradleRenameModuleHandler.getGradleModule(dataContext)) != null && GradleRenameModuleHandler.getModuleRootDir(module) != null;
    }

    @Nullable
    private static VirtualFile getModuleRootDir(@NotNull Module module) {
        if (module == null) {
            GradleRenameModuleHandler.$$$reportNull$$$0(1);
        }
        File moduleFilePath = new File(module.getModuleFilePath());
        return VfsUtil.findFileByIoFile((File)moduleFilePath.getParentFile(), (boolean)true);
    }

    public boolean isRenaming(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            GradleRenameModuleHandler.$$$reportNull$$$0(2);
        }
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file, @NotNull DataContext dataContext) {
        if (project == null) {
            GradleRenameModuleHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            GradleRenameModuleHandler.$$$reportNull$$$0(4);
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @NotNull DataContext dataContext) {
        if (project == null) {
            GradleRenameModuleHandler.$$$reportNull$$$0(5);
        }
        if (elements == null) {
            GradleRenameModuleHandler.$$$reportNull$$$0(6);
        }
        if (dataContext == null) {
            GradleRenameModuleHandler.$$$reportNull$$$0(7);
        }
        Module module = GradleRenameModuleHandler.getGradleModule(dataContext);
        assert (module != null);
        Messages.showInputDialog((Project)project, (String)IdeBundle.message((String)"prompt.enter.new.module.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)module.getName(), (InputValidator)new MyInputValidator(module));
    }

    @Nullable
    private static Module getGradleModule(@NotNull DataContext dataContext) {
        Module module;
        if (dataContext == null) {
            GradleRenameModuleHandler.$$$reportNull$$$0(8);
        }
        if ((module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext)) != null && (GradleFacet.getInstance(module) != null || GradleProjects.isGradleProjectModule(module))) {
            return module;
        }
        return null;
    }

    @NotNull
    public String getActionTitle() {
        String string = RefactoringBundle.message((String)"rename.module.title");
        if (string == null) {
            GradleRenameModuleHandler.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static void requestSync(@NotNull Project project) {
        if (project == null) {
            GradleRenameModuleHandler.$$$reportNull$$$0(10);
        }
        GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED);
    }

    private static String getNewPath(@NotNull String oldPath, @NotNull String newName2) {
        String newPath;
        List segments;
        ArrayList modifiableSegments;
        int segmentCount;
        if (oldPath == null) {
            GradleRenameModuleHandler.$$$reportNull$$$0(11);
        }
        if (newName2 == null) {
            GradleRenameModuleHandler.$$$reportNull$$$0(12);
        }
        if ((segmentCount = (modifiableSegments = Lists.newArrayList((Iterable)(segments = Splitter.on((String)":").splitToList((CharSequence)oldPath)))).size()) == 0) {
            newPath = ":" + newName2.trim();
        } else {
            modifiableSegments.set(segmentCount - 1, newName2);
            newPath = Joiner.on((String)":").join((Iterable)modifiableSegments);
        }
        return newPath;
    }

    private static void reset(@NotNull List<GradleBuildModel> buildModels) {
        if (buildModels == null) {
            GradleRenameModuleHandler.$$$reportNull$$$0(13);
        }
        for (GradleBuildModel buildModel : buildModels) {
            buildModel.resetState();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/refactoring/GradleRenameModuleHandler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/refactoring/GradleRenameModuleHandler";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getModuleRootDir";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isRenaming";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getGradleModule";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "requestSync";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getNewPath";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyInputValidator
    implements InputValidator {
        @NotNull
        private final Module myModule;

        MyInputValidator(@NotNull Module module) {
            if (module == null) {
                MyInputValidator.$$$reportNull$$$0(0);
            }
            this.myModule = module;
        }

        public boolean checkInput(@Nullable String inputString) {
            return inputString != null && !inputString.isEmpty() && !inputString.equals(this.myModule.getName()) && !inputString.contains(":");
        }

        public boolean canClose(final @NotNull String inputString) {
            Project project;
            GradleSettingsModel settingsModel;
            if (inputString == null) {
                MyInputValidator.$$$reportNull$$$0(1);
            }
            if ((settingsModel = GradleSettingsModel.get(project = this.myModule.getProject())) == null) {
                Messages.showErrorDialog((Project)project, (String)"settings.gradle file not found", (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
                return true;
            }
            final VirtualFile moduleRoot = GradleRenameModuleHandler.getModuleRootDir(this.myModule);
            assert (moduleRoot != null);
            if (GradleProjects.isGradleProjectModule(this.myModule)) {
                Messages.showErrorDialog((Project)project, (String)"Can't rename root module", (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
                return true;
            }
            final String oldModuleGradlePath = GradleSettingsFile.getModuleGradlePath(this.myModule);
            if (oldModuleGradlePath == null) {
                return true;
            }
            final ArrayList modifiedBuildModels = Lists.newArrayList();
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                GradleBuildModel buildModel = GradleBuildModel.get(module);
                if (buildModel == null) continue;
                DependenciesModel dependenciesModel = buildModel.dependencies();
                if (dependenciesModel != null) {
                    for (ModuleDependencyModel dependency : dependenciesModel.modules()) {
                        if (!oldModuleGradlePath.equals(dependency.path().value())) continue;
                        dependency.setPath(GradleRenameModuleHandler.getNewPath(dependency.path().value(), inputString));
                    }
                }
                if (!buildModel.isModified()) continue;
                modifiedBuildModels.add(buildModel);
            }
            String msg = IdeBundle.message((String)"command.renaming.module", (Object[])new Object[]{this.myModule.getName()});
            WriteCommandAction<Boolean> action = new WriteCommandAction<Boolean>(project, msg, new PsiFile[0]){

                protected void run(@NotNull Result<Boolean> result) throws Throwable {
                    if (result == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    result.setResult((Object)true);
                    if (!settingsModel.modulePaths().contains(oldModuleGradlePath)) {
                        Messages.showErrorDialog((Project)project, (String)("Can't find module '" + myModule.getName() + "' in settings.gradle"), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
                        GradleRenameModuleHandler.reset(modifiedBuildModels);
                        return;
                    }
                    ModifiableModuleModel modifiableModel = ModuleManager.getInstance((Project)project).getModifiableModel();
                    try {
                        modifiableModel.renameModule(myModule, inputString);
                    }
                    catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (inputString == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            Messages.showErrorDialog((Project)project, (String)IdeBundle.message((String)"error.module.already.exists", (Object[])new Object[]{inputString}), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
                        });
                        result.setResult((Object)false);
                        GradleRenameModuleHandler.reset(modifiedBuildModels);
                        return;
                    }
                    settingsModel.replaceModulePath(oldModuleGradlePath, GradleRenameModuleHandler.getNewPath(oldModuleGradlePath, inputString));
                    for (GradleBuildModel buildModel : modifiedBuildModels) {
                        buildModel.applyChanges();
                    }
                    settingsModel.applyChanges();
                    try {
                        moduleRoot.rename((Object)this, inputString);
                    }
                    catch (IOException e) {
                        ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)("Rename folder failed: " + e.getMessage()), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0])));
                        result.setResult((Object)false);
                        GradleRenameModuleHandler.reset(modifiedBuildModels);
                        return;
                    }
                    modifiableModel.commit();
                    UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(){

                        public void undo() throws UnexpectedUndoException {
                            GradleRenameModuleHandler.requestSync(project);
                        }

                        public void redo() throws UnexpectedUndoException {
                            GradleRenameModuleHandler.requestSync(project);
                        }
                    });
                    result.setResult((Object)true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "result";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "inputString";
                            break;
                        }
                    }
                    objectArray2[1] = "com/android/tools/idea/gradle/refactoring/GradleRenameModuleHandler$MyInputValidator$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "run";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$run$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            if (((Boolean)action.execute().getResultObject()).booleanValue()) {
                GradleRenameModuleHandler.requestSync(project);
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputString";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/refactoring/GradleRenameModuleHandler$MyInputValidator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canClose";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

