/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.AndroidGradleProjectComponent;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.importing.GradleProjectImporter;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.ng.ProjectSetup;
import com.android.tools.idea.gradle.project.sync.ng.SyncExecutionCallback;
import com.android.tools.idea.gradle.project.sync.ng.SyncProjectModels;
import com.android.tools.idea.gradle.project.sync.ng.caching.CachedProjectModels;
import com.android.tools.idea.gradle.project.sync.ng.caching.ModelNotFoundInCacheException;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

class SyncResultHandler {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleSyncState mySyncState;
    @NotNull
    private final GradleProjectInfo myProjectInfo;
    @NotNull
    private final ProjectSetup.Factory myProjectSetupFactory;
    @NotNull
    private final PostSyncProjectSetup myPostSyncProjectSetup;

    SyncResultHandler(@NotNull Project project) {
        if (project == null) {
            SyncResultHandler.$$$reportNull$$$0(0);
        }
        this(project, GradleSyncState.getInstance(project), GradleProjectInfo.getInstance(project), new ProjectSetup.Factory(), PostSyncProjectSetup.getInstance(project));
    }

    @VisibleForTesting
    SyncResultHandler(@NotNull Project project, @NotNull GradleSyncState syncState, @NotNull GradleProjectInfo projectInfo, @NotNull ProjectSetup.Factory projectSetupFactory, @NotNull PostSyncProjectSetup postSyncProjectSetup) {
        if (project == null) {
            SyncResultHandler.$$$reportNull$$$0(1);
        }
        if (syncState == null) {
            SyncResultHandler.$$$reportNull$$$0(2);
        }
        if (projectInfo == null) {
            SyncResultHandler.$$$reportNull$$$0(3);
        }
        if (projectSetupFactory == null) {
            SyncResultHandler.$$$reportNull$$$0(4);
        }
        if (postSyncProjectSetup == null) {
            SyncResultHandler.$$$reportNull$$$0(5);
        }
        this.myProject = project;
        this.mySyncState = syncState;
        this.myProjectInfo = projectInfo;
        this.myProjectSetupFactory = projectSetupFactory;
        this.myPostSyncProjectSetup = postSyncProjectSetup;
    }

    void onSyncFinished(@NotNull SyncExecutionCallback callback, @NotNull PostSyncProjectSetup.Request setupRequest, @NotNull ProgressIndicator indicator, @Nullable GradleSyncListener syncListener) {
        block8: {
            SyncProjectModels models;
            if (callback == null) {
                SyncResultHandler.$$$reportNull$$$0(6);
            }
            if (setupRequest == null) {
                SyncResultHandler.$$$reportNull$$$0(7);
            }
            if (indicator == null) {
                SyncResultHandler.$$$reportNull$$$0(8);
            }
            if ((models = callback.getModels()) != null) {
                try {
                    this.setUpProject(models, setupRequest, indicator, syncListener);
                    Runnable runnable = () -> {
                        boolean isTest = ApplicationManager.getApplication().isUnitTestMode();
                        boolean isImportedProject = this.myProjectInfo.isImportedProject();
                        if (!(!isImportedProject || isTest && GradleProjectImporter.ourSkipSetupFromTest)) {
                            GradleProjects.open(this.myProject);
                        }
                        if (!isTest) {
                            this.myProject.save();
                        }
                        if (isImportedProject) {
                            AndroidGradleProjectComponent projectComponent = AndroidGradleProjectComponent.getInstance(this.myProject);
                            projectComponent.configureGradleProject();
                        }
                    };
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        runnable.run();
                        break block8;
                    }
                    ExternalSystemUtil.invokeLater((Project)this.myProject, (Runnable)runnable);
                }
                catch (Throwable e) {
                    this.notifyAndLogSyncError(SyncResultHandler.nullToUnknownErrorCause(SyncResultHandler.getRootCauseMessage(e)), e, syncListener);
                }
            } else {
                this.notifyAndLogSyncError("Gradle did not return any project models", null, syncListener);
            }
        }
    }

    private void setUpProject(@NotNull SyncProjectModels models, @NotNull PostSyncProjectSetup.Request setupRequest, @NotNull ProgressIndicator indicator, @Nullable GradleSyncListener syncListener) {
        if (models == null) {
            SyncResultHandler.$$$reportNull$$$0(9);
        }
        if (setupRequest == null) {
            SyncResultHandler.$$$reportNull$$$0(10);
        }
        if (indicator == null) {
            SyncResultHandler.$$$reportNull$$$0(11);
        }
        try {
            if (syncListener != null) {
                syncListener.setupStarted(this.myProject);
            }
            this.mySyncState.setupStarted();
            ProjectSetup projectSetup = this.myProjectSetupFactory.create(this.myProject);
            projectSetup.setUpProject(models, indicator);
            projectSetup.commit();
            ExternalSystemUtil.scheduleExternalViewStructureUpdate((Project)this.myProject, (ProjectSystemId)GradleConstants.SYSTEM_ID);
            if (syncListener != null) {
                syncListener.syncSucceeded(this.myProject);
            }
            StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> {
                if (setupRequest == null) {
                    SyncResultHandler.$$$reportNull$$$0(23);
                }
                if (indicator == null) {
                    SyncResultHandler.$$$reportNull$$$0(24);
                }
                this.myPostSyncProjectSetup.setUpProject(setupRequest, indicator);
            });
        }
        catch (Throwable e) {
            this.notifyAndLogSyncError(SyncResultHandler.nullToUnknownErrorCause(SyncResultHandler.getRootCauseMessage(e)), e, syncListener);
        }
    }

    void onSyncSkipped(@NotNull CachedProjectModels projectModelsCache, @NotNull PostSyncProjectSetup.Request setupRequest, @NotNull ProgressIndicator indicator, @Nullable GradleSyncListener syncListener) throws ModelNotFoundInCacheException {
        if (projectModelsCache == null) {
            SyncResultHandler.$$$reportNull$$$0(12);
        }
        if (setupRequest == null) {
            SyncResultHandler.$$$reportNull$$$0(13);
        }
        if (indicator == null) {
            SyncResultHandler.$$$reportNull$$$0(14);
        }
        if (syncListener != null) {
            syncListener.setupStarted(this.myProject);
        }
        this.mySyncState.setupStarted();
        ProjectSetup projectSetup = this.myProjectSetupFactory.create(this.myProject);
        projectSetup.setUpProject(projectModelsCache, indicator);
        projectSetup.commit();
        if (syncListener != null) {
            syncListener.syncSkipped(this.myProject);
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> {
            if (setupRequest == null) {
                SyncResultHandler.$$$reportNull$$$0(21);
            }
            if (indicator == null) {
                SyncResultHandler.$$$reportNull$$$0(22);
            }
            this.myPostSyncProjectSetup.setUpProject(setupRequest, indicator);
        });
    }

    void onSyncFailed(@NotNull SyncExecutionCallback callback, @Nullable GradleSyncListener syncListener) {
        Throwable error;
        if (callback == null) {
            SyncResultHandler.$$$reportNull$$$0(15);
        }
        String errorMessage = (error = callback.getSyncError()) != null ? SyncResultHandler.getRootCauseMessage(error) : callback.getError();
        errorMessage = SyncResultHandler.nullToUnknownErrorCause(errorMessage);
        this.notifyAndLogSyncError(errorMessage, error, syncListener);
    }

    private void notifyAndLogSyncError(@NotNull String errorMessage, @Nullable Throwable error, @Nullable GradleSyncListener syncListener) {
        if (errorMessage == null) {
            SyncResultHandler.$$$reportNull$$$0(16);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && error != null) {
            System.out.println("***** sync error: " + error.getMessage());
            error.printStackTrace();
        }
        if (syncListener != null) {
            syncListener.syncFailed(this.myProject, errorMessage);
        }
        this.mySyncState.syncFailed(errorMessage);
        if (error != null) {
            SyncResultHandler.getLog().warn("Gradle sync failed", error);
        } else {
            SyncResultHandler.logSyncFailure(errorMessage);
        }
    }

    @Nullable
    private static String getRootCauseMessage(@NotNull Throwable error) {
        Throwable rootCause;
        String message;
        if (error == null) {
            SyncResultHandler.$$$reportNull$$$0(17);
        }
        return StringUtil.isEmpty((String)(message = (rootCause = ExceptionUtil.getRootCause((Throwable)error)).getMessage())) ? rootCause.getClass().getName() : message;
    }

    @NotNull
    private static String nullToUnknownErrorCause(@Nullable String errorMessage) {
        String string = StringUtil.isEmpty((String)errorMessage) ? "<Unknown cause>" : errorMessage;
        if (string == null) {
            SyncResultHandler.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static void logSyncFailure(@NotNull String errorMessage) {
        if (errorMessage == null) {
            SyncResultHandler.$$$reportNull$$$0(19);
        }
        SyncResultHandler.getLog().warn("Gradle sync failed: " + errorMessage);
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(SyncResultHandler.class);
        if (logger == null) {
            SyncResultHandler.$$$reportNull$$$0(20);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncState";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSetupFactory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postSyncProjectSetup";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setupRequest";
                break;
            }
            case 8: 
            case 11: 
            case 14: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectModelsCache";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ng/SyncResultHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/SyncResultHandler";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "nullToUnknownErrorCause";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onSyncFinished";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setUpProject";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "onSyncSkipped";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "onSyncFailed";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "notifyAndLogSyncError";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRootCauseMessage";
                break;
            }
            case 18: 
            case 20: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "logSyncFailure";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$onSyncSkipped$2";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setUpProject$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

