/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.ProjectBuildFileChecksums;
import com.android.tools.idea.gradle.project.sync.GradleSync;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.ng.SyncExecutionCallback;
import com.android.tools.idea.gradle.project.sync.ng.SyncExecutor;
import com.android.tools.idea.gradle.project.sync.ng.SyncResultHandler;
import com.android.tools.idea.gradle.project.sync.ng.caching.CachedProjectModels;
import com.android.tools.idea.gradle.project.sync.ng.caching.ModelNotFoundInCacheException;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewGradleSync
implements GradleSync {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleSyncMessages mySyncMessages;
    @NotNull
    private final SyncExecutor mySyncExecutor;
    @NotNull
    private final SyncResultHandler myResultHandler;
    @NotNull
    private final ProjectBuildFileChecksums.Loader myBuildFileChecksumsLoader;
    @NotNull
    private final CachedProjectModels.Loader myProjectModelsCacheLoader;
    @NotNull
    private final SyncExecutionCallback.Factory myCallbackFactory;

    public static boolean isLevel4Model() {
        return NewGradleSync.isEnabled();
    }

    public static boolean isEnabled() {
        return (Boolean)StudioFlags.NEW_SYNC_INFRA_ENABLED.get();
    }

    public NewGradleSync(@NotNull Project project) {
        if (project == null) {
            NewGradleSync.$$$reportNull$$$0(0);
        }
        this(project, GradleSyncMessages.getInstance(project), new SyncExecutor(project), new SyncResultHandler(project), new ProjectBuildFileChecksums.Loader(), new CachedProjectModels.Loader(), new SyncExecutionCallback.Factory());
    }

    @VisibleForTesting
    NewGradleSync(@NotNull Project project, @NotNull GradleSyncMessages syncMessages, @NotNull SyncExecutor syncExecutor, @NotNull SyncResultHandler resultHandler, @NotNull ProjectBuildFileChecksums.Loader buildFileChecksumsLoader, @NotNull CachedProjectModels.Loader projectModelsCacheLoader, @NotNull SyncExecutionCallback.Factory callbackFactory) {
        if (project == null) {
            NewGradleSync.$$$reportNull$$$0(1);
        }
        if (syncMessages == null) {
            NewGradleSync.$$$reportNull$$$0(2);
        }
        if (syncExecutor == null) {
            NewGradleSync.$$$reportNull$$$0(3);
        }
        if (resultHandler == null) {
            NewGradleSync.$$$reportNull$$$0(4);
        }
        if (buildFileChecksumsLoader == null) {
            NewGradleSync.$$$reportNull$$$0(5);
        }
        if (projectModelsCacheLoader == null) {
            NewGradleSync.$$$reportNull$$$0(6);
        }
        if (callbackFactory == null) {
            NewGradleSync.$$$reportNull$$$0(7);
        }
        this.myProject = project;
        this.mySyncMessages = syncMessages;
        this.mySyncExecutor = syncExecutor;
        this.myResultHandler = resultHandler;
        this.myBuildFileChecksumsLoader = buildFileChecksumsLoader;
        this.myProjectModelsCacheLoader = projectModelsCacheLoader;
        this.myCallbackFactory = callbackFactory;
    }

    @Override
    public void sync(@NotNull GradleSyncInvoker.Request request, @Nullable GradleSyncListener listener) {
        Application application;
        if (request == null) {
            NewGradleSync.$$$reportNull$$$0(8);
        }
        if ((application = ApplicationManager.getApplication()).isUnitTestMode()) {
            this.mySyncMessages.removeAllMessages();
            this.sync(request, (ProgressIndicator)new EmptyProgressIndicator(), listener);
            return;
        }
        Task task = this.createSyncTask(request, listener);
        application.invokeLater(() -> {
            this.mySyncMessages.removeAllMessages();
            task.queue();
        }, ModalityState.defaultModalityState());
    }

    @VisibleForTesting
    @NotNull
    Task createSyncTask(final @NotNull GradleSyncInvoker.Request request, final @Nullable GradleSyncListener listener) {
        Object syncTask;
        if (request == null) {
            NewGradleSync.$$$reportNull$$$0(9);
        }
        String title = "Gradle Sync";
        ProgressExecutionMode executionMode = request.getProgressExecutionMode();
        switch (executionMode) {
            case MODAL_SYNC: {
                syncTask = new Task.Modal(this.myProject, title, true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        NewGradleSync.this.sync(request, indicator, listener);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/gradle/project/sync/ng/NewGradleSync$1", "run"));
                    }
                };
                break;
            }
            case IN_BACKGROUND_ASYNC: {
                syncTask = new Task.Backgroundable(this.myProject, title, true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        NewGradleSync.this.sync(request, indicator, listener);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/gradle/project/sync/ng/NewGradleSync$2", "run"));
                    }
                };
                break;
            }
            default: {
                throw new IllegalArgumentException(executionMode + " is not a supported execution mode");
            }
        }
        Object object = syncTask;
        if (object == null) {
            NewGradleSync.$$$reportNull$$$0(10);
        }
        return object;
    }

    private void sync(@NotNull GradleSyncInvoker.Request request, @NotNull ProgressIndicator indicator, @Nullable GradleSyncListener syncListener) {
        CachedProjectModels projectModelsCache;
        ProjectBuildFileChecksums buildFileChecksums;
        if (request == null) {
            NewGradleSync.$$$reportNull$$$0(11);
        }
        if (indicator == null) {
            NewGradleSync.$$$reportNull$$$0(12);
        }
        if (request.useCachedGradleModels && (buildFileChecksums = this.myBuildFileChecksumsLoader.loadFromDisk(this.myProject)) != null && buildFileChecksums.canUseCachedData() && (projectModelsCache = this.myProjectModelsCacheLoader.loadFromDisk(this.myProject)) != null) {
            PostSyncProjectSetup.Request setupRequest = new PostSyncProjectSetup.Request();
            setupRequest.usingCachedGradleModels = true;
            setupRequest.generateSourcesAfterSync = false;
            setupRequest.lastSyncTimestamp = buildFileChecksums.getLastGradleSyncTimestamp();
            NewGradleSync.setSkipAndroidPluginUpgrade(request, setupRequest);
            try {
                this.myResultHandler.onSyncSkipped(projectModelsCache, setupRequest, indicator, syncListener);
                return;
            }
            catch (ModelNotFoundInCacheException e) {
                Logger.getInstance(NewGradleSync.class).warn("Restoring project state from cache failed. Performing a Gradle Sync.", (Throwable)e);
            }
        }
        PostSyncProjectSetup.Request setupRequest = new PostSyncProjectSetup.Request();
        setupRequest.generateSourcesAfterSync = request.generateSourcesOnSuccess;
        setupRequest.cleanProjectAfterSync = request.cleanProject;
        NewGradleSync.setSkipAndroidPluginUpgrade(request, setupRequest);
        SyncExecutionCallback callback = this.myCallbackFactory.create();
        callback.doWhenDone(() -> {
            if (indicator == null) {
                NewGradleSync.$$$reportNull$$$0(15);
            }
            this.myResultHandler.onSyncFinished(callback, setupRequest, indicator, syncListener);
        }).doWhenRejected(() -> this.myResultHandler.onSyncFailed(callback, syncListener));
        this.mySyncExecutor.syncProject(indicator, callback);
    }

    private static void setSkipAndroidPluginUpgrade(@NotNull GradleSyncInvoker.Request syncRequest, @NotNull PostSyncProjectSetup.Request setupRequest) {
        if (syncRequest == null) {
            NewGradleSync.$$$reportNull$$$0(13);
        }
        if (setupRequest == null) {
            NewGradleSync.$$$reportNull$$$0(14);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && syncRequest.skipAndroidPluginUpgrade) {
            setupRequest.skipAndroidPluginUpgrade = true;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncMessages";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncExecutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFileChecksumsLoader";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectModelsCacheLoader";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callbackFactory";
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ng/NewGradleSync";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncRequest";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setupRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/NewGradleSync";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createSyncTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "sync";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createSyncTask";
                break;
            }
            case 10: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setSkipAndroidPluginUpgrade";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$sync$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

