/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.Variant;
import com.android.builder.model.level2.GlobalLibraryMap;
import com.android.ide.common.gradle.model.IdeNativeAndroidProject;
import com.android.ide.common.gradle.model.IdeNativeAndroidProjectImpl;
import com.android.ide.common.gradle.model.level2.IdeDependenciesFactory;
import com.android.java.model.ArtifactModel;
import com.android.java.model.JavaProject;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModelFactory;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.common.VariantSelector;
import com.android.tools.idea.gradle.project.sync.ng.AndroidModuleProcessor;
import com.android.tools.idea.gradle.project.sync.ng.ExtraGradleSyncModelsManager;
import com.android.tools.idea.gradle.project.sync.ng.GradleModuleModels;
import com.android.tools.idea.gradle.project.sync.ng.GradleSyncProgress;
import com.android.tools.idea.gradle.project.sync.ng.ModuleFactory;
import com.android.tools.idea.gradle.project.sync.ng.ObsoleteModuleDisposer;
import com.android.tools.idea.gradle.project.sync.ng.ProjectDataNodeSetup;
import com.android.tools.idea.gradle.project.sync.ng.SyncProjectModels;
import com.android.tools.idea.gradle.project.sync.ng.caching.CachedModuleModels;
import com.android.tools.idea.gradle.project.sync.ng.caching.CachedProjectModels;
import com.android.tools.idea.gradle.project.sync.ng.caching.ModelNotFoundInCacheException;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.AndroidModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.GradleModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.ModuleFinder;
import com.android.tools.idea.gradle.project.sync.setup.module.NdkModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.JavaModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectCleanup;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.intellij.concurrency.JobLauncher;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.tooling.model.GradleProject;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ModuleSetup {
    ModuleSetup() {
    }

    abstract void setUpModules(@NotNull SyncProjectModels var1, @NotNull ProgressIndicator var2);

    abstract void setUpModules(@NotNull CachedProjectModels var1, @NotNull ProgressIndicator var2) throws ModelNotFoundInCacheException;

    private static class ModuleSetupInfo {
        @NotNull
        final Module module;
        @NotNull
        final GradleModuleModels moduleModels;
        @NotNull
        final CachedModuleModels cachedModels;

        ModuleSetupInfo(@NotNull Module module, @NotNull GradleModuleModels moduleModels, @NotNull CachedModuleModels cachedModels) {
            if (module == null) {
                ModuleSetupInfo.$$$reportNull$$$0(0);
            }
            if (moduleModels == null) {
                ModuleSetupInfo.$$$reportNull$$$0(1);
            }
            if (cachedModels == null) {
                ModuleSetupInfo.$$$reportNull$$$0(2);
            }
            this.module = module;
            this.moduleModels = moduleModels;
            this.cachedModels = cachedModels;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "module";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "moduleModels";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cachedModels";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/project/sync/ng/ModuleSetup$ModuleSetupInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @VisibleForTesting
    static class ModuleSetupImpl
    extends ModuleSetup {
        @NotNull
        private final Project myProject;
        @NotNull
        private final IdeModifiableModelsProvider myModelsProvider;
        @NotNull
        private final ModuleFactory myModuleFactory;
        @NotNull
        private final GradleModuleSetup myGradleModuleSetup;
        @NotNull
        private final AndroidModuleSetup myAndroidModuleSetup;
        @NotNull
        private final NdkModuleSetup myNdkModuleSetup;
        @NotNull
        private final JavaModuleSetup myJavaModuleSetup;
        @NotNull
        private final AndroidModuleProcessor myAndroidModuleProcessor;
        @NotNull
        private final VariantSelector myVariantSelector;
        @NotNull
        private final ProjectCleanup myProjectCleanup;
        @NotNull
        private final ObsoleteModuleDisposer myModuleDisposer;
        @NotNull
        private final CachedProjectModels.Factory myCachedProjectModelsFactory;
        @NotNull
        private final IdeNativeAndroidProject.Factory myNativeAndroidProjectFactory;
        @NotNull
        private final JavaModuleModelFactory myJavaModuleModelFactory;
        @NotNull
        private final ExtraGradleSyncModelsManager myExtraModelsManager;
        @NotNull
        private final IdeDependenciesFactory myDependenciesFactory;
        @NotNull
        private final ProjectDataNodeSetup myProjectDataNodeSetup;
        @NotNull
        private final ModuleSetupContext.Factory myModuleSetupFactory;
        @NotNull
        private final ModuleFinder.Factory myModuleFinderFactory;
        @NotNull
        private final List<Module> myAndroidModules;
        private static final String ROOT_PROJECT_PATH_KEY = "external.root.project.path";

        ModuleSetupImpl(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ExtraGradleSyncModelsManager extraModelsManager, @NotNull ModuleFactory moduleFactory, @NotNull GradleModuleSetup gradleModuleSetup, @NotNull AndroidModuleSetup androidModuleSetup, @NotNull NdkModuleSetup ndkModuleSetup, @NotNull JavaModuleSetup javaModuleSetup, @NotNull AndroidModuleProcessor androidModuleProcessor, @NotNull VariantSelector variantSelector, @NotNull ProjectCleanup projectCleanup, @NotNull ObsoleteModuleDisposer moduleDisposer, @NotNull CachedProjectModels.Factory cachedProjectModelsFactory, @NotNull IdeNativeAndroidProject.Factory nativeAndroidProjectFactory, @NotNull JavaModuleModelFactory javaModuleModelFactory, @NotNull IdeDependenciesFactory dependenciesFactory, @NotNull ProjectDataNodeSetup projectDataNodeSetup, @NotNull ModuleSetupContext.Factory moduleSetupFactory, @NotNull ModuleFinder.Factory moduleFinderFactory) {
            if (project == null) {
                ModuleSetupImpl.$$$reportNull$$$0(0);
            }
            if (modelsProvider == null) {
                ModuleSetupImpl.$$$reportNull$$$0(1);
            }
            if (extraModelsManager == null) {
                ModuleSetupImpl.$$$reportNull$$$0(2);
            }
            if (moduleFactory == null) {
                ModuleSetupImpl.$$$reportNull$$$0(3);
            }
            if (gradleModuleSetup == null) {
                ModuleSetupImpl.$$$reportNull$$$0(4);
            }
            if (androidModuleSetup == null) {
                ModuleSetupImpl.$$$reportNull$$$0(5);
            }
            if (ndkModuleSetup == null) {
                ModuleSetupImpl.$$$reportNull$$$0(6);
            }
            if (javaModuleSetup == null) {
                ModuleSetupImpl.$$$reportNull$$$0(7);
            }
            if (androidModuleProcessor == null) {
                ModuleSetupImpl.$$$reportNull$$$0(8);
            }
            if (variantSelector == null) {
                ModuleSetupImpl.$$$reportNull$$$0(9);
            }
            if (projectCleanup == null) {
                ModuleSetupImpl.$$$reportNull$$$0(10);
            }
            if (moduleDisposer == null) {
                ModuleSetupImpl.$$$reportNull$$$0(11);
            }
            if (cachedProjectModelsFactory == null) {
                ModuleSetupImpl.$$$reportNull$$$0(12);
            }
            if (nativeAndroidProjectFactory == null) {
                ModuleSetupImpl.$$$reportNull$$$0(13);
            }
            if (javaModuleModelFactory == null) {
                ModuleSetupImpl.$$$reportNull$$$0(14);
            }
            if (dependenciesFactory == null) {
                ModuleSetupImpl.$$$reportNull$$$0(15);
            }
            if (projectDataNodeSetup == null) {
                ModuleSetupImpl.$$$reportNull$$$0(16);
            }
            if (moduleSetupFactory == null) {
                ModuleSetupImpl.$$$reportNull$$$0(17);
            }
            if (moduleFinderFactory == null) {
                ModuleSetupImpl.$$$reportNull$$$0(18);
            }
            this.myAndroidModules = new ArrayList<Module>();
            this.myProject = project;
            this.myModelsProvider = modelsProvider;
            this.myModuleFactory = moduleFactory;
            this.myGradleModuleSetup = gradleModuleSetup;
            this.myAndroidModuleSetup = androidModuleSetup;
            this.myAndroidModuleProcessor = androidModuleProcessor;
            this.myNdkModuleSetup = ndkModuleSetup;
            this.myVariantSelector = variantSelector;
            this.myProjectCleanup = projectCleanup;
            this.myModuleDisposer = moduleDisposer;
            this.myJavaModuleSetup = javaModuleSetup;
            this.myCachedProjectModelsFactory = cachedProjectModelsFactory;
            this.myNativeAndroidProjectFactory = nativeAndroidProjectFactory;
            this.myJavaModuleModelFactory = javaModuleModelFactory;
            this.myExtraModelsManager = extraModelsManager;
            this.myDependenciesFactory = dependenciesFactory;
            this.myProjectDataNodeSetup = projectDataNodeSetup;
            this.myModuleSetupFactory = moduleSetupFactory;
            this.myModuleFinderFactory = moduleFinderFactory;
        }

        @Override
        void setUpModules(@NotNull CachedProjectModels projectModels, @NotNull ProgressIndicator indicator) throws ModelNotFoundInCacheException {
            Application application;
            if (projectModels == null) {
                ModuleSetupImpl.$$$reportNull$$$0(19);
            }
            if (indicator == null) {
                ModuleSetupImpl.$$$reportNull$$$0(20);
            }
            if (!(application = ApplicationManager.getApplication()).isUnitTestMode()) assert (!application.isDispatchThread());
            ModuleSetupImpl.notifyModuleConfigurationStarted(indicator);
            List<Module> modules = Arrays.asList(ModuleManager.getInstance((Project)this.myProject).getModules());
            ArrayList gradleFacets = new ArrayList();
            ModuleFinder moduleFinder = this.myModuleFinderFactory.create(this.myProject);
            JobLauncher.getInstance().invokeConcurrentlyUnderProgress(modules, indicator, true, module -> {
                String gradlePath;
                GradleFacet gradleFacet = GradleFacet.getInstance(module);
                if (gradleFacet != null && StringUtil.isNotEmpty((String)(gradlePath = ((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH))) {
                    moduleFinder.addModule((Module)module, gradlePath);
                    gradleFacets.add(gradleFacet);
                }
                return true;
            });
            for (GradleFacet gradleFacet : gradleFacets) {
                String gradlePath = ((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH;
                CachedModuleModels moduleModelsCache = projectModels.findCacheForModule(gradlePath);
                if (moduleModelsCache == null) continue;
                this.setUpModule(gradleFacet, moduleModelsCache, moduleFinder);
            }
        }

        private void setUpModule(@NotNull GradleFacet gradleFacet, @NotNull CachedModuleModels cache, @NotNull ModuleFinder moduleFinder) throws ModelNotFoundInCacheException {
            Application application;
            if (gradleFacet == null) {
                ModuleSetupImpl.$$$reportNull$$$0(21);
            }
            if (cache == null) {
                ModuleSetupImpl.$$$reportNull$$$0(22);
            }
            if (moduleFinder == null) {
                ModuleSetupImpl.$$$reportNull$$$0(23);
            }
            if (!(application = ApplicationManager.getApplication()).isUnitTestMode()) assert (!application.isDispatchThread());
            Module module = gradleFacet.getModule();
            GradleModuleModel gradleModel = cache.findModel(GradleModuleModel.class);
            if (gradleModel == null) {
                throw new ModelNotFoundInCacheException(GradleModuleModel.class);
            }
            this.myGradleModuleSetup.setUpModule(module, this.myModelsProvider, gradleModel);
            ModuleSetupContext context = this.myModuleSetupFactory.create(module, this.myModelsProvider, moduleFinder, cache);
            AndroidModuleModel androidModel = cache.findModel(AndroidModuleModel.class);
            if (androidModel != null) {
                this.myAndroidModuleSetup.setUpModule(context, androidModel, true);
                this.myAndroidModules.add(module);
                return;
            }
            NdkModuleModel ndkModel = cache.findModel(NdkModuleModel.class);
            if (ndkModel != null) {
                this.myNdkModuleSetup.setUpModule(context, ndkModel, true);
                return;
            }
            JavaModuleModel javaModel = cache.findModel(JavaModuleModel.class);
            if (javaModel != null) {
                this.myJavaModuleSetup.setUpModule(context, javaModel, true);
            }
        }

        @Override
        void setUpModules(@NotNull SyncProjectModels projectModels, @NotNull ProgressIndicator indicator) {
            if (projectModels == null) {
                ModuleSetupImpl.$$$reportNull$$$0(24);
            }
            if (indicator == null) {
                ModuleSetupImpl.$$$reportNull$$$0(25);
            }
            ModuleSetupImpl.notifyModuleConfigurationStarted(indicator);
            CachedProjectModels cache = this.myCachedProjectModelsFactory.createNew();
            GlobalLibraryMap globalLibraryMap = projectModels.getGlobalLibraryMap();
            if (globalLibraryMap != null) {
                this.myDependenciesFactory.setUpGlobalLibraryMap(globalLibraryMap);
            }
            this.createAndSetUpModules(projectModels, cache);
            this.myProjectDataNodeSetup.setupProjectDataNode(projectModels, this.myProject);
            this.myAndroidModuleProcessor.processAndroidModels(this.myAndroidModules);
            this.myProjectCleanup.cleanUpProject(this.myProject, this.myModelsProvider, indicator);
            this.myModuleDisposer.disposeObsoleteModules(indicator);
            cache.saveToDisk(this.myProject);
        }

        private static void notifyModuleConfigurationStarted(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                ModuleSetupImpl.$$$reportNull$$$0(26);
            }
            GradleSyncProgress.notifyProgress(indicator, "Configuring modules");
        }

        private void createAndSetUpModules(@NotNull SyncProjectModels projectModels, @NotNull CachedProjectModels cache) {
            if (projectModels == null) {
                ModuleSetupImpl.$$$reportNull$$$0(27);
            }
            if (cache == null) {
                ModuleSetupImpl.$$$reportNull$$$0(28);
            }
            this.populateModuleBuildFolders(projectModels);
            ArrayList<ModuleSetupInfo> moduleSetupInfos = new ArrayList<ModuleSetupInfo>();
            String projectRootFolderPath = Strings.nullToEmpty((String)this.myProject.getBasePath());
            ModuleFinder moduleFinder = this.myModuleFinderFactory.create(this.myProject);
            for (String gradlePath : projectModels.getProjectPaths()) {
                GradleModuleModels moduleModels = projectModels.getModels(gradlePath);
                if (moduleModels == null) continue;
                Module module = this.myModuleFactory.createModule(moduleModels);
                module.setOption(ROOT_PROJECT_PATH_KEY, projectRootFolderPath);
                GradleModuleModel gradleModel = this.myGradleModuleSetup.setUpModule(module, this.myModelsProvider, moduleModels);
                CachedModuleModels cachedModels = cache.addModule(module, gradlePath);
                cachedModels.addModel(gradleModel);
                moduleFinder.addModule(module, gradleModel.getGradlePath());
                moduleSetupInfos.add(new ModuleSetupInfo(module, moduleModels, cachedModels));
            }
            for (ModuleSetupInfo moduleSetupInfo : moduleSetupInfos) {
                this.setUpModule(moduleSetupInfo, moduleFinder);
            }
        }

        private void populateModuleBuildFolders(@NotNull SyncProjectModels projectModels) {
            if (projectModels == null) {
                ModuleSetupImpl.$$$reportNull$$$0(29);
            }
            for (String projectPath : projectModels.getProjectPaths()) {
                GradleProject gradleProject;
                GradleModuleModels moduleModels = projectModels.getModels(projectPath);
                if (moduleModels == null || (gradleProject = moduleModels.findModel(GradleProject.class)) == null) continue;
                try {
                    this.myDependenciesFactory.findAndAddBuildFolderPath(gradleProject.getPath(), gradleProject.getBuildDirectory());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
        }

        private void setUpModule(@NotNull ModuleSetupInfo setupInfo, @NotNull ModuleFinder moduleFinder) {
            if (setupInfo == null) {
                ModuleSetupImpl.$$$reportNull$$$0(30);
            }
            if (moduleFinder == null) {
                ModuleSetupImpl.$$$reportNull$$$0(31);
            }
            Module module = setupInfo.module;
            GradleModuleModels moduleModels = setupInfo.moduleModels;
            CachedModuleModels cachedModels = setupInfo.cachedModels;
            module.putUserData(AndroidModuleProcessor.MODULE_GRADLE_MODELS_KEY, (Object)moduleModels);
            File moduleRootFolderPath = GradleProjects.findModuleRootFolderPath(module);
            assert (moduleRootFolderPath != null);
            ModuleSetupContext context = this.myModuleSetupFactory.create(module, this.myModelsProvider, moduleFinder, moduleModels);
            AndroidProject androidProject = moduleModels.findModel(AndroidProject.class);
            if (androidProject != null) {
                AndroidModuleModel androidModel = this.createAndroidModel(module, androidProject);
                if (androidModel != null) {
                    this.myAndroidModuleSetup.setUpModule(context, androidModel, false);
                    this.myAndroidModules.add(module);
                    cachedModels.addModel(androidModel);
                    NativeAndroidProject nativeAndroidProject = moduleModels.findModel(NativeAndroidProject.class);
                    if (nativeAndroidProject != null) {
                        IdeNativeAndroidProject copy = this.myNativeAndroidProjectFactory.create(nativeAndroidProject);
                        NdkModuleModel ndkModel = new NdkModuleModel(module.getName(), moduleRootFolderPath, copy);
                        this.myNdkModuleSetup.setUpModule(context, ndkModel, false);
                        cachedModels.addModel(ndkModel);
                    }
                } else {
                    this.removeAndroidFacetFrom(module);
                    GradleProject gradleProject = moduleModels.findModel(GradleProject.class);
                    assert (gradleProject != null);
                    JavaModuleModel javaModel = this.myJavaModuleModelFactory.create(gradleProject, androidProject);
                    this.myJavaModuleSetup.setUpModule(context, javaModel, false);
                    cachedModels.addModel(javaModel);
                }
                return;
            }
            this.removeAndroidFacetFrom(module);
            Facets.removeAllFacets(this.myModelsProvider.getModifiableFacetModel(module), NdkFacet.getFacetTypeId());
            JavaProject javaProject = moduleModels.findModel(JavaProject.class);
            GradleProject gradleProject = moduleModels.findModel(GradleProject.class);
            if (gradleProject != null && javaProject != null) {
                JavaModuleModel javaModel = this.myJavaModuleModelFactory.create(moduleRootFolderPath, gradleProject, javaProject);
                this.myJavaModuleSetup.setUpModule(context, javaModel, false);
                cachedModels.addModel(javaModel);
                this.myExtraModelsManager.applyModelsToModule(moduleModels, module, this.myModelsProvider);
                this.myExtraModelsManager.addJavaModelsToCache(module, cachedModels);
                return;
            }
            ArtifactModel jarAarProject = moduleModels.findModel(ArtifactModel.class);
            if (gradleProject != null && jarAarProject != null) {
                JavaModuleModel javaModel = this.myJavaModuleModelFactory.create(moduleRootFolderPath, gradleProject, jarAarProject);
                this.myJavaModuleSetup.setUpModule(context, javaModel, false);
                cachedModels.addModel(javaModel);
            }
        }

        @Nullable
        private AndroidModuleModel createAndroidModel(@NotNull Module module, @NotNull AndroidProject androidProject) {
            File moduleRootFolderPath;
            Variant variantToSelect;
            if (module == null) {
                ModuleSetupImpl.$$$reportNull$$$0(32);
            }
            if (androidProject == null) {
                ModuleSetupImpl.$$$reportNull$$$0(33);
            }
            if ((variantToSelect = this.myVariantSelector.findVariantToSelect(androidProject)) != null && (moduleRootFolderPath = GradleProjects.findModuleRootFolderPath(module)) != null) {
                return new AndroidModuleModel(module.getName(), moduleRootFolderPath, androidProject, variantToSelect.getName(), this.myDependenciesFactory);
            }
            return null;
        }

        private void removeAndroidFacetFrom(@NotNull Module module) {
            if (module == null) {
                ModuleSetupImpl.$$$reportNull$$$0(34);
            }
            Facets.removeAllFacets(this.myModelsProvider.getModifiableFacetModel(module), AndroidFacet.ID);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelsProvider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extraModelsManager";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleFactory";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gradleModuleSetup";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "androidModuleSetup";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ndkModuleSetup";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "javaModuleSetup";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "androidModuleProcessor";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variantSelector";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectCleanup";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleDisposer";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cachedProjectModelsFactory";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nativeAndroidProjectFactory";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "javaModuleModelFactory";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependenciesFactory";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectDataNodeSetup";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleSetupFactory";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleFinderFactory";
                    break;
                }
                case 19: 
                case 24: 
                case 27: 
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectModels";
                    break;
                }
                case 20: 
                case 25: 
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gradleFacet";
                    break;
                }
                case 22: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cache";
                    break;
                }
                case 23: 
                case 31: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleFinder";
                    break;
                }
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "setupInfo";
                    break;
                }
                case 32: 
                case 34: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 33: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "androidProject";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/ModuleSetup$ModuleSetupImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 19: 
                case 20: 
                case 24: 
                case 25: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setUpModules";
                    break;
                }
                case 21: 
                case 22: 
                case 23: 
                case 30: 
                case 31: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setUpModule";
                    break;
                }
                case 26: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notifyModuleConfigurationStarted";
                    break;
                }
                case 27: 
                case 28: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createAndSetUpModules";
                    break;
                }
                case 29: {
                    objectArray = objectArray2;
                    objectArray2[2] = "populateModuleBuildFolders";
                    break;
                }
                case 32: 
                case 33: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createAndroidModel";
                    break;
                }
                case 34: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeAndroidFacetFrom";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class Factory {
        Factory() {
        }

        @NotNull
        ModuleSetup create(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
            if (project == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (modelsProvider == null) {
                Factory.$$$reportNull$$$0(1);
            }
            ModuleSetupImpl moduleSetupImpl = new ModuleSetupImpl(project, modelsProvider, ExtraGradleSyncModelsManager.getInstance(), new ModuleFactory(project, modelsProvider), new GradleModuleSetup(), new AndroidModuleSetup(), new NdkModuleSetup(), new JavaModuleSetup(), new AndroidModuleProcessor(project, modelsProvider), new VariantSelector(), new ProjectCleanup(), new ObsoleteModuleDisposer(project, modelsProvider), new CachedProjectModels.Factory(), (IdeNativeAndroidProject.Factory)new IdeNativeAndroidProjectImpl.FactoryImpl(), new JavaModuleModelFactory(), new IdeDependenciesFactory(), new ProjectDataNodeSetup(), new ModuleSetupContext.Factory(), new ModuleFinder.Factory());
            if (moduleSetupImpl == null) {
                Factory.$$$reportNull$$$0(2);
            }
            return moduleSetupImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelsProvider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ng/ModuleSetup$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/ModuleSetup$Factory";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

