/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.sync.ng.ProjectSetup;
import com.android.tools.idea.gradle.project.sync.ng.SyncExecutionCallback;
import com.android.tools.idea.gradle.project.sync.ng.SyncExecutor;
import com.android.tools.idea.gradle.project.sync.ng.SyncProjectModels;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleProjectRefresh {
    @NotNull
    private final Project myProject;
    @NotNull
    private final SyncExecutor mySyncExecutor;
    @NotNull
    private final SyncExecutionCallback.Factory myCallbackFactory;
    @NotNull
    private final ProjectSetup.Factory mySetupFactory;

    public GradleProjectRefresh(@NotNull Project project) {
        if (project == null) {
            GradleProjectRefresh.$$$reportNull$$$0(0);
        }
        this(project, new SyncExecutor(project), new SyncExecutionCallback.Factory(), new ProjectSetup.Factory());
    }

    @VisibleForTesting
    GradleProjectRefresh(@NotNull Project project, @NotNull SyncExecutor syncExecutor, @NotNull SyncExecutionCallback.Factory callbackFactory, @NotNull ProjectSetup.Factory setupFactory) {
        if (project == null) {
            GradleProjectRefresh.$$$reportNull$$$0(1);
        }
        if (syncExecutor == null) {
            GradleProjectRefresh.$$$reportNull$$$0(2);
        }
        if (callbackFactory == null) {
            GradleProjectRefresh.$$$reportNull$$$0(3);
        }
        if (setupFactory == null) {
            GradleProjectRefresh.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.mySyncExecutor = syncExecutor;
        this.myCallbackFactory = callbackFactory;
        this.mySetupFactory = setupFactory;
    }

    public void refresh() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.refresh((ProgressIndicator)new EmptyProgressIndicator());
            return;
        }
        Task.Backgroundable task = new Task.Backgroundable(this.myProject, "Refresh Project", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                GradleProjectRefresh.this.refresh(indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/gradle/project/sync/ng/GradleProjectRefresh$1", "run"));
            }
        };
        ApplicationManager.getApplication().invokeLater(() -> ((Task)task).queue(), ModalityState.defaultModalityState());
    }

    private void refresh(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            GradleProjectRefresh.$$$reportNull$$$0(5);
        }
        SyncExecutionCallback callback = this.myCallbackFactory.create();
        callback.doWhenDone(() -> {
            SyncProjectModels models;
            if (indicator == null) {
                GradleProjectRefresh.$$$reportNull$$$0(6);
            }
            if ((models = callback.getModels()) != null) {
                ProjectSetup projectSetup = this.mySetupFactory.create(this.myProject);
                projectSetup.setUpProject(models, indicator);
                projectSetup.commit();
                ExternalSystemUtil.scheduleExternalViewStructureUpdate((Project)this.myProject, (ProjectSystemId)GradleConstants.SYSTEM_ID);
            }
        });
        this.mySyncExecutor.syncProject(indicator, callback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncExecutor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callbackFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setupFactory";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/GradleProjectRefresh";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "refresh";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$refresh$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

