/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.tools.idea.gradle.project.AndroidGradleProjectComponent;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.ProjectBuildFileChecksums;
import com.android.tools.idea.gradle.project.importing.GradleProjectImporter;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.idea.IdeaSyncPopulateProjectTask;
import com.android.tools.idea.gradle.project.sync.idea.ProjectFinder;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProjectSetUpTask
implements ExternalProjectRefreshCallback {
    @NotNull
    private final Project myProject;
    @NotNull
    private final PostSyncProjectSetup.Request mySetupRequest;
    @Nullable
    private final GradleSyncListener mySyncListener;
    private final boolean mySyncSkipped;

    ProjectSetUpTask(@NotNull Project project, @NotNull PostSyncProjectSetup.Request setupRequest, @Nullable GradleSyncListener syncListener, boolean syncSkipped) {
        if (project == null) {
            ProjectSetUpTask.$$$reportNull$$$0(0);
        }
        if (setupRequest == null) {
            ProjectSetUpTask.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.mySetupRequest = setupRequest;
        this.mySyncListener = syncListener;
        this.mySyncSkipped = syncSkipped;
    }

    public void onSuccess(@Nullable DataNode<ProjectData> projectInfo) {
        assert (projectInfo != null);
        ProjectFinder.unregisterAsNewProject(this.myProject);
        if (this.mySyncListener != null) {
            this.mySyncListener.setupStarted(this.myProject);
        }
        GradleSyncState.getInstance(this.myProject).setupStarted();
        boolean importedProject = GradleProjectInfo.getInstance(this.myProject).isImportedProject();
        this.populateProject(projectInfo, importedProject);
        Runnable runnable = () -> {
            boolean isTest = ApplicationManager.getApplication().isUnitTestMode();
            if (!isTest || !GradleProjectImporter.ourSkipSetupFromTest) {
                if (importedProject) {
                    GradleProjects.open(this.myProject);
                }
                if (!isTest) {
                    this.myProject.save();
                }
            }
            if (importedProject) {
                AndroidGradleProjectComponent projectComponent = AndroidGradleProjectComponent.getInstance(this.myProject);
                projectComponent.configureGradleProject();
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable.run();
        } else {
            TransactionGuard.getInstance().submitTransactionLater((Disposable)this.myProject, runnable);
        }
    }

    private void populateProject(@NotNull DataNode<ProjectData> projectInfo, boolean importedProject) {
        if (projectInfo == null) {
            ProjectSetUpTask.$$$reportNull$$$0(2);
        }
        if (!importedProject) {
            this.doPopulateProject(projectInfo);
            return;
        }
        StartupManager startupManager = StartupManager.getInstance((Project)this.myProject);
        startupManager.runWhenProjectIsInitialized(() -> {
            if (projectInfo == null) {
                ProjectSetUpTask.$$$reportNull$$$0(7);
            }
            this.doPopulateProject(projectInfo);
        });
    }

    private void doPopulateProject(@NotNull DataNode<ProjectData> projectInfo) {
        if (projectInfo == null) {
            ProjectSetUpTask.$$$reportNull$$$0(3);
        }
        IdeaSyncPopulateProjectTask task = new IdeaSyncPopulateProjectTask(this.myProject);
        task.populateProject(projectInfo, this.mySetupRequest, () -> {
            if (this.mySyncListener != null) {
                if (this.mySyncSkipped) {
                    this.mySyncListener.syncSkipped(this.myProject);
                } else {
                    this.mySyncListener.syncSucceeded(this.myProject);
                }
            }
        });
    }

    public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
        if (errorMessage == null) {
            ProjectSetUpTask.$$$reportNull$$$0(4);
        }
        ProjectFinder.unregisterAsNewProject(this.myProject);
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (!this.myProject.isDisposed()) {
                ExternalSystemUtil.ensureToolWindowContentInitialized((Project)this.myProject, (ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID);
            }
        });
        if (StringUtil.isNotEmpty((String)errorDetails)) {
            ProjectSetUpTask.getLogger().warn(errorDetails);
        }
        this.handleSyncFailure(errorMessage);
    }

    private void handleSyncFailure(@NotNull String errorMessage) {
        if (errorMessage == null) {
            ProjectSetUpTask.$$$reportNull$$$0(5);
        }
        ProjectSetUpTask.getLogger().warn(errorMessage);
        String newMessage = ExternalSystemBundle.message((String)"error.resolve.with.reason", (Object[])new Object[]{errorMessage});
        ProjectBuildFileChecksums.removeFrom(this.myProject);
        GradleSyncState.getInstance(this.myProject).syncFailed(newMessage);
        if (this.mySyncListener != null) {
            this.mySyncListener.syncFailed(this.myProject, newMessage);
        }
        if (!this.myProject.isOpen()) {
            GradleProjectInfo.getInstance(this.myProject).setProjectCreationError(errorMessage);
        }
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(ProjectSetUpTask.class);
        if (logger == null) {
            ProjectSetUpTask.$$$reportNull$$$0(6);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setupRequest";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/idea/ProjectSetUpTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/idea/ProjectSetUpTask";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "populateProject";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doPopulateProject";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onFailure";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleSyncFailure";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$populateProject$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

