/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.tools.analytics.UsageTracker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.LocationAwareExternalSystemException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectImportErrorHandler;

public class ProjectImportErrorHandler
extends AbstractProjectImportErrorHandler {
    private static final Pattern ERROR_LOCATION_PATTERN = Pattern.compile(".* file '(.*)'( line: ([\\d]+))?");

    @Nullable
    public ExternalSystemException getUserFriendlyError(@NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
        Pair<String, Integer> pair;
        if (error == null) {
            ProjectImportErrorHandler.$$$reportNull$$$0(0);
        }
        if (projectPath == null) {
            ProjectImportErrorHandler.$$$reportNull$$$0(1);
        }
        if (error instanceof ExternalSystemException) {
            this.logSyncFailure();
            return (ExternalSystemException)error;
        }
        Pair rootCauseAndLocation = this.getRootCauseAndLocation(error);
        Throwable rootCause = (Throwable)rootCauseAndLocation.getFirst();
        String location = (String)rootCauseAndLocation.getSecond();
        String errMessage = ProjectImportErrorHandler.createErrorMessage(rootCause);
        ExternalSystemException exception = null;
        if (StringUtil.isNotEmpty((String)location) && (pair = ProjectImportErrorHandler.getErrorLocation(location)) != null) {
            exception = new LocationAwareExternalSystemException(errMessage, (String)pair.first, (Integer)pair.getSecond(), new String[0]);
        }
        if (exception == null) {
            exception = new ExternalSystemException(errMessage);
        }
        exception.initCause(rootCause);
        return exception;
    }

    public void logSyncFailure() {
        AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder();
        event.setCategory(AndroidStudioEvent.EventCategory.GRADLE_SYNC).setKind(AndroidStudioEvent.EventKind.GRADLE_SYNC_FAILURE).setGradleSyncFailure(AndroidStudioEvent.GradleSyncFailure.UNKNOWN_GRADLE_FAILURE);
        UsageTracker.getInstance().log(event);
    }

    @NotNull
    public static String createErrorMessage(@NotNull Throwable rootCause) {
        String errMessage;
        if (rootCause == null) {
            ProjectImportErrorHandler.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)(errMessage = rootCause.getMessage()))) {
            errMessage = Throwables.getStackTraceAsString((Throwable)rootCause);
        }
        if (Character.isLowerCase(errMessage.charAt(0))) {
            errMessage = "Cause: " + errMessage;
        }
        String string = errMessage;
        if (string == null) {
            ProjectImportErrorHandler.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public String getLocationFrom(@NotNull Throwable error) {
        String location;
        String errorToString;
        if (error == null) {
            ProjectImportErrorHandler.$$$reportNull$$$0(4);
        }
        if ((errorToString = error.toString()).contains("LocationAwareException") && (location = error.getMessage()) != null && (location.startsWith("Build file '") || location.startsWith("Settings file '"))) {
            String[] lines = StringUtil.splitByLines((String)location);
            return lines.length > 0 ? lines[0] : null;
        }
        return null;
    }

    @NotNull
    public ExternalSystemException createUserFriendlyError(@NotNull String msg, @Nullable String location, String ... quickFixes) {
        Pair<String, Integer> pair;
        if (msg == null) {
            ProjectImportErrorHandler.$$$reportNull$$$0(5);
        }
        if (quickFixes == null) {
            ProjectImportErrorHandler.$$$reportNull$$$0(6);
        }
        if (StringUtil.isNotEmpty((String)location) && (pair = ProjectImportErrorHandler.getErrorLocation(location)) != null) {
            LocationAwareExternalSystemException locationAwareExternalSystemException = new LocationAwareExternalSystemException(msg, (String)pair.first, (Integer)pair.getSecond(), quickFixes);
            if (locationAwareExternalSystemException == null) {
                ProjectImportErrorHandler.$$$reportNull$$$0(7);
            }
            return locationAwareExternalSystemException;
        }
        ExternalSystemException externalSystemException = new ExternalSystemException(msg, null, quickFixes);
        if (externalSystemException == null) {
            ProjectImportErrorHandler.$$$reportNull$$$0(8);
        }
        return externalSystemException;
    }

    @VisibleForTesting
    @Nullable
    static Pair<String, Integer> getErrorLocation(@NotNull String location) {
        Matcher matcher;
        if (location == null) {
            ProjectImportErrorHandler.$$$reportNull$$$0(9);
        }
        if ((matcher = ERROR_LOCATION_PATTERN.matcher(location)).matches()) {
            String filePath = matcher.group(1);
            int line = -1;
            String lineAsText = matcher.group(3);
            if (lineAsText != null) {
                try {
                    line = Integer.parseInt(lineAsText);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return Pair.create((Object)filePath, (Object)line);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootCause";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/idea/ProjectImportErrorHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/idea/ProjectImportErrorHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorMessage";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createUserFriendlyError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUserFriendlyError";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createErrorMessage";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLocationFrom";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createUserFriendlyError";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getErrorLocation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

