/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.Variant;
import com.android.builder.model.level2.GlobalLibraryMap;
import com.android.ide.common.gradle.model.IdeNativeAndroidProject;
import com.android.ide.common.gradle.model.IdeNativeAndroidProjectImpl;
import com.android.ide.common.gradle.model.level2.IdeDependenciesFactory;
import com.android.ide.common.repository.GradleVersion;
import com.android.repository.Revision;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.IdeaJavaModuleModelFactory;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.SimulatedSyncErrors;
import com.android.tools.idea.gradle.project.sync.common.CommandLineArgs;
import com.android.tools.idea.gradle.project.sync.common.VariantSelector;
import com.android.tools.idea.gradle.project.sync.idea.GradleModelVersionCheck;
import com.android.tools.idea.gradle.project.sync.idea.ProjectFinder;
import com.android.tools.idea.gradle.project.sync.idea.ProjectImportErrorHandler;
import com.android.tools.idea.gradle.project.sync.idea.data.model.ImportedModule;
import com.android.tools.idea.gradle.project.sync.idea.data.model.ProjectCleanupModel;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.gradle.GradleScript;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ModuleExtendedModel;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=1000)
public class AndroidGradleProjectResolver
extends AbstractProjectResolverExtension {
    private static final Key<Boolean> IS_ANDROID_PROJECT_KEY = Key.create((String)"IS_ANDROID_PROJECT_KEY");
    @NotNull
    private final CommandLineArgs myCommandLineArgs;
    @NotNull
    private final ProjectImportErrorHandler myErrorHandler;
    @NotNull
    private final ProjectFinder myProjectFinder;
    @NotNull
    private final VariantSelector myVariantSelector;
    @NotNull
    private final IdeNativeAndroidProject.Factory myNativeAndroidProjectFactory;
    @NotNull
    private final IdeaJavaModuleModelFactory myIdeaJavaModuleModelFactory;
    @NotNull
    private final IdeDependenciesFactory myDependenciesFactory;

    public AndroidGradleProjectResolver() {
        this(new CommandLineArgs(false), new ProjectImportErrorHandler(), new ProjectFinder(), new VariantSelector(), (IdeNativeAndroidProject.Factory)new IdeNativeAndroidProjectImpl.FactoryImpl(), new IdeaJavaModuleModelFactory(), new IdeDependenciesFactory());
    }

    @VisibleForTesting
    AndroidGradleProjectResolver(@NotNull CommandLineArgs commandLineArgs, @NotNull ProjectImportErrorHandler errorHandler, @NotNull ProjectFinder projectFinder, @NotNull VariantSelector variantSelector, @NotNull IdeNativeAndroidProject.Factory nativeAndroidProjectFactory, @NotNull IdeaJavaModuleModelFactory ideaJavaModuleModelFactory, @NotNull IdeDependenciesFactory dependenciesFactory) {
        if (commandLineArgs == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(0);
        }
        if (errorHandler == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(1);
        }
        if (projectFinder == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(2);
        }
        if (variantSelector == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(3);
        }
        if (nativeAndroidProjectFactory == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(4);
        }
        if (ideaJavaModuleModelFactory == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(5);
        }
        if (dependenciesFactory == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(6);
        }
        this.myCommandLineArgs = commandLineArgs;
        this.myErrorHandler = errorHandler;
        this.myProjectFinder = projectFinder;
        this.myVariantSelector = variantSelector;
        this.myNativeAndroidProjectFactory = nativeAndroidProjectFactory;
        this.myIdeaJavaModuleModelFactory = ideaJavaModuleModelFactory;
        this.myDependenciesFactory = dependenciesFactory;
    }

    @NotNull
    public DataNode<ModuleData> createModule(@NotNull IdeaModule gradleModule, @NotNull DataNode<ProjectData> projectDataNode) {
        AndroidProject androidProject;
        if (gradleModule == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(7);
        }
        if (projectDataNode == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(8);
        }
        if ((androidProject = (AndroidProject)this.resolverCtx.getExtraProject(gradleModule, AndroidProject.class)) != null && !GradleModelVersionCheck.isSupportedVersion(androidProject)) {
            AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder();
            event.setCategory(AndroidStudioEvent.EventCategory.GRADLE_SYNC).setKind(AndroidStudioEvent.EventKind.GRADLE_SYNC_FAILURE).setGradleSyncFailure(AndroidStudioEvent.GradleSyncFailure.UNSUPPORTED_ANDROID_MODEL_VERSION).setGradleVersion(androidProject.getModelVersion());
            UsageTracker.getInstance().log(event);
            String msg = AndroidGradleProjectResolver.getUnsupportedModelVersionErrorMsg(GradleModelVersionCheck.getModelVersion(androidProject));
            throw new IllegalStateException(msg);
        }
        if (this.isAndroidGradleProject()) {
            DataNode<ModuleData> dataNode = this.doCreateModule(gradleModule, projectDataNode);
            if (dataNode == null) {
                AndroidGradleProjectResolver.$$$reportNull$$$0(9);
            }
            return dataNode;
        }
        DataNode dataNode = this.nextResolver.createModule(gradleModule, projectDataNode);
        if (dataNode == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(10);
        }
        return dataNode;
    }

    @NotNull
    private DataNode<ModuleData> doCreateModule(@NotNull IdeaModule gradleModule, @NotNull DataNode<ProjectData> projectDataNode) {
        String moduleName;
        if (gradleModule == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(11);
        }
        if (projectDataNode == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(12);
        }
        if ((moduleName = gradleModule.getName()) == null) {
            throw new IllegalStateException("Module with undefined name detected: " + gradleModule);
        }
        String projectPath = ((ProjectData)projectDataNode.getData()).getLinkedExternalProjectPath();
        String moduleConfigPath = GradleProjectResolverUtil.getModuleConfigPath((ProjectResolverContext)this.resolverCtx, (IdeaModule)gradleModule, (String)projectPath);
        String gradlePath = gradleModule.getGradleProject().getPath();
        String moduleId = StringUtil.isEmpty((String)gradlePath) || ":".equals(gradlePath) ? moduleName : gradlePath;
        ProjectSystemId owner = GradleConstants.SYSTEM_ID;
        String typeId = StdModuleTypes.JAVA.getId();
        ModuleData moduleData = new ModuleData(moduleId, owner, typeId, moduleName, moduleConfigPath, moduleConfigPath);
        ExternalProject externalProject = (ExternalProject)this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        if (externalProject != null) {
            moduleData.setDescription(externalProject.getDescription());
        }
        DataNode dataNode = projectDataNode.createChild(ProjectKeys.MODULE, (Object)moduleData);
        if (dataNode == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(13);
        }
        return dataNode;
    }

    public void populateModuleContentRoots(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        File gradleSettingsFile;
        NativeAndroidProject nativeAndroidProject;
        if (gradleModule == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(14);
        }
        if (ideModule == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(15);
        }
        if (!IdeInfo.getInstance().isAndroidStudio() && !this.isAndroidGradleProject()) {
            this.nextResolver.populateModuleContentRoots(gradleModule, ideModule);
            return;
        }
        ImportedModule importedModule = new ImportedModule(gradleModule);
        ideModule.createChild(AndroidProjectKeys.IMPORTED_MODULE, (Object)importedModule);
        File moduleRootDirPath = FilePaths.toSystemDependentPath((String)((ModuleData)ideModule.getData()).getLinkedExternalProjectPath());
        AndroidProject androidProject = (AndroidProject)this.resolverCtx.getExtraProject(gradleModule, AndroidProject.class);
        boolean androidProjectWithoutVariants = false;
        String moduleName = gradleModule.getName();
        if (androidProject != null) {
            Variant selectedVariant = this.myVariantSelector.findVariantToSelect(androidProject);
            if (selectedVariant == null) {
                androidProjectWithoutVariants = true;
            } else {
                String variantName = selectedVariant.getName();
                AndroidModuleModel model = new AndroidModuleModel(moduleName, moduleRootDirPath, androidProject, variantName, this.myDependenciesFactory);
                ideModule.createChild(AndroidProjectKeys.ANDROID_MODEL, (Object)model);
            }
        }
        if ((nativeAndroidProject = (NativeAndroidProject)this.resolverCtx.getExtraProject(gradleModule, NativeAndroidProject.class)) != null) {
            IdeNativeAndroidProject copy = this.myNativeAndroidProjectFactory.create(nativeAndroidProject);
            NdkModuleModel ndkModuleModel = new NdkModuleModel(moduleName, moduleRootDirPath, copy);
            ideModule.createChild(AndroidProjectKeys.NDK_MODEL, (Object)ndkModuleModel);
        }
        if ((gradleSettingsFile = new File(moduleRootDirPath, "settings.gradle")).isFile() && androidProject == null && nativeAndroidProject == null && !this.hasArtifacts(gradleModule)) {
            this.createJavaProject(gradleModule, ideModule, false);
            return;
        }
        BuildScriptClasspathModel buildScriptModel = (BuildScriptClasspathModel)this.resolverCtx.getExtraProject(BuildScriptClasspathModel.class);
        String gradleVersion = buildScriptModel != null ? buildScriptModel.getGradleVersion() : null;
        GradleProject gradleProject = gradleModule.getGradleProject();
        GradleScript buildScript = null;
        try {
            buildScript = gradleProject.getBuildScript();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        File buildFilePath = buildScript != null ? buildScript.getSourceFile() : null;
        GradleModuleModel gradleModuleModel = new GradleModuleModel(moduleName, gradleProject, buildFilePath, gradleVersion);
        ideModule.createChild(AndroidProjectKeys.GRADLE_MODULE_MODEL, (Object)gradleModuleModel);
        if (nativeAndroidProject == null && (androidProject == null || androidProjectWithoutVariants)) {
            this.createJavaProject(gradleModule, ideModule, androidProjectWithoutVariants);
        }
    }

    private boolean hasArtifacts(@NotNull IdeaModule gradleModule) {
        ModuleExtendedModel javaModel;
        if (gradleModule == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(16);
        }
        return (javaModel = (ModuleExtendedModel)this.resolverCtx.getExtraProject(gradleModule, ModuleExtendedModel.class)) != null && !javaModel.getArtifacts().isEmpty();
    }

    private void createJavaProject(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, boolean androidProjectWithoutVariants) {
        if (gradleModule == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(17);
        }
        if (ideModule == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(18);
        }
        ModuleExtendedModel model = (ModuleExtendedModel)this.resolverCtx.getExtraProject(gradleModule, ModuleExtendedModel.class);
        JavaModuleModel javaModuleModel = this.myIdeaJavaModuleModelFactory.create(gradleModule, model, androidProjectWithoutVariants);
        ideModule.createChild(AndroidProjectKeys.JAVA_MODULE_MODEL, (Object)javaModuleModel);
    }

    public void populateModuleCompileOutputSettings(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        if (gradleModule == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(19);
        }
        if (ideModule == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(20);
        }
        if (!this.isAndroidGradleProject()) {
            this.nextResolver.populateModuleCompileOutputSettings(gradleModule, ideModule);
        }
    }

    public void populateModuleDependencies(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull DataNode<ProjectData> ideProject) {
        if (gradleModule == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(21);
        }
        if (ideModule == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(22);
        }
        if (ideProject == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(23);
        }
        if (!this.isAndroidGradleProject()) {
            this.nextResolver.populateModuleDependencies(gradleModule, ideModule, ideProject);
        }
    }

    private boolean isAndroidGradleProject() {
        Boolean isAndroidGradleProject = (Boolean)this.resolverCtx.getUserData(IS_ANDROID_PROJECT_KEY);
        if (isAndroidGradleProject != null) {
            return isAndroidGradleProject;
        }
        isAndroidGradleProject = this.resolverCtx.hasModulesWithModel(AndroidProject.class) || this.resolverCtx.hasModulesWithModel(NativeAndroidProject.class);
        return (Boolean)this.resolverCtx.putUserDataIfAbsent(IS_ANDROID_PROJECT_KEY, (Object)isAndroidGradleProject);
    }

    public void populateProjectExtraModels(@NotNull IdeaProject gradleProject, @NotNull DataNode<ProjectData> projectDataNode) {
        if (gradleProject == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(24);
        }
        if (projectDataNode == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(25);
        }
        this.populateModuleBuildDirs(gradleProject);
        this.populateGlobalLibraryMap(gradleProject);
        if (this.isAndroidGradleProject()) {
            projectDataNode.createChild(AndroidProjectKeys.PROJECT_CLEANUP_MODEL, (Object)ProjectCleanupModel.getInstance());
        }
        super.populateProjectExtraModels(gradleProject, projectDataNode);
    }

    private void populateModuleBuildDirs(@NotNull IdeaProject ideaProject) {
        if (ideaProject == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(26);
        }
        for (IdeaModule ideaModule : ideaProject.getChildren()) {
            GradleProject gradleProject = ideaModule.getGradleProject();
            if (gradleProject == null) continue;
            try {
                this.myDependenciesFactory.findAndAddBuildFolderPath(gradleProject.getPath(), gradleProject.getBuildDirectory());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    private void populateGlobalLibraryMap(@NotNull IdeaProject ideaProject) {
        if (ideaProject == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(27);
        }
        GlobalLibraryMap globalLibraryMap = null;
        for (IdeaModule ideaModule : ideaProject.getChildren()) {
            GlobalLibraryMap moduleMap = (GlobalLibraryMap)this.resolverCtx.getExtraProject(ideaModule, GlobalLibraryMap.class);
            if (globalLibraryMap != null && (moduleMap == null || moduleMap.getLibraries().size() <= globalLibraryMap.getLibraries().size())) continue;
            globalLibraryMap = moduleMap;
        }
        if (globalLibraryMap != null) {
            this.myDependenciesFactory.setUpGlobalLibraryMap(globalLibraryMap);
        }
    }

    @NotNull
    public Set<Class> getExtraProjectModelClasses() {
        LinkedHashSet<Class> modelClasses = new LinkedHashSet<Class>();
        modelClasses.add(AndroidProject.class);
        modelClasses.add(NativeAndroidProject.class);
        modelClasses.add(GlobalLibraryMap.class);
        LinkedHashSet<Class> linkedHashSet = modelClasses;
        if (linkedHashSet == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(28);
        }
        return linkedHashSet;
    }

    public void preImportCheck() {
        SimulatedSyncErrors.simulateRegisteredSyncError();
    }

    @NotNull
    public List<Pair<String, String>> getExtraJvmArgs() {
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID)) {
            File androidHomePath;
            LocalProperties localProperties;
            ArrayList<Pair<String, String>> args = new ArrayList<Pair<String, String>>();
            if (!IdeInfo.getInstance().isAndroidStudio() && (localProperties = this.getLocalProperties()).getAndroidSdkPath() == null && (androidHomePath = IdeSdks.getInstance().getAndroidSdkPath()) != null) {
                args.add((Pair<String, String>)Pair.create((Object)"android.home", (Object)androidHomePath.getPath()));
            }
            ArrayList<Pair<String, String>> arrayList = args;
            if (arrayList == null) {
                AndroidGradleProjectResolver.$$$reportNull$$$0(29);
            }
            return arrayList;
        }
        List<Pair<String, String>> list = Collections.emptyList();
        if (list == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(30);
        }
        return list;
    }

    @NotNull
    private LocalProperties getLocalProperties() {
        LocalProperties localProperties;
        block2: {
            File projectDir = FilePaths.toSystemDependentPath((String)this.resolverCtx.getProjectPath());
            try {
                localProperties = new LocalProperties(projectDir);
                if (localProperties != null) break block2;
            }
            catch (IOException e) {
                String msg = String.format("Unable to read local.properties file in project '%1$s'", projectDir.getPath());
                throw new ExternalSystemException(msg, (Throwable)e, new String[0]);
            }
            AndroidGradleProjectResolver.$$$reportNull$$$0(31);
        }
        return localProperties;
    }

    @NotNull
    public List<String> getExtraCommandLineArgs() {
        Project project = this.myProjectFinder.findProject(this.resolverCtx);
        List<String> list = this.myCommandLineArgs.get(project);
        if (list == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(32);
        }
        return list;
    }

    @NotNull
    public ExternalSystemException getUserFriendlyError(@NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
        Throwable rootCause;
        String msg;
        if (error == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(33);
        }
        if (projectPath == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(34);
        }
        if ((msg = error.getMessage()) != null && !msg.contains("The project is using an unsupported version of the Android Gradle plug-in") && (rootCause = ExceptionUtil.getRootCause((Throwable)error)) instanceof ClassNotFoundException && AndroidGradleProjectResolver.isUsingUnsupportedGradleVersion(msg = rootCause.getMessage())) {
            AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder();
            event.setCategory(AndroidStudioEvent.EventCategory.GRADLE_SYNC).setKind(AndroidStudioEvent.EventKind.GRADLE_SYNC_FAILURE).setGradleSyncFailure(AndroidStudioEvent.GradleSyncFailure.UNSUPPORTED_GRADLE_VERSION);
            UsageTracker.getInstance().log(event);
            ExternalSystemException externalSystemException = new ExternalSystemException("The project is using an unsupported version of Gradle.");
            if (externalSystemException == null) {
                AndroidGradleProjectResolver.$$$reportNull$$$0(35);
            }
            return externalSystemException;
        }
        ExternalSystemException userFriendlyError = this.myErrorHandler.getUserFriendlyError(error, projectPath, buildFilePath);
        assert (userFriendlyError != null);
        ExternalSystemException externalSystemException = userFriendlyError;
        if (externalSystemException == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(36);
        }
        return externalSystemException;
    }

    private static boolean isUsingUnsupportedGradleVersion(@Nullable String errorMessage) {
        return "org.gradle.api.artifacts.result.ResolvedComponentResult".equals(errorMessage) || "org.gradle.api.artifacts.result.ResolvedModuleVersionResult".equals(errorMessage);
    }

    @NotNull
    private static String getUnsupportedModelVersionErrorMsg(@Nullable GradleVersion modelVersion) {
        StringBuilder builder = new StringBuilder();
        builder.append("The project is using an unsupported version of the Android Gradle plug-in");
        String recommendedVersion = String.format("The recommended version is %1$s.", AndroidPluginGeneration.ORIGINAL.getLatestKnownVersion());
        if (modelVersion != null) {
            builder.append(String.format(" (%1$s).", modelVersion.toString())).append(" ").append(recommendedVersion);
            if (modelVersion.getMajor() == 0 && modelVersion.getMinor() <= 8) {
                builder.append("\n\nStarting with version 0.9.0 incompatible changes were introduced in the build language.\n").append("Please read the migration guide").append(" to learn how to update your project.");
            }
        } else {
            builder.append(". ").append(recommendedVersion);
        }
        String string = builder.toString();
        if (string == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(37);
        }
        return string;
    }

    public void enhanceRemoteProcessing(@NotNull SimpleJavaParameters parameters) {
        if (parameters == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(38);
        }
        PathsList classPath = parameters.getClassPath();
        classPath.add(PathUtil.getJarPathForClass(((Object)((Object)this)).getClass()));
        classPath.add(PathUtil.getJarPathForClass(Revision.class));
        classPath.add(PathUtil.getJarPathForClass(AndroidGradleSettings.class));
        classPath.add(PathUtil.getJarPathForClass(AndroidProject.class));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineArgs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFinder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantSelector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeAndroidProjectFactory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaJavaModuleModelFactory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesFactory";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleModule";
                break;
            }
            case 8: 
            case 12: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDataNode";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver";
                break;
            }
            case 15: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModule";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProject";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProject";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaProject";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateModule";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraProjectModelClasses";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraJvmArgs";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalProperties";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraCommandLineArgs";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserFriendlyError";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsupportedModelVersionErrorMsg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doCreateModule";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleContentRoots";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasArtifacts";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createJavaProject";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleCompileOutputSettings";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleDependencies";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "populateProjectExtraModels";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleBuildDirs";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "populateGlobalLibraryMap";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getUserFriendlyError";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "enhanceRemoteProcessing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

