/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.compatibility;

import com.android.tools.idea.gradle.project.sync.compatibility.VersionCompatibilityChecker;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompatibilityChecksMetadataUpdater {
    private static final String LAST_CHECK_TIMESTAMP_PROPERTY_NAME = "android-component-compatibility-check";
    private final CheckInterval myCheckInterval;

    public CompatibilityChecksMetadataUpdater() {
        String checkIntervalProperty = System.getProperty("android.version.compatibility.check.interval");
        this.myCheckInterval = CheckInterval.find(checkIntervalProperty);
    }

    void initiateUpdateIfNecessary() {
        long lastUpdateCheck;
        if (this.myCheckInterval != CheckInterval.NONE && this.myCheckInterval.needsUpdate(lastUpdateCheck = PropertiesComponent.getInstance().getOrInitLong(LAST_CHECK_TIMESTAMP_PROPERTY_NAME, -1L))) {
            CompatibilityChecksMetadataUpdater.fetchVersionMetadataUpdate(false);
        }
    }

    public void fetchVersionMetadataUpdate() {
        CompatibilityChecksMetadataUpdater.fetchVersionMetadataUpdate(true);
    }

    private static void fetchVersionMetadataUpdate(boolean startedByUser) {
        CompatibilityChecksMetadataUpdater.fetchMetadata().doWhenDone(() -> {
            long now = System.currentTimeMillis();
            PropertiesComponent.getInstance().setValue(LAST_CHECK_TIMESTAMP_PROPERTY_NAME, String.valueOf(now));
        });
    }

    @NotNull
    private static ActionCallback fetchMetadata() {
        ActionCallback callback = new ActionCallback();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            String url = "https://dl.google.com/android/studio/metadata/android-component-compatibility.xml";
            try {
                Element metadata = (Element)HttpRequests.request((String)url).connect(request -> {
                    try {
                        return JDOMUtil.load((InputStream)request.getInputStream());
                    }
                    catch (Throwable e) {
                        CompatibilityChecksMetadataUpdater.getLogger().info("Failed to parse XML metadata", e);
                        return null;
                    }
                });
                if (metadata != null) {
                    VersionCompatibilityChecker.getInstance().updateMetadata(metadata);
                    callback.setDone();
                }
            }
            catch (IOException e) {
                CompatibilityChecksMetadataUpdater.getLogger().info(String.format("Failed to connect to '%1$s'", url), (Throwable)e);
            }
            callback.setRejected();
        });
        ActionCallback actionCallback = callback;
        if (actionCallback == null) {
            CompatibilityChecksMetadataUpdater.$$$reportNull$$$0(0);
        }
        return actionCallback;
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(CompatibilityChecksMetadataUpdater.class);
        if (logger == null) {
            CompatibilityChecksMetadataUpdater.$$$reportNull$$$0(1);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/android/tools/idea/gradle/project/sync/compatibility/CompatibilityChecksMetadataUpdater";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchMetadata";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    static enum CheckInterval {
        NONE(Long.MAX_VALUE),
        DAILY(TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS)),
        WEEKLY(TimeUnit.MILLISECONDS.convert(7L, TimeUnit.DAYS)),
        TESTING(-1L);

        private final long myIntervalInMs;

        private CheckInterval(long intervalInMs) {
            this.myIntervalInMs = intervalInMs;
        }

        boolean needsUpdate(long lastUpdateTimestampInMs) {
            return System.currentTimeMillis() - lastUpdateTimestampInMs >= this.myIntervalInMs;
        }

        @NotNull
        static CheckInterval find(@Nullable String value) {
            if (StringUtil.isNotEmpty((String)value)) {
                for (CheckInterval checkInterval : CheckInterval.values()) {
                    if (!value.equalsIgnoreCase(checkInterval.name())) continue;
                    CheckInterval checkInterval2 = checkInterval;
                    if (checkInterval2 == null) {
                        CheckInterval.$$$reportNull$$$0(0);
                    }
                    return checkInterval2;
                }
            }
            CheckInterval checkInterval = WEEKLY;
            if (checkInterval == null) {
                CheckInterval.$$$reportNull$$$0(1);
            }
            return checkInterval;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/compatibility/CompatibilityChecksMetadataUpdater$CheckInterval", "find"));
        }
    }
}

