/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.builder.model.AndroidProject;
import com.android.java.model.ArtifactModel;
import com.android.java.model.JavaLibrary;
import com.android.java.model.JavaProject;
import com.android.java.model.SourceSet;
import com.android.tools.idea.gradle.model.java.JarLibraryDependency;
import com.android.tools.idea.gradle.model.java.JavaModuleContentRoot;
import com.android.tools.idea.gradle.model.java.JavaModuleDependency;
import com.android.tools.idea.gradle.model.java.NewJarLibraryDependencyFactory;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.tooling.model.GradleProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExtIdeaCompilerOutput;
import org.jetbrains.plugins.gradle.tooling.internal.IdeaCompilerOutputImpl;

public class JavaModuleModelFactory {
    @NotNull
    private static final String MAIN_SOURCE_SET_NAME = "main";
    @NotNull
    private static final String TEST_SOURCE_SET_NAME = "test";
    @NotNull
    private static final String COMPILE_SCOPE = "COMPILE";
    @NotNull
    private static final String TEST_SCOPE = "TEST";
    @NotNull
    private final NewJarLibraryDependencyFactory myNewJarLibraryDependencyFactory = new NewJarLibraryDependencyFactory();

    @NotNull
    public JavaModuleModel create(@NotNull File moduleFolderPath, @NotNull GradleProject gradleProject, @NotNull ArtifactModel jarAarModel) {
        if (moduleFolderPath == null) {
            JavaModuleModelFactory.$$$reportNull$$$0(0);
        }
        if (gradleProject == null) {
            JavaModuleModelFactory.$$$reportNull$$$0(1);
        }
        if (jarAarModel == null) {
            JavaModuleModelFactory.$$$reportNull$$$0(2);
        }
        Collection<JavaModuleContentRoot> contentRoots = JavaModuleModelFactory.getContentRoots(moduleFolderPath, gradleProject);
        JavaModuleModel javaModuleModel = new JavaModuleModel(jarAarModel.getName(), contentRoots, Collections.emptyList(), Collections.emptyList(), jarAarModel.getArtifactsByConfiguration(), null, gradleProject.getBuildDirectory(), null, JavaModuleModel.isBuildable(gradleProject), false);
        if (javaModuleModel == null) {
            JavaModuleModelFactory.$$$reportNull$$$0(3);
        }
        return javaModuleModel;
    }

    @NotNull
    private static Collection<JavaModuleContentRoot> getContentRoots(@NotNull File moduleFolderPath, @NotNull GradleProject gradleProject) {
        if (moduleFolderPath == null) {
            JavaModuleModelFactory.$$$reportNull$$$0(4);
        }
        if (gradleProject == null) {
            JavaModuleModelFactory.$$$reportNull$$$0(5);
        }
        List<File> excludeFolderPaths = Collections.singletonList(gradleProject.getBuildDirectory());
        JavaModuleContentRoot contentRoot = new JavaModuleContentRoot(moduleFolderPath, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), excludeFolderPaths);
        Set<JavaModuleContentRoot> set = Collections.singleton(contentRoot);
        if (set == null) {
            JavaModuleModelFactory.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    public JavaModuleModel create(@NotNull GradleProject gradleProject, @NotNull AndroidProject androidProject) {
        if (gradleProject == null) {
            JavaModuleModelFactory.$$$reportNull$$$0(7);
        }
        if (androidProject == null) {
            JavaModuleModelFactory.$$$reportNull$$$0(8);
        }
        String sourceCompatibility2 = androidProject.getJavaCompileOptions().getSourceCompatibility();
        JavaModuleModel javaModuleModel = new JavaModuleModel(androidProject.getName(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyMap(), (ExtIdeaCompilerOutput)new IdeaCompilerOutputImpl(), gradleProject.getBuildDirectory(), sourceCompatibility2, false, true);
        if (javaModuleModel == null) {
            JavaModuleModelFactory.$$$reportNull$$$0(9);
        }
        return javaModuleModel;
    }

    @NotNull
    public JavaModuleModel create(@NotNull File moduleFolderPath, @NotNull GradleProject gradleProject, @NotNull JavaProject javaProject) {
        if (moduleFolderPath == null) {
            JavaModuleModelFactory.$$$reportNull$$$0(10);
        }
        if (gradleProject == null) {
            JavaModuleModelFactory.$$$reportNull$$$0(11);
        }
        if (javaProject == null) {
            JavaModuleModelFactory.$$$reportNull$$$0(12);
        }
        Pair<Collection<JavaModuleDependency>, Collection<JarLibraryDependency>> dependencies = this.getDependencies(javaProject);
        String projectName = javaProject.getName();
        Collection<JavaModuleContentRoot> contentRoots = JavaModuleModelFactory.getContentRoots(moduleFolderPath, javaProject, gradleProject);
        JavaModuleModel javaModuleModel = new JavaModuleModel(projectName, contentRoots, (Collection)dependencies.first, (Collection)dependencies.second, Collections.emptyMap(), JavaModuleModelFactory.getCompilerOutput(javaProject), gradleProject.getBuildDirectory(), javaProject.getJavaLanguageLevel(), JavaModuleModel.isBuildable(gradleProject), false);
        if (javaModuleModel == null) {
            JavaModuleModelFactory.$$$reportNull$$$0(13);
        }
        return javaModuleModel;
    }

    @NotNull
    private Pair<Collection<JavaModuleDependency>, Collection<JarLibraryDependency>> getDependencies(@NotNull JavaProject javaProject) {
        if (javaProject == null) {
            JavaModuleModelFactory.$$$reportNull$$$0(14);
        }
        ArrayList<JavaModuleDependency> javaModuleDependencies = new ArrayList<JavaModuleDependency>();
        ArrayList<JarLibraryDependency> jarLibraryDependencies = new ArrayList<JarLibraryDependency>();
        SourceSets sourceSets = new SourceSets(javaProject);
        SourceSet mainSourceSet = sourceSets.getMainSourceSet();
        SourceSet testSourceSet = sourceSets.getTestSourceSet();
        if (mainSourceSet != null && testSourceSet != null) {
            Collection dependenciesForMain = mainSourceSet.getCompileClasspathDependencies();
            Collection dependenciesForTest = testSourceSet.getCompileClasspathDependencies();
            ImmutableSet dependenciesForMainInSet = ImmutableSet.copyOf((Collection)dependenciesForMain);
            for (JavaLibrary library : dependenciesForMain) {
                this.createDependency(library, COMPILE_SCOPE, javaModuleDependencies, jarLibraryDependencies);
            }
            for (JavaLibrary library : dependenciesForTest) {
                if (dependenciesForMainInSet.contains(library)) continue;
                this.createDependency(library, TEST_SCOPE, javaModuleDependencies, jarLibraryDependencies);
            }
        }
        Pair pair = Pair.create(javaModuleDependencies, jarLibraryDependencies);
        if (pair == null) {
            JavaModuleModelFactory.$$$reportNull$$$0(15);
        }
        return pair;
    }

    private void createDependency(@NotNull JavaLibrary javaLibrary, @NotNull String scope, @NotNull Collection<JavaModuleDependency> javaModuleDependencies, @NotNull Collection<JarLibraryDependency> jarLibraryDependencies) {
        if (javaLibrary == null) {
            JavaModuleModelFactory.$$$reportNull$$$0(16);
        }
        if (scope == null) {
            JavaModuleModelFactory.$$$reportNull$$$0(17);
        }
        if (javaModuleDependencies == null) {
            JavaModuleModelFactory.$$$reportNull$$$0(18);
        }
        if (jarLibraryDependencies == null) {
            JavaModuleModelFactory.$$$reportNull$$$0(19);
        }
        if (javaLibrary.getProject() != null) {
            javaModuleDependencies.add(new JavaModuleDependency(javaLibrary.getName(), scope, false));
        } else {
            JarLibraryDependency jarLibraryDependency = this.myNewJarLibraryDependencyFactory.create(javaLibrary, scope);
            if (jarLibraryDependency != null) {
                jarLibraryDependencies.add(jarLibraryDependency);
            }
        }
    }

    @NotNull
    private static ExtIdeaCompilerOutput getCompilerOutput(@NotNull JavaProject javaProject) {
        if (javaProject == null) {
            JavaModuleModelFactory.$$$reportNull$$$0(20);
        }
        IdeaCompilerOutputImpl compilerOutput = new IdeaCompilerOutputImpl();
        SourceSets sourceSets = new SourceSets(javaProject);
        SourceSet mainSourceSet = sourceSets.getMainSourceSet();
        SourceSet testSourceSet = sourceSets.getTestSourceSet();
        if (mainSourceSet != null && testSourceSet != null) {
            compilerOutput.setMainClassesDir(mainSourceSet.getClassesOutputDirectory());
            compilerOutput.setMainResourcesDir(mainSourceSet.getResourcesOutputDirectory());
            compilerOutput.setTestClassesDir(testSourceSet.getClassesOutputDirectory());
            compilerOutput.setTestResourcesDir(testSourceSet.getResourcesOutputDirectory());
        }
        IdeaCompilerOutputImpl ideaCompilerOutputImpl = compilerOutput;
        if (ideaCompilerOutputImpl == null) {
            JavaModuleModelFactory.$$$reportNull$$$0(21);
        }
        return ideaCompilerOutputImpl;
    }

    @NotNull
    private static Collection<JavaModuleContentRoot> getContentRoots(@NotNull File moduleFolderPath, @NotNull JavaProject javaProject, @NotNull GradleProject gradleProject) {
        if (moduleFolderPath == null) {
            JavaModuleModelFactory.$$$reportNull$$$0(22);
        }
        if (javaProject == null) {
            JavaModuleModelFactory.$$$reportNull$$$0(23);
        }
        if (gradleProject == null) {
            JavaModuleModelFactory.$$$reportNull$$$0(24);
        }
        ArrayList<File> sourceFolderPaths = new ArrayList<File>();
        ArrayList<File> resourceFolderPaths = new ArrayList<File>();
        ArrayList<File> testFolderPaths = new ArrayList<File>();
        ArrayList<File> testResourceFolderPaths = new ArrayList<File>();
        for (SourceSet sourceSet : javaProject.getSourceSets()) {
            if (sourceSet.getName().equals(TEST_SOURCE_SET_NAME)) {
                testFolderPaths.addAll(sourceSet.getSourceDirectories());
                testResourceFolderPaths.addAll(sourceSet.getResourcesDirectories());
                continue;
            }
            sourceFolderPaths.addAll(sourceSet.getSourceDirectories());
            resourceFolderPaths.addAll(sourceSet.getResourcesDirectories());
        }
        ArrayList<File> excludeFolderPaths = new ArrayList<File>();
        excludeFolderPaths.add(gradleProject.getBuildDirectory());
        JavaModuleContentRoot contentRoot = new JavaModuleContentRoot(moduleFolderPath, sourceFolderPaths, Collections.emptyList(), resourceFolderPaths, testFolderPaths, Collections.emptyList(), testResourceFolderPaths, excludeFolderPaths);
        Set<JavaModuleContentRoot> set = Collections.singleton(contentRoot);
        if (set == null) {
            JavaModuleModelFactory.$$$reportNull$$$0(25);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 13: 
            case 15: 
            case 21: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 13: 
            case 15: 
            case 21: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFolderPath";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 11: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProject";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarAarModel";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 13: 
            case 15: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/model/JavaModuleModelFactory";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidProject";
                break;
            }
            case 12: 
            case 14: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaProject";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaLibrary";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaModuleDependencies";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarLibraryDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/model/JavaModuleModelFactory";
                break;
            }
            case 3: 
            case 9: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 6: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRoots";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerOutput";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 13: 
            case 15: 
            case 21: 
            case 25: {
                break;
            }
            case 4: 
            case 5: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getContentRoots";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createDependency";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerOutput";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 13: 
            case 15: 
            case 21: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SourceSets {
        @NotNull
        private final Map<String, SourceSet> mySourceSetByName;

        SourceSets(@NotNull JavaProject javaProject) {
            if (javaProject == null) {
                SourceSets.$$$reportNull$$$0(0);
            }
            this.mySourceSetByName = javaProject.getSourceSets().stream().collect(Collectors.toMap(SourceSet::getName, SourceSet2 -> SourceSet2));
        }

        @Nullable
        SourceSet getMainSourceSet() {
            return this.mySourceSetByName.get(JavaModuleModelFactory.MAIN_SOURCE_SET_NAME);
        }

        @Nullable
        SourceSet getTestSourceSet() {
            return this.mySourceSetByName.get(JavaModuleModelFactory.TEST_SOURCE_SET_NAME);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaProject", "com/android/tools/idea/gradle/project/model/JavaModuleModelFactory$SourceSets", "<init>"));
        }
    }
}

