/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.common;

import com.android.ide.common.repository.GoogleMavenRepositoryKt;
import com.android.java.model.JavaProject;
import com.android.java.model.builder.JavaLibraryPlugin;
import com.android.tools.idea.gradle.eclipse.GradleImport;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleInitScripts {
    @NotNull
    private final EmbeddedDistributionPaths myEmbeddedDistributionPaths;
    @NotNull
    private final ContentCreator myContentCreator;

    @NotNull
    public static GradleInitScripts getInstance() {
        GradleInitScripts gradleInitScripts = (GradleInitScripts)ServiceManager.getService(GradleInitScripts.class);
        if (gradleInitScripts == null) {
            GradleInitScripts.$$$reportNull$$$0(0);
        }
        return gradleInitScripts;
    }

    public GradleInitScripts(@NotNull EmbeddedDistributionPaths embeddedDistributionPaths) {
        if (embeddedDistributionPaths == null) {
            GradleInitScripts.$$$reportNull$$$0(1);
        }
        this(embeddedDistributionPaths, new ContentCreator());
    }

    @VisibleForTesting
    GradleInitScripts(@NotNull EmbeddedDistributionPaths embeddedDistributionPaths, @NotNull ContentCreator contentCreator) {
        if (embeddedDistributionPaths == null) {
            GradleInitScripts.$$$reportNull$$$0(2);
        }
        if (contentCreator == null) {
            GradleInitScripts.$$$reportNull$$$0(3);
        }
        this.myEmbeddedDistributionPaths = embeddedDistributionPaths;
        this.myContentCreator = contentCreator;
    }

    public void addLocalMavenRepoInitScriptCommandLineArg(@NotNull List<String> allArgs) {
        File initScriptFile;
        if (allArgs == null) {
            GradleInitScripts.$$$reportNull$$$0(4);
        }
        if ((initScriptFile = this.createLocalMavenRepoInitScriptFile()) != null) {
            GradleInitScripts.addInitScriptCommandLineArg(initScriptFile, allArgs);
        }
    }

    @Nullable
    private File createLocalMavenRepoInitScriptFile() {
        String content;
        List repoPaths = this.myEmbeddedDistributionPaths.findAndroidStudioLocalMavenRepoPaths().stream().map(File::getPath).collect(Collectors.toCollection(ArrayList::new));
        if (!"https://maven.google.com/".equals(GoogleMavenRepositoryKt.GMAVEN_BASE_URL)) {
            repoPaths.add(GoogleMavenRepositoryKt.GMAVEN_BASE_URL);
        }
        if ((content = this.myContentCreator.createLocalMavenRepoInitScriptContent(repoPaths)) != null) {
            String fileName = "sync.local.repo";
            try {
                return GradleInitScripts.createInitScriptFile(fileName, content);
            }
            catch (Throwable e) {
                String message = String.format("Failed to set up Gradle init script: '%1$s'", fileName);
                GradleInitScripts.getLogger().warn(message, e);
            }
        }
        return null;
    }

    public void addApplyJavaLibraryPluginInitScriptCommandLineArg(@NotNull List<String> allArgs) {
        if (allArgs == null) {
            GradleInitScripts.$$$reportNull$$$0(5);
        }
        try {
            File initScriptFile = this.createApplyJavaLibraryPluginInitScriptFile();
            GradleInitScripts.addInitScriptCommandLineArg(initScriptFile, allArgs);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create init script that applies the Java library plugin", e);
        }
    }

    @NotNull
    private File createApplyJavaLibraryPluginInitScriptFile() throws IOException {
        String content = this.myContentCreator.createApplyJavaLibraryPluginInitScriptContent();
        File file = GradleInitScripts.createInitScriptFile("sync.java.lib", content);
        if (file == null) {
            GradleInitScripts.$$$reportNull$$$0(6);
        }
        return file;
    }

    @NotNull
    private static File createInitScriptFile(@NotNull String fileName, @NotNull String content) throws IOException {
        if (fileName == null) {
            GradleInitScripts.$$$reportNull$$$0(7);
        }
        if (content == null) {
            GradleInitScripts.$$$reportNull$$$0(8);
        }
        File file = FileUtil.createTempFile((String)fileName, (String)".gradle");
        file.deleteOnExit();
        FileUtil.writeToFile((File)file, (String)content);
        GradleInitScripts.getLogger().info(String.format("init script file %s contents %s", fileName, GradleInitScripts.escapeAsStringLiteral(content)));
        File file2 = file;
        if (file2 == null) {
            GradleInitScripts.$$$reportNull$$$0(9);
        }
        return file2;
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(GradleInitScripts.class);
        if (logger == null) {
            GradleInitScripts.$$$reportNull$$$0(10);
        }
        return logger;
    }

    @NotNull
    private static String escapeAsStringLiteral(@NotNull String s) {
        if (s == null) {
            GradleInitScripts.$$$reportNull$$$0(11);
        }
        Escaper escaper = Escapers.builder().addEscape('\b', "\\b").addEscape('\t', "\\t").addEscape('\n', "\\n").addEscape('\f', "\\f").addEscape('\r', "\\r").addEscape('\"', "\\\"").addEscape('\\', "\\\\").build();
        String string = "\"" + escaper.escape(s) + "\"";
        if (string == null) {
            GradleInitScripts.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static void addInitScriptCommandLineArg(@NotNull File initScriptFile, @NotNull List<String> allArgs) {
        if (initScriptFile == null) {
            GradleInitScripts.$$$reportNull$$$0(13);
        }
        if (allArgs == null) {
            GradleInitScripts.$$$reportNull$$$0(14);
        }
        allArgs.add("--init-script");
        allArgs.add(initScriptFile.getAbsolutePath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/common/GradleInitScripts";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embeddedDistributionPaths";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentCreator";
                break;
            }
            case 4: 
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allArgs";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initScriptFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/common/GradleInitScripts";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createApplyJavaLibraryPluginInitScriptFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createInitScriptFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeAsStringLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addLocalMavenRepoInitScriptCommandLineArg";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addApplyJavaLibraryPluginInitScriptCommandLineArg";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createInitScriptFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "escapeAsStringLiteral";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addInitScriptCommandLineArg";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class JavaLibraryPluginJars {
        JavaLibraryPluginJars() {
        }

        @NotNull
        List<String> getJarPaths() {
            List<String> list = Arrays.asList(PathManager.getJarPathForClass(JavaProject.class), PathManager.getJarPathForClass(JavaLibraryPlugin.class));
            if (list == null) {
                JavaLibraryPluginJars.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/common/GradleInitScripts$JavaLibraryPluginJars", "getJarPaths"));
        }
    }

    @VisibleForTesting
    static class ContentCreator {
        @NotNull
        private final JavaLibraryPluginJars myJavaLibraryPluginJars;

        ContentCreator() {
            this(new JavaLibraryPluginJars());
        }

        ContentCreator(@NotNull JavaLibraryPluginJars javaLibraryPluginJars) {
            if (javaLibraryPluginJars == null) {
                ContentCreator.$$$reportNull$$$0(0);
            }
            this.myJavaLibraryPluginJars = javaLibraryPluginJars;
        }

        @Nullable
        String createLocalMavenRepoInitScriptContent(@NotNull List<String> repoPaths) {
            if (repoPaths == null) {
                ContentCreator.$$$reportNull$$$0(1);
            }
            if (repoPaths.isEmpty()) {
                return null;
            }
            String paths = "";
            for (String path : repoPaths) {
                path = GradleImport.escapeGroovyStringLiteral(path);
                paths = paths + "      maven { url '" + path + "'}\n";
            }
            return "allprojects {\n  buildscript {\n    repositories {\n" + paths + "    }\n  }\n  repositories {\n" + paths + "  }\n}\n";
        }

        @NotNull
        String createApplyJavaLibraryPluginInitScriptContent() {
            List<String> paths = this.myJavaLibraryPluginJars.getJarPaths();
            StringBuilder classpath = new StringBuilder();
            classpath.append("classpath files([");
            int pathCount = paths.size();
            for (int i = 0; i < pathCount; ++i) {
                String jarPath = GradleImport.escapeGroovyStringLiteral(paths.get(i));
                classpath.append("'").append(jarPath).append("'");
                if (i >= pathCount - 1) continue;
                classpath.append(", ");
            }
            classpath.append("])");
            String string = "initscript {\n    dependencies {\n        " + classpath.toString() + "\n    }\n}\nallprojects {\n    apply plugin: " + JavaLibraryPlugin.class.getName() + "\n}\n";
            if (string == null) {
                ContentCreator.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "javaLibraryPluginJars";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repoPaths";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/common/GradleInitScripts$ContentCreator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/common/GradleInitScripts$ContentCreator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createApplyJavaLibraryPluginInitScriptContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createLocalMavenRepoInitScriptContent";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

