/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.output;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageJsonSerializer;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.intellij.build.FilePosition;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.FileMessageEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleBuildOutputParser
implements BuildOutputParser {
    private static final String MESSAGES_GROUP = "Android issues";

    public boolean parse(@NotNull String line, @NotNull BuildOutputInstantReader reader, @NotNull Consumer<? super MessageEvent> messageConsumer) {
        if (line == null) {
            GradleBuildOutputParser.$$$reportNull$$$0(0);
        }
        if (reader == null) {
            GradleBuildOutputParser.$$$reportNull$$$0(1);
        }
        if (messageConsumer == null) {
            GradleBuildOutputParser.$$$reportNull$$$0(2);
        }
        if (line.startsWith("AGPBI: ")) {
            return GradleBuildOutputParser.processMessage(line, reader.getBuildId(), messageConsumer);
        }
        return false;
    }

    private static boolean processMessage(@NotNull String line, @NotNull Object buildId, @NotNull Consumer<? super MessageEvent> messageConsumer) {
        String jsonString;
        if (line == null) {
            GradleBuildOutputParser.$$$reportNull$$$0(3);
        }
        if (buildId == null) {
            GradleBuildOutputParser.$$$reportNull$$$0(4);
        }
        if (messageConsumer == null) {
            GradleBuildOutputParser.$$$reportNull$$$0(5);
        }
        if ((jsonString = line.substring("AGPBI: ".length()).trim()).isEmpty()) {
            return false;
        }
        GsonBuilder gsonBuilder = new GsonBuilder();
        MessageJsonSerializer.registerTypeAdapters((GsonBuilder)gsonBuilder);
        Gson gson = gsonBuilder.create();
        try {
            Message msg = (Message)gson.fromJson(jsonString, Message.class);
            String detailMessage = msg.getText() + SystemProperties.getLineSeparator() + msg.toString();
            boolean validPosition = false;
            for (SourceFilePosition sourceFilePosition : msg.getSourceFilePositions()) {
                FilePosition filePosition = GradleBuildOutputParser.convertToFilePosition(sourceFilePosition);
                if (filePosition == null) continue;
                validPosition = true;
                messageConsumer.accept((MessageEvent)new FileMessageEventImpl(buildId, GradleBuildOutputParser.convertKind(msg.getKind()), MESSAGES_GROUP, msg.getText(), detailMessage, filePosition));
            }
            if (!validPosition) {
                messageConsumer.accept((MessageEvent)new MessageEventImpl(buildId, GradleBuildOutputParser.convertKind(msg.getKind()), MESSAGES_GROUP, msg.getText(), detailMessage));
            }
        }
        catch (JsonParseException ignored) {
            messageConsumer.accept((MessageEvent)new MessageEventImpl(buildId, MessageEvent.Kind.WARNING, MESSAGES_GROUP, line, line));
        }
        return true;
    }

    @Contract(pure=true)
    @NotNull
    private static MessageEvent.Kind convertKind(@NotNull Message.Kind kind) {
        if (kind == null) {
            GradleBuildOutputParser.$$$reportNull$$$0(6);
        }
        switch (kind) {
            case ERROR: {
                MessageEvent.Kind kind2 = MessageEvent.Kind.ERROR;
                if (kind2 == null) {
                    GradleBuildOutputParser.$$$reportNull$$$0(7);
                }
                return kind2;
            }
            case WARNING: {
                MessageEvent.Kind kind3 = MessageEvent.Kind.WARNING;
                if (kind3 == null) {
                    GradleBuildOutputParser.$$$reportNull$$$0(8);
                }
                return kind3;
            }
            case INFO: {
                MessageEvent.Kind kind4 = MessageEvent.Kind.INFO;
                if (kind4 == null) {
                    GradleBuildOutputParser.$$$reportNull$$$0(9);
                }
                return kind4;
            }
            case STATISTICS: {
                MessageEvent.Kind kind5 = MessageEvent.Kind.STATISTICS;
                if (kind5 == null) {
                    GradleBuildOutputParser.$$$reportNull$$$0(10);
                }
                return kind5;
            }
            case UNKNOWN: {
                MessageEvent.Kind kind6 = MessageEvent.Kind.ERROR;
                if (kind6 == null) {
                    GradleBuildOutputParser.$$$reportNull$$$0(11);
                }
                return kind6;
            }
            case SIMPLE: {
                MessageEvent.Kind kind7 = MessageEvent.Kind.SIMPLE;
                if (kind7 == null) {
                    GradleBuildOutputParser.$$$reportNull$$$0(12);
                }
                return kind7;
            }
        }
        MessageEvent.Kind kind8 = MessageEvent.Kind.ERROR;
        if (kind8 == null) {
            GradleBuildOutputParser.$$$reportNull$$$0(13);
        }
        return kind8;
    }

    @Nullable
    private static FilePosition convertToFilePosition(@NotNull SourceFilePosition sourceFilePosition) {
        File sourceFile;
        if (sourceFilePosition == null) {
            GradleBuildOutputParser.$$$reportNull$$$0(14);
        }
        if ((sourceFile = sourceFilePosition.getFile().getSourceFile()) == null) {
            return null;
        }
        SourcePosition position = sourceFilePosition.getPosition();
        int startLine = position.getStartLine();
        int endLine = position.getEndLine();
        int startColumn = position.getStartColumn();
        int endColumn = position.getEndColumn();
        return new FilePosition(sourceFile, startLine, startColumn, endLine, endColumn);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageConsumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/build/output/GradleBuildOutputParser";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFilePosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/build/output/GradleBuildOutputParser";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "convertKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processMessage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertKind";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "convertToFilePosition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

