/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.gradle.project.facet.java.JavaFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.setup.module.ModuleFinder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.concurrency.JobLauncher;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Ref;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;

public class ProjectStructure {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Object myLock;
    @GuardedBy(value="myLock")
    @NotNull
    private final AndroidPluginVersionsInProject myPluginVersionsInProject;
    @GuardedBy(value="myLock")
    @NotNull
    private final List<Module> myAppModules;
    @GuardedBy(value="myLock")
    @NotNull
    private final List<Module> myLeafModules;
    @GuardedBy(value="myLock")
    @NotNull
    private final Ref<ModuleFinder> myModuleFinderRef;

    @NotNull
    public static ProjectStructure getInstance(@NotNull Project project) {
        if (project == null) {
            ProjectStructure.$$$reportNull$$$0(0);
        }
        ProjectStructure projectStructure = (ProjectStructure)ServiceManager.getService((Project)project, ProjectStructure.class);
        if (projectStructure == null) {
            ProjectStructure.$$$reportNull$$$0(1);
        }
        return projectStructure;
    }

    public ProjectStructure(@NotNull Project project) {
        if (project == null) {
            ProjectStructure.$$$reportNull$$$0(2);
        }
        this.myLock = new Object();
        this.myPluginVersionsInProject = new AndroidPluginVersionsInProject();
        this.myAppModules = new ArrayList<Module>();
        this.myLeafModules = new ArrayList<Module>();
        this.myModuleFinderRef = new Ref((Object)ModuleFinder.EMPTY);
        this.myProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyzeProjectStructure(@NotNull ProgressIndicator progressIndicator) {
        if (progressIndicator == null) {
            ProjectStructure.$$$reportNull$$$0(3);
        }
        AndroidPluginVersionsInProject pluginVersionsInProject = new AndroidPluginVersionsInProject();
        ArrayList appModules = new ArrayList();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        List<Module> modules = Arrays.asList(moduleManager.getModules());
        ArrayList<Module> leafModules = new ArrayList<Module>(modules);
        ModuleFinder moduleFinder = new ModuleFinder(this.myProject);
        JobLauncher jobLauncher = JobLauncher.getInstance();
        jobLauncher.invokeConcurrentlyUnderProgress(modules, progressIndicator, true, module -> {
            GradleFacet gradleFacet = GradleFacet.getInstance(module);
            if (gradleFacet != null) {
                String gradlePath = ((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH;
                moduleFinder.addModule((Module)module, gradlePath);
                AndroidModuleModel androidModel = AndroidModuleModel.get(module);
                if (androidModel != null) {
                    pluginVersionsInProject.add(gradlePath, androidModel);
                    if (ProjectStructure.isApp(androidModel)) {
                        appModules.add(module);
                    }
                } else {
                    JavaFacet javaFacet = JavaFacet.getInstance(module);
                    if (javaFacet != null && !((JavaFacetConfiguration)javaFacet.getConfiguration()).BUILDABLE) {
                        leafModules.remove(module);
                    }
                    return true;
                }
                ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
                leafModules.removeAll(Arrays.asList(rootManager.getDependencies()));
            } else {
                leafModules.remove(module);
            }
            return true;
        });
        Object object = this.myLock;
        synchronized (object) {
            this.myPluginVersionsInProject.copy(pluginVersionsInProject);
            this.myLeafModules.clear();
            this.myLeafModules.addAll(leafModules);
            this.myAppModules.clear();
            this.myAppModules.addAll(appModules);
            this.myModuleFinderRef.set((Object)moduleFinder);
        }
    }

    private static boolean isApp(@NotNull AndroidModuleModel androidModel) {
        int projectType;
        if (androidModel == null) {
            ProjectStructure.$$$reportNull$$$0(4);
        }
        return (projectType = androidModel.getAndroidProject().getProjectType()) == 0 || projectType == 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public AndroidPluginVersionsInProject getAndroidPluginVersions() {
        AndroidPluginVersionsInProject pluginVersionsInProject = new AndroidPluginVersionsInProject();
        Object object = this.myLock;
        synchronized (object) {
            pluginVersionsInProject.copy(this.myPluginVersionsInProject);
        }
        AndroidPluginVersionsInProject androidPluginVersionsInProject = pluginVersionsInProject;
        if (androidPluginVersionsInProject == null) {
            ProjectStructure.$$$reportNull$$$0(5);
        }
        return androidPluginVersionsInProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public ImmutableList<Module> getAppModules() {
        Object object = this.myLock;
        // MONITORENTER : object
        ImmutableList immutableList = ImmutableList.copyOf(this.myAppModules);
        // MONITOREXIT : object
        if (immutableList != null) return immutableList;
        ProjectStructure.$$$reportNull$$$0(6);
        return immutableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public ImmutableList<Module> getLeafModules() {
        Object object = this.myLock;
        // MONITORENTER : object
        ImmutableList immutableList = ImmutableList.copyOf(this.myLeafModules);
        // MONITOREXIT : object
        if (immutableList != null) return immutableList;
        ProjectStructure.$$$reportNull$$$0(7);
        return immutableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public ModuleFinder getModuleFinder() {
        Object object = this.myLock;
        // MONITORENTER : object
        ModuleFinder moduleFinder = (ModuleFinder)this.myModuleFinderRef.get();
        // MONITOREXIT : object
        if (moduleFinder != null) return moduleFinder;
        ProjectStructure.$$$reportNull$$$0(8);
        return moduleFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearData() {
        Object object = this.myLock;
        synchronized (object) {
            this.myPluginVersionsInProject.clear();
            this.myAppModules.clear();
            this.myLeafModules.clear();
            this.myModuleFinderRef.set((Object)ModuleFinder.EMPTY);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/ProjectStructure";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/ProjectStructure";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidPluginVersions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppModules";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeafModules";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleFinder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "analyzeProjectStructure";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isApp";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class AndroidPluginVersionsInProject {
        @NotNull
        private final Map<String, GradleVersion> myAgpVersionsPerModule = new HashMap<String, GradleVersion>();

        void copy(@NotNull AndroidPluginVersionsInProject other) {
            if (other == null) {
                AndroidPluginVersionsInProject.$$$reportNull$$$0(0);
            }
            this.myAgpVersionsPerModule.putAll(other.myAgpVersionsPerModule);
        }

        void add(@NotNull String gradlePath, @NotNull AndroidModuleModel androidModel) {
            GradleVersion modelVersion;
            if (gradlePath == null) {
                AndroidPluginVersionsInProject.$$$reportNull$$$0(1);
            }
            if (androidModel == null) {
                AndroidPluginVersionsInProject.$$$reportNull$$$0(2);
            }
            if ((modelVersion = androidModel.getModelVersion()) != null) {
                this.add(gradlePath, modelVersion);
            }
        }

        @VisibleForTesting
        void add(@NotNull String gradlePath, @NotNull GradleVersion modelVersion) {
            if (gradlePath == null) {
                AndroidPluginVersionsInProject.$$$reportNull$$$0(3);
            }
            if (modelVersion == null) {
                AndroidPluginVersionsInProject.$$$reportNull$$$0(4);
            }
            this.myAgpVersionsPerModule.put(gradlePath, modelVersion);
        }

        void clear() {
            this.myAgpVersionsPerModule.clear();
        }

        public boolean haveVersionsChanged(@NotNull AndroidPluginVersionsInProject other) {
            if (other == null) {
                AndroidPluginVersionsInProject.$$$reportNull$$$0(5);
            }
            if (!other.isEmpty()) {
                if (this.myAgpVersionsPerModule.size() != other.myAgpVersionsPerModule.size()) {
                    return true;
                }
                for (Map.Entry<String, GradleVersion> entry : this.myAgpVersionsPerModule.entrySet()) {
                    String modulePath = entry.getKey();
                    GradleVersion otherAgpVersion = other.myAgpVersionsPerModule.get(modulePath);
                    if (otherAgpVersion != null && entry.getValue().compareTo(otherAgpVersion) == 0) continue;
                    return true;
                }
            }
            return false;
        }

        boolean isEmpty() {
            return this.myAgpVersionsPerModule.isEmpty();
        }

        @VisibleForTesting
        @NotNull
        ImmutableMap<String, GradleVersion> getInternalMap() {
            ImmutableMap immutableMap = ImmutableMap.copyOf(this.myAgpVersionsPerModule);
            if (immutableMap == null) {
                AndroidPluginVersionsInProject.$$$reportNull$$$0(6);
            }
            return immutableMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gradlePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "androidModel";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelVersion";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/ProjectStructure$AndroidPluginVersionsInProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/ProjectStructure$AndroidPluginVersionsInProject";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInternalMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "copy";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "haveVersionsChanged";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

