/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.parser;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.BuildFileStatement;
import com.android.tools.idea.gradle.parser.BuildFileStatementFactory;
import com.android.tools.idea.gradle.parser.GradleGroovyFile;
import com.android.tools.idea.gradle.parser.ValueFactory;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringContent;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;

public class Dependency
extends BuildFileStatement {
    private static final Logger LOG = Logger.getInstance(Dependency.class);
    @NonNls
    private static final String FILE_TREE_BASE_DIR_PROPERTY = "dir";
    @NonNls
    private static final String FILE_TREE_INCLUDE_PATTERN_PROPERTY = "include";
    public Scope scope;
    public Type type;
    public Object data;
    public String extraClosure;

    public Dependency(@NotNull Scope scope, @NotNull Type type, @NotNull Object data, @Nullable String extraClosure) {
        if (scope == null) {
            Dependency.$$$reportNull$$$0(0);
        }
        if (type == null) {
            Dependency.$$$reportNull$$$0(1);
        }
        if (data == null) {
            Dependency.$$$reportNull$$$0(2);
        }
        this.scope = scope;
        this.type = type;
        this.data = data;
        this.extraClosure = extraClosure;
    }

    public Dependency(@NotNull Scope scope, @NotNull Type type, @NotNull Object data) {
        if (scope == null) {
            Dependency.$$$reportNull$$$0(3);
        }
        if (type == null) {
            Dependency.$$$reportNull$$$0(4);
        }
        if (data == null) {
            Dependency.$$$reportNull$$$0(5);
        }
        this(scope, type, data, null);
    }

    @Override
    @NotNull
    public List<PsiElement> getGroovyElements(@NotNull GroovyPsiElementFactory factory) {
        String extraGroovyCode;
        if (factory == null) {
            Dependency.$$$reportNull$$$0(6);
        }
        switch (this.type) {
            case EXTERNAL: {
                if (this.extraClosure != null) {
                    extraGroovyCode = "(" + Dependency.escapeAndQuote(this.data) + ")";
                    break;
                }
                extraGroovyCode = " " + Dependency.escapeAndQuote(this.data);
                break;
            }
            case MODULE: {
                extraGroovyCode = this.data instanceof Map ? " project(" + GradleGroovyFile.convertMapToGroovySource((Map)this.data) + ")" : " project(" + Dependency.escapeAndQuote(this.data) + ")";
                if (this.extraClosure == null) break;
                extraGroovyCode = "(" + extraGroovyCode.substring(1) + ")";
                break;
            }
            case FILES: {
                extraGroovyCode = " files(" + Dependency.escapeAndQuote(this.data) + ")";
                break;
            }
            case FILETREE: {
                extraGroovyCode = " fileTree(" + GradleGroovyFile.convertMapToGroovySource((Map)this.data) + ")";
                break;
            }
            default: {
                extraGroovyCode = "";
            }
        }
        GrStatement statement = factory.createStatementFromText((CharSequence)(this.scope.getGroovyMethodCall() + extraGroovyCode));
        if (statement instanceof GrMethodCall && this.extraClosure != null) {
            statement.add((PsiElement)factory.createClosureFromText(this.extraClosure));
        }
        ImmutableList immutableList = ImmutableList.of((Object)statement);
        if (immutableList == null) {
            Dependency.$$$reportNull$$$0(7);
        }
        return immutableList;
    }

    @NotNull
    private static String escapeAndQuote(@Nullable Object data) {
        if (data == null) {
            if ("''" == null) {
                Dependency.$$$reportNull$$$0(8);
            }
            return "''";
        }
        String stringContent = data.toString();
        boolean gstring = false;
        int i = stringContent.indexOf(36);
        while (i >= 0 && i < stringContent.length()) {
            if (i <= 0 || stringContent.charAt(i - 1) != '\\') {
                gstring = true;
                break;
            }
            i = stringContent.indexOf(36, i + 1);
        }
        char quote = gstring ? (char)'\"' : '\'';
        String string = quote + BuildFileKey.escapeLiteralString(stringContent) + quote;
        if (string == null) {
            Dependency.$$$reportNull$$$0(9);
        }
        return string;
    }

    public boolean matches(@NotNull Dependency dependency) {
        List includes;
        if (dependency == null) {
            Dependency.$$$reportNull$$$0(10);
        }
        if (this.equals(dependency)) {
            return true;
        }
        if (this.scope != dependency.scope) {
            return false;
        }
        String s1 = this.data.toString();
        String s2 = dependency.data.toString();
        switch (this.type) {
            default: {
                if (dependency.type != Type.MODULE) {
                    return false;
                }
                if (this.data instanceof Map) {
                    s1 = GradleGroovyFile.convertMapToGroovySource((Map)this.data).replaceAll("path: ':", "path: '");
                }
                if (dependency.data instanceof Map) {
                    s2 = GradleGroovyFile.convertMapToGroovySource((Map)dependency.data).replaceAll("path: ':", "path: '");
                }
                s1 = StringUtil.trimStart((String)s1, (String)":");
                s2 = StringUtil.trimStart((String)s2, (String)":");
                return s1.equals(s2);
            }
            case EXTERNAL: {
                if (dependency.type != Type.EXTERNAL) {
                    return false;
                }
                if (s1.startsWith("com.android.support:appcompat-v7") && s2.startsWith("com.android.support:support-v4")) {
                    return true;
                }
                String[] tokens1 = s1.split(":");
                String[] tokens2 = s2.split(":");
                if (tokens1.length < 2 || tokens2.length < 2) {
                    return false;
                }
                return tokens1[0].equals(tokens2[0]) && tokens1[1].equals(tokens2[1]);
            }
            case FILES: {
                if (dependency.type != Type.FILES) {
                    return false;
                }
                return FileUtil.pathsEqual((String)s1, (String)s2);
            }
            case FILETREE: 
        }
        if (dependency.type != Type.FILES) {
            return false;
        }
        Map values = (Map)this.data;
        String dir = (String)values.get(FILE_TREE_BASE_DIR_PROPERTY);
        Object value = values.get(FILE_TREE_INCLUDE_PATTERN_PROPERTY);
        if (value == null) {
            return false;
        }
        List list = includes = value instanceof List ? (List)value : ImmutableList.of((Object)value.toString());
        if (dir == null || includes == null) {
            return false;
        }
        File baseDir = new File(dir);
        File depFile = new File(s2);
        File depDir = depFile.getParentFile();
        if (depDir == null) {
            return false;
        }
        if (FileUtil.filesEqual((File)baseDir, (File)depDir)) {
            for (String glob : includes) {
                Pattern pattern = Pattern.compile(FileUtil.convertAntToRegexp((String)glob));
                if (!pattern.matcher(depFile.getName()).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dependency that = (Dependency)o;
        if (this.data != null ? !this.data.equals(that.data) : that.data != null) {
            return false;
        }
        if (this.scope != that.scope) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.scope, this.type, this.data});
    }

    public String toString() {
        return "Dependency {myScope=" + (Object)((Object)this.scope) + ", myType=" + (Object)((Object)this.type) + ", myData='" + this.data + '\'' + '}';
    }

    @NotNull
    public String getValueAsString() {
        String string = this.data.toString();
        if (string == null) {
            Dependency.$$$reportNull$$$0(11);
        }
        return string;
    }

    public static ValueFactory getFactory() {
        return new DependencyFactory();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/parser/Dependency";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/parser/Dependency";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroovyElements";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeAndQuote";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueAsString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getGroovyElements";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DependencyFactory
    extends BuildFileStatementFactory {
        private DependencyFactory() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public List<BuildFileStatement> getValues(@NotNull PsiElement statement) {
            ArrayList dependencies;
            block25: {
                GroovyPsiElement[] allArguments;
                String extraClosure;
                Scope scope;
                GrMethodCall call;
                block26: {
                    block29: {
                        GroovyPsiElement element;
                        block30: {
                            block27: {
                                String methodName;
                                GrMethodCall method;
                                block28: {
                                    if (statement == null) {
                                        DependencyFactory.$$$reportNull$$$0(0);
                                    }
                                    if (!(statement instanceof GrMethodCall)) {
                                        List<BuildFileStatement> list = DependencyFactory.getUnparseableStatements(statement);
                                        if (list == null) {
                                            DependencyFactory.$$$reportNull$$$0(1);
                                        }
                                        return list;
                                    }
                                    call = (GrMethodCall)statement;
                                    scope = Scope.fromMethodCall(GradleGroovyFile.getMethodCallName(call));
                                    if (scope == null) {
                                        List<BuildFileStatement> list = DependencyFactory.getUnparseableStatements(statement);
                                        if (list == null) {
                                            DependencyFactory.$$$reportNull$$$0(2);
                                        }
                                        return list;
                                    }
                                    extraClosure = null;
                                    GrClosableBlock[] closureArguments = ((GrMethodCall)statement).getClosureArguments();
                                    if (closureArguments.length > 0) {
                                        extraClosure = closureArguments[0].getText();
                                    }
                                    GrArgumentList argumentList = call.getArgumentList();
                                    dependencies = Lists.newArrayList();
                                    allArguments = argumentList.getAllArguments();
                                    if (allArguments.length != 1) break block26;
                                    element = allArguments[0];
                                    if (!(element instanceof GrMethodCall)) break block27;
                                    method = (GrMethodCall)element;
                                    methodName = GradleGroovyFile.getMethodCallName(method);
                                    if (!"project".equals(methodName)) break block28;
                                    Object value = GradleGroovyFile.getFirstLiteralArgumentValue(method);
                                    if (value != null) {
                                        dependencies.add(new Dependency(scope, Type.MODULE, value.toString(), extraClosure));
                                        break block25;
                                    } else {
                                        Map<String, Object> values = GradleGroovyFile.getNamedArgumentValues(method);
                                        if (!values.isEmpty()) {
                                            dependencies.add(new Dependency(scope, Type.MODULE, values, extraClosure));
                                        }
                                    }
                                    break block25;
                                }
                                if ("files".equals(methodName)) {
                                    for (Object o : GradleGroovyFile.getLiteralArgumentValues(method)) {
                                        dependencies.add(new Dependency(scope, Type.FILES, o.toString(), extraClosure));
                                    }
                                    break block25;
                                } else if ("fileTree".equals(methodName)) {
                                    Map<String, Object> values = GradleGroovyFile.getNamedArgumentValues(method);
                                    dependencies.add(new Dependency(scope, Type.FILETREE, values, extraClosure));
                                    break block25;
                                } else {
                                    LOG.warn("Didn't know how to parse dependency method call " + methodName);
                                }
                                break block25;
                            }
                            if (!(element instanceof GrLiteral)) break block29;
                            Object value = ((GrLiteral)element).getValue();
                            if (value == null) break block30;
                            dependencies.add(new Dependency(scope, Type.EXTERNAL, value.toString(), extraClosure));
                            break block25;
                        }
                        if (element instanceof GrString) {
                            GroovyPsiElement[] contentParts = ((GrString)element).getAllContentParts();
                            StringBuilder buffer = new StringBuilder();
                            for (GroovyPsiElement part : contentParts) {
                                if (!(part instanceof GrStringContent) && !(part instanceof GrStringInjection)) continue;
                                buffer.append(part.getText());
                            }
                            if (buffer.length() > 0) {
                                dependencies.add(new Dependency(scope, Type.EXTERNAL, buffer.toString(), extraClosure));
                            }
                        }
                        break block25;
                    }
                    List<BuildFileStatement> list = DependencyFactory.getUnparseableStatements(statement);
                    if (list == null) {
                        DependencyFactory.$$$reportNull$$$0(3);
                    }
                    return list;
                }
                if (allArguments.length > 1) {
                    Map<String, Object> attributes = GradleGroovyFile.getNamedArgumentValues(call);
                    if (attributes.isEmpty()) {
                        List<BuildFileStatement> list = DependencyFactory.getUnparseableStatements(statement);
                        if (list == null) {
                            DependencyFactory.$$$reportNull$$$0(4);
                        }
                        return list;
                    }
                    Object groupId = attributes.get("group");
                    Object artifactId = attributes.get("name");
                    Object version = attributes.get("version");
                    Object ext = attributes.get("ext");
                    if (groupId == null || artifactId == null || version == null) {
                        List<BuildFileStatement> list = DependencyFactory.getUnparseableStatements(statement);
                        if (list == null) {
                            DependencyFactory.$$$reportNull$$$0(5);
                        }
                        return list;
                    }
                    String coordinate = Joiner.on((String)":").join(groupId, artifactId, new Object[]{version});
                    if (ext != null) {
                        coordinate = coordinate + "@" + ext;
                    }
                    dependencies.add(new Dependency(scope, Type.EXTERNAL, coordinate, extraClosure));
                }
            }
            ArrayList arrayList = dependencies;
            if (arrayList == null) {
                DependencyFactory.$$$reportNull$$$0(6);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/parser/Dependency$DependencyFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/parser/Dependency$DependencyFactory";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getValues";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum Type {
        FILES,
        FILETREE,
        EXTERNAL,
        MODULE;

    }

    public static enum Scope {
        COMPILE("Compile", "compile", true, true, true),
        PROVIDED("Provided", "provided", true, false, true),
        APK("APK", "apk", true, false, true),
        ANDROID_TEST_COMPILE("Test compile", "androidTestCompile", true, false, true),
        DEBUG_COMPILE("Debug compile", "debugCompile", true, false, true),
        RELEASE_COMPILE("Release compile", "releaseCompile", true, false, true),
        RUNTIME("Runtime", "runtime", false, true, true),
        TEST_COMPILE("Test compile", "testCompile", false, true, true),
        TEST_RUNTIME("Test runtime", "testRuntime", false, true, true),
        IMPLEMENTATION("Implementation", "implementation", true, true, false),
        API("API", "api", true, true, false),
        COMPILE_ONLY("Compile only", "compileOnly", true, false, false),
        RUNTIME_ONLY("Runtime only", "runtimeOnly", true, false, false),
        UNIT_TEST_IMPLEMENTATION("Unit Test implementation", "testImplementation", true, false, false),
        ANDROID_TEST_IMPLEMENTATION("Test implementation", "androidTestImplementation", true, false, false),
        DEBUG_IMPLEMENTATION("Debug implementation", "debugImplementation", true, false, false),
        RELEASE_IMPLEMENTATION("Release implementation", "releaseImplementation", true, false, false),
        TEST_COMPILE_ONLY("Test compile only", "testCompileOnly", false, true, false),
        TEST_RUNTIME_ONLY("Test runtime only", "testRuntimeOnly", false, true, false);

        private final String myGroovyMethodCall;
        private final String myDisplayName;
        private final boolean myAndroidScope;
        private final boolean myJavaScope;
        private final boolean myCompat;

        private Scope(String displayName, String groovyMethodCall, boolean androidScope, boolean javaScope, boolean compat) {
            if (displayName == null) {
                Scope.$$$reportNull$$$0(0);
            }
            if (groovyMethodCall == null) {
                Scope.$$$reportNull$$$0(1);
            }
            this.myDisplayName = displayName;
            this.myGroovyMethodCall = groovyMethodCall;
            this.myAndroidScope = androidScope;
            this.myJavaScope = javaScope;
            this.myCompat = compat;
        }

        public String getGroovyMethodCall() {
            return this.myGroovyMethodCall;
        }

        @Nullable
        public static Scope fromMethodCall(@NotNull String methodCall) {
            if (methodCall == null) {
                Scope.$$$reportNull$$$0(2);
            }
            for (Scope scope : Scope.values()) {
                if (!scope.myGroovyMethodCall.equals(methodCall)) continue;
                return scope;
            }
            return null;
        }

        @NotNull
        public String getDisplayName() {
            String string = this.myDisplayName;
            if (string == null) {
                Scope.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean isAndroidScope() {
            return this.myAndroidScope;
        }

        public boolean isJavaScope() {
            return this.myJavaScope;
        }

        public boolean isCompat() {
            return this.myCompat;
        }

        @NotNull
        public String toString() {
            String string = this.myDisplayName;
            if (string == null) {
                Scope.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public static Scope getDefaultScope(@NotNull Project project) {
            if (project == null) {
                Scope.$$$reportNull$$$0(5);
            }
            Scope scope = GradleUtil.useCompatibilityConfigurationNames(project) ? COMPILE : IMPLEMENTATION;
            if (scope == null) {
                Scope.$$$reportNull$$$0(6);
            }
            return scope;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "displayName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groovyMethodCall";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodCall";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/parser/Dependency$Scope";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/parser/Dependency$Scope";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "fromMethodCall";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getDefaultScope";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

