/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.parser;

import com.android.tools.idea.gradle.editor.parser.GradleEditorModelParseContext;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringContent;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class GradleEditorValueExtractor
extends GroovyRecursiveElementVisitor {
    @NotNull
    private final GradleEditorModelParseContext myContext;
    @NotNull
    private final PsiElementVisitor myVisitor;
    private boolean myInterestedInReferencesOnly;

    public GradleEditorValueExtractor(@NotNull GradleEditorModelParseContext context) {
        if (context == null) {
            GradleEditorValueExtractor.$$$reportNull$$$0(0);
        }
        this.myContext = context;
        this.myVisitor = new GroovyPsiElementVisitor((GroovyElementVisitor)this);
    }

    @Nullable
    public static Pair<String, TextRange> extractMethodName(@NotNull PsiElement methodCall) {
        GrReferenceExpression methodNameRef;
        if (methodCall == null) {
            GradleEditorValueExtractor.$$$reportNull$$$0(1);
        }
        if ((methodNameRef = (GrReferenceExpression)PsiTreeUtil.findChildOfType((PsiElement)methodCall, GrReferenceExpression.class)) == null || methodNameRef.getParent() != methodCall) {
            return null;
        }
        String methodName = methodNameRef.getReferenceName();
        if (methodName == null) {
            return null;
        }
        return Pair.create((Object)methodName, (Object)methodNameRef.getTextRange());
    }

    public void extractValueOrVariable(@NotNull PsiElement element) {
        if (element == null) {
            GradleEditorValueExtractor.$$$reportNull$$$0(2);
        }
        element.accept(this.myVisitor);
    }

    public void visitLiteralExpression(@NotNull GrLiteral literal) {
        if (literal == null) {
            GradleEditorValueExtractor.$$$reportNull$$$0(3);
        }
        if (this.myInterestedInReferencesOnly) {
            return;
        }
        Object value = literal.getValue();
        if (value != null) {
            String stringValue = String.valueOf(value);
            int i = literal.getText().indexOf(stringValue);
            if (i >= 0) {
                TextRange range = TextRange.create((int)(literal.getTextOffset() + i), (int)(literal.getTextOffset() + i + stringValue.length()));
                this.myContext.addCachedValue(stringValue, range);
            }
        }
    }

    public void visitGStringExpression(@NotNull GrString expression) {
        if (expression == null) {
            GradleEditorValueExtractor.$$$reportNull$$$0(4);
        }
        GroovyPsiElement[] parts = expression.getAllContentParts();
        boolean registeredAssignment = false;
        for (GroovyPsiElement part : parts) {
            GrExpression injectedExpression;
            if (part instanceof GrStringContent) {
                if (this.myInterestedInReferencesOnly || registeredAssignment || part.getTextRange().isEmpty()) continue;
                registeredAssignment = true;
                String text = expression.getText();
                TextRange range = expression.getTextRange();
                if (text.startsWith("'") || text.startsWith("\"")) {
                    text = text.substring(1);
                    range = TextRange.create((int)(range.getStartOffset() + 1), (int)range.getEndOffset());
                }
                if (text.endsWith("'") || text.endsWith("\"")) {
                    text = text.substring(0, text.length() - 1);
                    range = TextRange.create((int)range.getStartOffset(), (int)(range.getEndOffset() - 1));
                }
                this.myContext.addCachedValue(text, range);
                continue;
            }
            if (!(part instanceof GrStringInjection) || (injectedExpression = ((GrStringInjection)part).getExpression()) == null) continue;
            injectedExpression.accept(this.myVisitor);
        }
    }

    public void visitReferenceExpression(@NotNull GrReferenceExpression expression) {
        if (expression == null) {
            GradleEditorValueExtractor.$$$reportNull$$$0(5);
        }
        if (expression.getParent() instanceof GrMethodCallExpression) {
            return;
        }
        GrExpression qualifier = expression.getQualifierExpression();
        if (qualifier == null) {
            this.myContext.addCachedVariable(expression.getText(), expression.getTextRange());
            return;
        }
        this.myContext.rememberVariableQualifier(qualifier.getText());
        PsiElement dotToken = expression.getDotToken();
        if (dotToken == null) {
            return;
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.findSingle((Object)GroovyLanguage.INSTANCE);
        for (PsiElement e = dotToken.getNextSibling(); e != null; e = e.getNextSibling()) {
            ASTNode node = e.getNode();
            if (node == null) {
                if (e instanceof PsiWhiteSpace) continue;
                e.accept(this.myVisitor);
                return;
            }
            IElementType type = node.getElementType();
            if (type == GroovyTokenTypes.mIDENT) {
                this.myContext.addCachedVariable(e.getText(), e.getTextRange());
            } else {
                if (parserDefinition.getWhitespaceTokens().contains(type) || parserDefinition.getCommentTokens().contains(type)) continue;
                e.accept(this.myVisitor);
            }
            return;
        }
    }

    public void visitElement(@NotNull GroovyPsiElement element) {
        if (element == null) {
            GradleEditorValueExtractor.$$$reportNull$$$0(6);
        }
        if (!this.myInterestedInReferencesOnly) {
            this.myInterestedInReferencesOnly = true;
            this.myContext.addCachedValue("", element.getTextRange());
        }
        super.visitElement(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/editor/parser/GradleEditorValueExtractor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "extractMethodName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "extractValueOrVariable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitLiteralExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitGStringExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

