/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.api.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.api.values.GradleNullableValue;
import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValueImpl;
import com.android.tools.idea.gradle.dsl.model.values.GradleNullableValueImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GradlePropertiesDslElement
extends GradleDslElement {
    @NotNull
    private Map<String, GradleDslElement> myProperties;
    @NotNull
    private Map<String, GradleDslElement> myAdjustedProperties;
    @NotNull
    private Map<String, GradleDslElement> myVariables;

    protected GradlePropertiesDslElement(@Nullable GradleDslElement parent, @Nullable PsiElement psiElement, @NotNull String name) {
        if (name == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(0);
        }
        super(parent, psiElement, name);
        this.myProperties = new LinkedHashMap<String, GradleDslElement>();
        this.myAdjustedProperties = new LinkedHashMap<String, GradleDslElement>();
        this.myVariables = new LinkedHashMap<String, GradleDslElement>();
    }

    private void addPropertyInternal(@NotNull String property2, @NotNull GradleDslElement element) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(1);
        }
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(2);
        }
        this.myVariables.put(property2, element);
        this.myProperties.put(property2, element);
    }

    @Nullable
    private GradleDslElement removePropertyInternal(@NotNull String property2) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(3);
        }
        this.myProperties.remove(property2);
        return this.myVariables.remove(property2);
    }

    private LinkedHashMap<String, GradleDslElement> replayPropertyAdjustmentsOnto(@NotNull Map<String, GradleDslElement> map) {
        if (map == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(4);
        }
        LinkedHashMap<String, GradleDslElement> newMap = new LinkedHashMap<String, GradleDslElement>();
        newMap.putAll(map);
        this.myAdjustedProperties.forEach((k, v) -> {
            if (v == null) {
                newMap.remove(k);
            } else {
                newMap.put((String)k, (GradleDslElement)v);
            }
        });
        return newMap;
    }

    public void setParsedVariable(@NotNull String variable, @NotNull GradleDslElement element) {
        if (variable == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(5);
        }
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(6);
        }
        element.myParent = this;
        this.myVariables.put(variable, element);
    }

    public void setParsedElement(@NotNull String property2, @NotNull GradleDslElement element) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(7);
        }
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(8);
        }
        element.myParent = this;
        this.addPropertyInternal(property2, element);
    }

    public void addParsedElement(@NotNull String property2, @NotNull GradleDslElement element) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(9);
        }
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(10);
        }
        element.myParent = this;
        this.addPropertyInternal(property2, element);
    }

    protected void addParsedResettingElement(@NotNull String property2, @NotNull GradleDslElement element, @NotNull String propertyToReset) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(11);
        }
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(12);
        }
        if (propertyToReset == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(13);
        }
        element.myParent = this;
        this.addPropertyInternal(property2, element);
        this.removePropertyInternal(propertyToReset);
    }

    protected void addAsParsedDslExpressionList(@NotNull String property2, GradleDslExpression dslLiteral) {
        PsiElement psiElement;
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(14);
        }
        if ((psiElement = dslLiteral.getPsiElement()) == null) {
            return;
        }
        GradleDslExpressionList literalList = new GradleDslExpressionList(this, psiElement, property2, true);
        literalList.addParsedExpression(dslLiteral);
        this.addPropertyInternal(property2, literalList);
    }

    public void addToParsedExpressionList(@NotNull String property2, @NotNull GradleDslElement element) {
        PsiElement psiElement;
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(15);
        }
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(16);
        }
        if ((psiElement = element.getPsiElement()) == null) {
            return;
        }
        GradleDslExpressionList gradleDslExpressionList = this.getPropertyElement(property2, GradleDslExpressionList.class);
        if (gradleDslExpressionList == null) {
            gradleDslExpressionList = new GradleDslExpressionList(this, psiElement, property2);
            this.addPropertyInternal(property2, gradleDslExpressionList);
        } else {
            gradleDslExpressionList.setPsiElement(psiElement);
        }
        if (element instanceof GradleDslExpression) {
            gradleDslExpressionList.addParsedExpression((GradleDslExpression)element);
        } else if (element instanceof GradleDslExpressionList) {
            List<GradleDslExpression> gradleExpressions = ((GradleDslExpressionList)element).getExpressions();
            for (GradleDslExpression expression : gradleExpressions) {
                gradleDslExpressionList.addParsedExpression(expression);
            }
        }
    }

    @NotNull
    public Set<String> getProperties() {
        Set<String> set = this.getPropertyElements().keySet();
        if (set == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(17);
        }
        return set;
    }

    @NotNull
    public Map<String, GradleDslElement> getPropertyElements() {
        LinkedHashMap<String, GradleDslElement> linkedHashMap = this.replayPropertyAdjustmentsOnto(this.myProperties);
        if (linkedHashMap == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(18);
        }
        return linkedHashMap;
    }

    private static boolean isPropertyNested(@NotNull String property2) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(19);
        }
        return property2.contains(".");
    }

    @Nullable
    public GradleDslElement getVariableElement(@NotNull String property2) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(20);
        }
        if (!GradlePropertiesDslElement.isPropertyNested(property2)) {
            LinkedHashMap<String, GradleDslElement> map = this.replayPropertyAdjustmentsOnto(this.myVariables);
            return (GradleDslElement)map.get(property2);
        }
        return this.searchForNestedProperty(property2);
    }

    @Nullable
    public GradleDslElement getPropertyElement(@NotNull String property2) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(21);
        }
        if (!GradlePropertiesDslElement.isPropertyNested(property2)) {
            LinkedHashMap<String, GradleDslElement> map = this.replayPropertyAdjustmentsOnto(this.myProperties);
            return (GradleDslElement)map.get(property2);
        }
        return this.searchForNestedProperty(property2);
    }

    @Nullable
    private GradleDslElement searchForNestedProperty(@NotNull String property2) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(22);
        }
        List propertyNameSegments = Splitter.on((char)'.').splitToList((CharSequence)property2);
        GradlePropertiesDslElement nestedElement = this;
        for (int i = 0; i < propertyNameSegments.size() - 1; ++i) {
            GradleDslElement element = nestedElement.getPropertyElement(((String)propertyNameSegments.get(i)).trim());
            if (!(element instanceof GradlePropertiesDslElement)) {
                return null;
            }
            nestedElement = (GradlePropertiesDslElement)element;
        }
        return nestedElement.getPropertyElement((String)propertyNameSegments.get(propertyNameSegments.size() - 1));
    }

    @Nullable
    public <T extends GradleDslElement> T getPropertyElement(@NotNull String property2, @NotNull Class<T> clazz) {
        GradleDslElement propertyElement;
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(23);
        }
        if (clazz == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(24);
        }
        return (T)(clazz.isInstance(propertyElement = this.getPropertyElement(property2)) ? (GradleDslElement)clazz.cast(propertyElement) : null);
    }

    private static <T> GradleNullableValue<T> createAndWrapDslValue(@Nullable GradleDslElement element, @NotNull Class<T> clazz) {
        if (clazz == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(25);
        }
        if (element == null) {
            return new GradleNullableValueImpl<Object>(null, null);
        }
        Object resultValue = null;
        if (clazz.isInstance(element)) {
            resultValue = clazz.cast(element);
        } else if (element instanceof GradleDslExpression) {
            resultValue = ((GradleDslExpression)element).getValue(clazz);
        }
        if (resultValue != null) {
            return new GradleNotNullValueImpl<Object>(element, resultValue);
        }
        return new GradleNullableValueImpl<Object>(element, null);
    }

    @NotNull
    public <T> GradleNullableValue<T> getLiteralProperty(@NotNull String property2, @NotNull Class<T> clazz) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(26);
        }
        if (clazz == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(27);
        }
        Preconditions.checkArgument((clazz == String.class || clazz == Integer.class || clazz == Boolean.class ? 1 : 0) != 0);
        GradleNullableValue<T> gradleNullableValue = GradlePropertiesDslElement.createAndWrapDslValue(this.getPropertyElement(property2), clazz);
        if (gradleNullableValue == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(28);
        }
        return gradleNullableValue;
    }

    @NotNull
    public GradleDslElement setNewElement(@NotNull String property2, @NotNull GradleDslElement newElement) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(29);
        }
        if (newElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(30);
        }
        newElement.myParent = this;
        this.myAdjustedProperties.put(property2, newElement);
        this.setModified(true);
        GradleDslElement gradleDslElement = newElement;
        if (gradleDslElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(31);
        }
        return gradleDslElement;
    }

    @NotNull
    public GradleDslElement setNewLiteral(@NotNull String property2, @NotNull Object value) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(32);
        }
        if (value == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(33);
        }
        GradleDslElement gradleDslElement = this.setNewLiteralImpl(property2, value);
        if (gradleDslElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(34);
        }
        return gradleDslElement;
    }

    @NotNull
    private GradleDslElement setNewLiteralImpl(@NotNull String property2, @NotNull Object value) {
        GradleDslLiteral literalElement;
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(35);
        }
        if (value == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(36);
        }
        if ((literalElement = this.getPropertyElement(property2, GradleDslLiteral.class)) == null) {
            literalElement = new GradleDslLiteral(this, property2);
            this.myAdjustedProperties.put(property2, literalElement);
        }
        literalElement.setValue(value);
        GradleDslLiteral gradleDslLiteral = literalElement;
        if (gradleDslLiteral == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(37);
        }
        return gradleDslLiteral;
    }

    @NotNull
    public GradlePropertiesDslElement addToNewLiteralList(@NotNull String property2, @NotNull String value) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(38);
        }
        if (value == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(39);
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this.addToNewLiteralListImpl(property2, value);
        if (gradlePropertiesDslElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(40);
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    private GradlePropertiesDslElement addToNewLiteralListImpl(@NotNull String property2, @NotNull Object value) {
        GradleDslExpressionList gradleDslExpressionList;
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(41);
        }
        if (value == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(42);
        }
        if ((gradleDslExpressionList = this.getPropertyElement(property2, GradleDslExpressionList.class)) == null) {
            gradleDslExpressionList = new GradleDslExpressionList(this, property2);
            this.myAdjustedProperties.put(property2, gradleDslExpressionList);
        }
        gradleDslExpressionList.addNewLiteral(value);
        GradlePropertiesDslElement gradlePropertiesDslElement = this;
        if (gradlePropertiesDslElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(43);
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    public GradlePropertiesDslElement removeFromExpressionList(@NotNull String property2, @NotNull String value) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(44);
        }
        if (value == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(45);
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this.removeFromExpressionListImpl(property2, value);
        if (gradlePropertiesDslElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(46);
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    private GradlePropertiesDslElement removeFromExpressionListImpl(@NotNull String property2, @NotNull Object value) {
        GradleDslExpressionList gradleDslExpressionList;
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(47);
        }
        if (value == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(48);
        }
        if ((gradleDslExpressionList = this.getPropertyElement(property2, GradleDslExpressionList.class)) != null) {
            gradleDslExpressionList.removeExpression(value);
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this;
        if (gradlePropertiesDslElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(49);
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    public GradlePropertiesDslElement replaceInExpressionList(@NotNull String property2, @NotNull String oldValue, @NotNull String newValue) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(50);
        }
        if (oldValue == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(51);
        }
        if (newValue == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(52);
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this.replaceInExpressionListImpl(property2, oldValue, newValue);
        if (gradlePropertiesDslElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(53);
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    private GradlePropertiesDslElement replaceInExpressionListImpl(@NotNull String property2, @NotNull Object oldValue, @NotNull Object newValue) {
        GradleDslExpressionList gradleDslExpressionList;
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(54);
        }
        if (oldValue == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(55);
        }
        if (newValue == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(56);
        }
        if ((gradleDslExpressionList = this.getPropertyElement(property2, GradleDslExpressionList.class)) != null) {
            gradleDslExpressionList.replaceExpression(oldValue, newValue);
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this;
        if (gradlePropertiesDslElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(57);
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    public GradlePropertiesDslElement setInNewLiteralMap(@NotNull String property2, @NotNull String name, @NotNull String value) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(58);
        }
        if (name == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(59);
        }
        if (value == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(60);
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this.setInNewLiteralMapImpl(property2, name, value);
        if (gradlePropertiesDslElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(61);
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    public GradlePropertiesDslElement setInNewLiteralMap(@NotNull String property2, @NotNull String name, @NotNull Integer value) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(62);
        }
        if (name == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(63);
        }
        if (value == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(64);
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this.setInNewLiteralMapImpl(property2, name, value);
        if (gradlePropertiesDslElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(65);
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    public GradlePropertiesDslElement setInNewLiteralMap(@NotNull String property2, @NotNull String name, @NotNull Boolean value) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(66);
        }
        if (name == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(67);
        }
        if (value == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(68);
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this.setInNewLiteralMapImpl(property2, name, value);
        if (gradlePropertiesDslElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(69);
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    private GradlePropertiesDslElement setInNewLiteralMapImpl(@NotNull String property2, @NotNull String name, @NotNull Object value) {
        GradleDslExpressionMap gradleDslExpressionMap;
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(70);
        }
        if (name == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(71);
        }
        if (value == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(72);
        }
        if ((gradleDslExpressionMap = this.getPropertyElement(property2, GradleDslExpressionMap.class)) == null) {
            gradleDslExpressionMap = new GradleDslExpressionMap(this, property2);
            this.myAdjustedProperties.put(property2, gradleDslExpressionMap);
        }
        gradleDslExpressionMap.addNewLiteral(name, value);
        GradlePropertiesDslElement gradlePropertiesDslElement = this;
        if (gradlePropertiesDslElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(73);
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    public GradlePropertiesDslElement removeFromExpressionMap(@NotNull String property2, @NotNull String name) {
        GradleDslExpressionMap gradleDslExpressionMap;
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(74);
        }
        if (name == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(75);
        }
        if ((gradleDslExpressionMap = this.getPropertyElement(property2, GradleDslExpressionMap.class)) != null) {
            gradleDslExpressionMap.removeProperty(name);
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this;
        if (gradlePropertiesDslElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(76);
        }
        return gradlePropertiesDslElement;
    }

    public GradlePropertiesDslElement removeProperty(@NotNull String property2) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(77);
        }
        this.myAdjustedProperties.put(property2, null);
        this.setModified(true);
        return this;
    }

    @Nullable
    public <E> List<GradleNotNullValue<E>> getListProperty(@NotNull String property2, @NotNull Class<E> clazz) {
        GradleDslExpressionList gradleDslExpressionList;
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(78);
        }
        if (clazz == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(79);
        }
        if ((gradleDslExpressionList = this.getPropertyElement(property2, GradleDslExpressionList.class)) != null) {
            return gradleDslExpressionList.getValues(clazz);
        }
        return null;
    }

    @Nullable
    public <V> Map<String, GradleNotNullValue<V>> getMapProperty(@NotNull String property2, @NotNull Class<V> clazz) {
        GradleDslExpressionMap gradleDslExpressionMap;
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(80);
        }
        if (clazz == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(81);
        }
        if ((gradleDslExpressionMap = this.getPropertyElement(property2, GradleDslExpressionMap.class)) != null) {
            return gradleDslExpressionMap.getValues(clazz);
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<GradleDslElement> getChildren() {
        Collection<GradleDslElement> collection = this.getPropertyElements().values();
        if (collection == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(82);
        }
        return collection;
    }

    @Override
    protected void apply() {
        this.myAdjustedProperties.forEach((property2, element) -> {
            GradleDslElement oldElement = this.removePropertyInternal((String)property2);
            if (oldElement != null) {
                oldElement.delete();
            }
            if (element != null && element.create() != null) {
                this.setParsedElement((String)property2, (GradleDslElement)element);
            }
        });
        this.myAdjustedProperties.clear();
        for (GradleDslElement element2 : this.myVariables.values()) {
            if (!element2.isModified()) continue;
            element2.applyChanges();
        }
    }

    @Override
    protected void reset() {
        for (GradleDslElement element : this.getPropertyElements().values()) {
            if (!element.isModified()) continue;
            element.resetState();
        }
        this.myAdjustedProperties.clear();
    }

    protected void clear() {
        this.myAdjustedProperties.clear();
        this.myProperties.clear();
        this.myVariables.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 18: 
            case 28: 
            case 31: 
            case 34: 
            case 37: 
            case 40: 
            case 43: 
            case 46: 
            case 49: 
            case 53: 
            case 57: 
            case 61: 
            case 65: 
            case 69: 
            case 73: 
            case 76: 
            case 82: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 18: 
            case 28: 
            case 31: 
            case 34: 
            case 37: 
            case 40: 
            case 43: 
            case 46: 
            case 49: 
            case 53: 
            case 57: 
            case 61: 
            case 65: 
            case 69: 
            case 73: 
            case 76: 
            case 82: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 35: 
            case 38: 
            case 41: 
            case 44: 
            case 47: 
            case 50: 
            case 54: 
            case 58: 
            case 62: 
            case 66: 
            case 70: 
            case 74: 
            case 77: 
            case 78: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyToReset";
                break;
            }
            case 17: 
            case 18: 
            case 28: 
            case 31: 
            case 34: 
            case 37: 
            case 40: 
            case 43: 
            case 46: 
            case 49: 
            case 53: 
            case 57: 
            case 61: 
            case 65: 
            case 69: 
            case 73: 
            case 76: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement";
                break;
            }
            case 24: 
            case 25: 
            case 27: 
            case 79: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 33: 
            case 36: 
            case 39: 
            case 42: 
            case 45: 
            case 48: 
            case 60: 
            case 64: 
            case 68: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 51: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldValue";
                break;
            }
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyElements";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralProperty";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "setNewElement";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "setNewLiteral";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "setNewLiteralImpl";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "addToNewLiteralList";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "addToNewLiteralListImpl";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "removeFromExpressionList";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "removeFromExpressionListImpl";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceInExpressionList";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceInExpressionListImpl";
                break;
            }
            case 61: 
            case 65: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "setInNewLiteralMap";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "setInNewLiteralMapImpl";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "removeFromExpressionMap";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyInternal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyInternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replayPropertyAdjustmentsOnto";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setParsedVariable";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setParsedElement";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addParsedElement";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addParsedResettingElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addAsParsedDslExpressionList";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addToParsedExpressionList";
                break;
            }
            case 17: 
            case 18: 
            case 28: 
            case 31: 
            case 34: 
            case 37: 
            case 40: 
            case 43: 
            case 46: 
            case 49: 
            case 53: 
            case 57: 
            case 61: 
            case 65: 
            case 69: 
            case 73: 
            case 76: 
            case 82: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyNested";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getVariableElement";
                break;
            }
            case 21: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyElement";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "searchForNestedProperty";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createAndWrapDslValue";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralProperty";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setNewElement";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setNewLiteral";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setNewLiteralImpl";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addToNewLiteralList";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "addToNewLiteralListImpl";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "removeFromExpressionList";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "removeFromExpressionListImpl";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "replaceInExpressionList";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "replaceInExpressionListImpl";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "setInNewLiteralMap";
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "setInNewLiteralMapImpl";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "removeFromExpressionMap";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "removeProperty";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getListProperty";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getMapProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 18: 
            case 28: 
            case 31: 
            case 34: 
            case 37: 
            case 40: 
            case 43: 
            case 46: 
            case 49: 
            case 53: 
            case 57: 
            case 61: 
            case 65: 
            case 69: 
            case 73: 
            case 76: 
            case 82: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

