/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleDslMethodCall
extends GradleDslExpression {
    @NotNull
    private final List<GradleDslElement> myArguments;
    @NotNull
    private final List<GradleDslElement> myToBeRemovedArguments;
    @Nullable
    private String myStatementName;
    @Nullable
    private GradleDslElement myToBeAddedArgument;

    public GradleDslMethodCall(@NotNull GradleDslElement parent, @NotNull String methodName, @Nullable String statementName) {
        if (parent == null) {
            GradleDslMethodCall.$$$reportNull$$$0(0);
        }
        if (methodName == null) {
            GradleDslMethodCall.$$$reportNull$$$0(1);
        }
        super(parent, null, methodName, null);
        this.myArguments = Lists.newArrayList();
        this.myToBeRemovedArguments = Lists.newArrayList();
        this.myStatementName = statementName;
    }

    public GradleDslMethodCall(@NotNull GradleDslElement parent, @NotNull PsiElement methodCall, @NotNull String name) {
        if (parent == null) {
            GradleDslMethodCall.$$$reportNull$$$0(2);
        }
        if (methodCall == null) {
            GradleDslMethodCall.$$$reportNull$$$0(3);
        }
        if (name == null) {
            GradleDslMethodCall.$$$reportNull$$$0(4);
        }
        super(parent, methodCall, name, methodCall);
        this.myArguments = Lists.newArrayList();
        this.myToBeRemovedArguments = Lists.newArrayList();
    }

    public void addParsedExpression(@NotNull GradleDslExpression expression) {
        if (expression == null) {
            GradleDslMethodCall.$$$reportNull$$$0(5);
        }
        expression.myParent = this;
        this.myArguments.add(expression);
    }

    public void addParsedExpressionMap(@NotNull GradleDslExpressionMap expressionMap) {
        if (expressionMap == null) {
            GradleDslMethodCall.$$$reportNull$$$0(6);
        }
        expressionMap.myParent = this;
        this.myArguments.add(expressionMap);
    }

    public void addNewArgument(@NotNull GradleDslExpression argument) {
        if (argument == null) {
            GradleDslMethodCall.$$$reportNull$$$0(7);
        }
        this.addNewArgumentInternal(argument);
    }

    public void addNewArgument(@NotNull GradleDslExpressionMap mapArgument) {
        if (mapArgument == null) {
            GradleDslMethodCall.$$$reportNull$$$0(8);
        }
        this.addNewArgumentInternal(mapArgument);
    }

    public void commitNewArgument(@NotNull GradleDslElement element) {
        if (element == null) {
            GradleDslMethodCall.$$$reportNull$$$0(9);
        }
        this.myArguments.add(element);
    }

    private void addNewArgumentInternal(@NotNull GradleDslElement argument) {
        if (argument == null) {
            GradleDslMethodCall.$$$reportNull$$$0(10);
        }
        assert (argument instanceof GradleDslExpression || argument instanceof GradleDslExpressionMap);
        if (this.getArguments().isEmpty()) {
            this.myToBeAddedArgument = argument;
            this.setModified(true);
        }
    }

    @Nullable
    public GradleDslElement getToBeAddedArgument() {
        return this.myToBeAddedArgument;
    }

    @NotNull
    public List<GradleDslElement> getArguments() {
        if (this.myToBeRemovedArguments.isEmpty() && this.myToBeAddedArgument == null) {
            ImmutableList immutableList = ImmutableList.copyOf(this.myArguments);
            if (immutableList == null) {
                GradleDslMethodCall.$$$reportNull$$$0(11);
            }
            return immutableList;
        }
        ArrayList result = Lists.newArrayList();
        for (GradleDslElement argument : this.myArguments) {
            if (argument instanceof GradleDslReference) {
                GradleDslExpressionList listValue = ((GradleDslReference)argument).getValue(GradleDslExpressionList.class);
                if (listValue != null) {
                    result.addAll(listValue.getExpressions());
                    continue;
                }
                GradleDslExpressionMap mapValue = ((GradleDslReference)argument).getValue(GradleDslExpressionMap.class);
                if (mapValue != null) {
                    result.add(mapValue);
                    continue;
                }
            }
            result.add(argument);
        }
        if (this.myToBeAddedArgument != null) {
            result.add(this.myToBeAddedArgument);
        }
        for (GradleDslElement argument : this.myToBeRemovedArguments) {
            result.remove(argument);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            GradleDslMethodCall.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Collection<GradleDslElement> getChildren() {
        List<GradleDslElement> list = this.getArguments();
        if (list == null) {
            GradleDslMethodCall.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Override
    @Nullable
    public Object getValue() {
        if (this.myArguments.size() == 1 && this.myArguments.get(0) instanceof GradleDslExpression) {
            return ((GradleDslExpression)this.myArguments.get(0)).getValue();
        }
        PsiElement psiElement = this.getPsiElement();
        return psiElement != null ? psiElement.getText() : null;
    }

    @Override
    @Nullable
    public Object getUnresolvedValue() {
        return this.getValue();
    }

    @Override
    @Nullable
    public <T> T getValue(@NotNull Class<T> clazz) {
        if (clazz == null) {
            GradleDslMethodCall.$$$reportNull$$$0(14);
        }
        if (clazz.isAssignableFrom(File.class)) {
            return clazz.cast(this.getFileValue());
        }
        Object value = this.getValue();
        if (clazz.isInstance(value)) {
            return clazz.cast(value);
        }
        return null;
    }

    @Override
    @Nullable
    public <T> T getUnresolvedValue(@NotNull Class<T> clazz) {
        if (clazz == null) {
            GradleDslMethodCall.$$$reportNull$$$0(15);
        }
        return this.getValue(clazz);
    }

    @Nullable
    private File getFileValue() {
        if (!this.myName.equals("file")) {
            return null;
        }
        List<GradleDslElement> arguments = this.getArguments();
        if (arguments.isEmpty()) {
            return null;
        }
        GradleDslElement pathArgument = arguments.get(0);
        if (!(pathArgument instanceof GradleDslExpression)) {
            return null;
        }
        String path = ((GradleDslExpression)pathArgument).getValue(String.class);
        if (path == null) {
            return null;
        }
        return new File(path);
    }

    @Override
    public void setValue(@NotNull Object value) {
        if (value == null) {
            GradleDslMethodCall.$$$reportNull$$$0(16);
        }
        if (value instanceof File) {
            this.setFileValue((File)value);
        }
    }

    private void setFileValue(@NotNull File file) {
        if (file == null) {
            GradleDslMethodCall.$$$reportNull$$$0(17);
        }
        if (!this.myName.equals("file")) {
            return;
        }
        List<GradleDslElement> arguments = this.getArguments();
        if (arguments.isEmpty()) {
            GradleDslLiteral argument = new GradleDslLiteral(this, this.myName);
            argument.setValue(file.getPath());
            this.myToBeAddedArgument = argument;
            return;
        }
        GradleDslElement pathArgument = arguments.get(0);
        if (!(pathArgument instanceof GradleDslExpression)) {
            return;
        }
        ((GradleDslExpression)pathArgument).setValue(file.getPath());
    }

    @Nullable
    public String getStatementName() {
        return this.myStatementName;
    }

    public void remove(GradleDslElement argument) {
        if (this.myArguments.contains(argument)) {
            this.myToBeRemovedArguments.add(argument);
            this.setModified(true);
        }
    }

    @Override
    protected void apply() {
        for (GradleDslElement argument : this.myToBeRemovedArguments) {
            if (!this.myArguments.remove(argument)) continue;
            argument.delete();
        }
        this.getDslFile().getWriter().applyDslMethodCall(this);
    }

    @Override
    protected void reset() {
        this.myToBeAddedArgument = null;
        this.myToBeRemovedArguments.clear();
        for (GradleDslElement argument : this.myArguments) {
            if (!argument.isModified()) continue;
            argument.resetState();
        }
    }

    @Override
    @Nullable
    public PsiElement create() {
        return this.getDslFile().getWriter().createDslMethodCall(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionMap";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapArgument";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslMethodCall";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslMethodCall";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addParsedExpression";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addParsedExpressionMap";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addNewArgument";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "commitNewArgument";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addNewArgumentInternal";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getUnresolvedValue";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setFileValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

