/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.api.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValueImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleDslExpressionList
extends GradleDslElement {
    @NotNull
    private final List<GradleDslExpression> myExpressions;
    @NotNull
    private final List<GradleDslExpression> myToBeAddedExpressions;
    @NotNull
    private final List<GradleDslExpression> myToBeRemovedExpressions;
    private final boolean myAppendToArgumentListWithOneElement;

    public GradleDslExpressionList(@Nullable GradleDslElement parent, @NotNull String name) {
        if (name == null) {
            GradleDslExpressionList.$$$reportNull$$$0(0);
        }
        super(parent, null, name);
        this.myExpressions = Lists.newArrayList();
        this.myToBeAddedExpressions = Lists.newArrayList();
        this.myToBeRemovedExpressions = Lists.newArrayList();
        this.myAppendToArgumentListWithOneElement = false;
    }

    public GradleDslExpressionList(@NotNull GradleDslElement parent, @NotNull PsiElement psiElement, @NotNull String name) {
        if (parent == null) {
            GradleDslExpressionList.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            GradleDslExpressionList.$$$reportNull$$$0(2);
        }
        if (name == null) {
            GradleDslExpressionList.$$$reportNull$$$0(3);
        }
        this(parent, psiElement, name, false);
    }

    public GradleDslExpressionList(@NotNull GradleDslElement parent, @NotNull PsiElement psiElement, @NotNull String name, boolean appendToArgumentListWithOneElement) {
        if (parent == null) {
            GradleDslExpressionList.$$$reportNull$$$0(4);
        }
        if (psiElement == null) {
            GradleDslExpressionList.$$$reportNull$$$0(5);
        }
        if (name == null) {
            GradleDslExpressionList.$$$reportNull$$$0(6);
        }
        super(parent, psiElement, name);
        this.myExpressions = Lists.newArrayList();
        this.myToBeAddedExpressions = Lists.newArrayList();
        this.myToBeRemovedExpressions = Lists.newArrayList();
        this.myAppendToArgumentListWithOneElement = appendToArgumentListWithOneElement;
    }

    public void addParsedExpression(@NotNull GradleDslExpression expression) {
        if (expression == null) {
            GradleDslExpressionList.$$$reportNull$$$0(7);
        }
        expression.myParent = this;
        this.myExpressions.add(expression);
    }

    public void addNewExpression(@NotNull GradleDslExpression expression) {
        if (expression == null) {
            GradleDslExpressionList.$$$reportNull$$$0(8);
        }
        expression.myParent = this;
        this.myToBeAddedExpressions.add(expression);
        this.setModified(true);
    }

    public void removeElement(@NotNull GradleDslElement element) {
        if (element == null) {
            GradleDslExpressionList.$$$reportNull$$$0(9);
        }
        for (GradleDslExpression expression : this.getExpressions()) {
            if (expression != element) continue;
            this.myToBeRemovedExpressions.add(expression);
            this.setModified(true);
            return;
        }
    }

    void addNewLiteral(@NotNull Object value) {
        if (value == null) {
            GradleDslExpressionList.$$$reportNull$$$0(10);
        }
        GradleDslLiteral literal = new GradleDslLiteral(this, this.myName);
        literal.setValue(value);
        this.myToBeAddedExpressions.add(literal);
    }

    void removeExpression(@NotNull Object value) {
        if (value == null) {
            GradleDslExpressionList.$$$reportNull$$$0(11);
        }
        for (GradleDslExpression expression : this.getExpressions()) {
            if (!value.equals(expression.getValue())) continue;
            this.myToBeRemovedExpressions.add(expression);
            this.setModified(true);
            return;
        }
    }

    void replaceExpression(@NotNull Object oldValue, @NotNull Object newValue) {
        if (oldValue == null) {
            GradleDslExpressionList.$$$reportNull$$$0(12);
        }
        if (newValue == null) {
            GradleDslExpressionList.$$$reportNull$$$0(13);
        }
        for (GradleDslExpression expression : this.getExpressions()) {
            if (!oldValue.equals(expression.getValue())) continue;
            expression.setValue(newValue);
            return;
        }
    }

    @NotNull
    public List<GradleDslExpression> getExpressions() {
        if (this.myToBeAddedExpressions.isEmpty() && this.myToBeRemovedExpressions.isEmpty()) {
            ImmutableList immutableList = ImmutableList.copyOf(this.myExpressions);
            if (immutableList == null) {
                GradleDslExpressionList.$$$reportNull$$$0(14);
            }
            return immutableList;
        }
        ArrayList result = Lists.newArrayList();
        result.addAll(this.myExpressions);
        result.addAll(this.myToBeAddedExpressions);
        for (GradleDslExpression expression : this.myToBeRemovedExpressions) {
            result.remove(expression);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            GradleDslExpressionList.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    public List<GradleDslExpression> getToBeAddedExpressions() {
        List<GradleDslExpression> list = this.myToBeAddedExpressions;
        if (list == null) {
            GradleDslExpressionList.$$$reportNull$$$0(16);
        }
        return list;
    }

    public boolean isAppendToArgumentListWithOneElement() {
        return this.myAppendToArgumentListWithOneElement;
    }

    public void commitExpressions(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            GradleDslExpressionList.$$$reportNull$$$0(17);
        }
        for (GradleDslExpression expression : this.myToBeAddedExpressions) {
            expression.setPsiElement(psiElement);
            expression.applyChanges();
            this.myExpressions.add(expression);
        }
        this.myToBeAddedExpressions.clear();
    }

    @NotNull
    public <E> List<GradleNotNullValue<E>> getValues(Class<E> clazz) {
        ArrayList result = Lists.newArrayList();
        for (GradleDslExpression expression : this.getExpressions()) {
            GradleDslExpressionList referenceList;
            if (expression instanceof GradleDslReference && (referenceList = expression.getValue(GradleDslExpressionList.class)) != null) {
                result.addAll(referenceList.getValues(clazz));
                continue;
            }
            E value = expression.getValue(clazz);
            if (value == null) continue;
            result.add(new GradleNotNullValueImpl<E>(expression, value));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            GradleDslExpressionList.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @Override
    @Nullable
    public PsiElement create() {
        return this.getDslFile().getWriter().createDslExpressionList(this);
    }

    @Override
    protected void apply() {
        PsiElement psiElement = this.create();
        if (psiElement != null) {
            for (GradleDslExpression expression : this.myToBeAddedExpressions) {
                expression.setPsiElement(psiElement);
                expression.applyChanges();
                this.myExpressions.add(expression);
            }
        }
        this.myToBeAddedExpressions.clear();
        for (GradleDslExpression expression : this.myToBeRemovedExpressions) {
            if (!this.myExpressions.remove(expression)) continue;
            expression.delete();
        }
        this.myToBeRemovedExpressions.clear();
        for (GradleDslExpression expression : this.myExpressions) {
            if (!expression.isModified()) continue;
            expression.applyChanges();
        }
    }

    @Override
    protected void reset() {
        this.myToBeAddedExpressions.clear();
        this.myToBeRemovedExpressions.clear();
        for (GradleDslExpression expression : this.myExpressions) {
            if (!expression.isModified()) continue;
            expression.resetState();
        }
    }

    @Override
    @NotNull
    public Collection<GradleDslElement> getChildren() {
        List<GradleDslExpression> expressions = this.getExpressions();
        ArrayList<GradleDslElement> children = new ArrayList<GradleDslElement>(expressions.size());
        for (GradleDslExpression expression : expressions) {
            children.add(expression);
        }
        ArrayList<GradleDslElement> arrayList = children;
        if (arrayList == null) {
            GradleDslExpressionList.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldValue";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslExpressionList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslExpressionList";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressions";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getToBeAddedExpressions";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addParsedExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addNewExpression";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addNewLiteral";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeExpression";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpression";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "commitExpressions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

