/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModelImpl;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslGlobalValue;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslReference;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.settings.ProjectPropertiesDslElement;
import com.google.common.base.Splitter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GradleDslExpression
extends GradleDslElement {
    @NotNull
    private static final Pattern INDEX_PATTERN = Pattern.compile("\\[(.+?)\\]|(.+?)(?=\\[)");
    @NotNull
    private static final String SINGLE_QUOTES = "'";
    @NotNull
    private static final String DOUBLE_QUOTES = "\"";
    @Nullable
    protected PsiElement myExpression;

    protected GradleDslExpression(@Nullable GradleDslElement parent, @Nullable PsiElement psiElement, @NotNull String name, @Nullable PsiElement expression) {
        if (name == null) {
            GradleDslExpression.$$$reportNull$$$0(0);
        }
        super(parent, psiElement, name);
        this.myExpression = expression;
    }

    @Nullable
    public PsiElement getExpression() {
        return this.myExpression;
    }

    public void setExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            GradleDslExpression.$$$reportNull$$$0(1);
        }
        this.myExpression = expression;
    }

    @Nullable
    public abstract Object getValue();

    @Nullable
    public abstract Object getUnresolvedValue();

    @Nullable
    public abstract <T> T getValue(@NotNull Class<T> var1);

    @Nullable
    public abstract <T> T getUnresolvedValue(@NotNull Class<T> var1);

    public abstract void setValue(@NotNull Object var1);

    @NotNull
    public List<GradleReferenceInjection> getResolvedVariables() {
        if (this.myExpression == null) {
            List<GradleReferenceInjection> list = Collections.emptyList();
            if (list == null) {
                GradleDslExpression.$$$reportNull$$$0(2);
            }
            return list;
        }
        List list = (List)ApplicationManager.getApplication().runReadAction(() -> this.getDslFile().getParser().getInjections(this, this.myExpression));
        if (list == null) {
            GradleDslExpression.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public GradleDslElement resolveReference(@NotNull String referenceText) {
        String fullTextReference;
        GradleDslElement resolvedElement;
        GradleDslFile dslFile;
        int index;
        if (referenceText == null) {
            GradleDslExpression.$$$reportNull$$$0(4);
        }
        GradleDslElement searchStartElement = this;
        List<String> referenceTextSegments = Splitter.on((char)'.').trimResults().omitEmptyStrings().splitToList((CharSequence)referenceText);
        int segmentCount = referenceTextSegments.size();
        for (index = 0; index < segmentCount && (dslFile = GradleDslExpression.resolveProjectReference(searchStartElement, (String)referenceTextSegments.get(index))) != null; ++index) {
            searchStartElement = dslFile;
        }
        if (index >= segmentCount) {
            resolvedElement = searchStartElement;
        } else {
            referenceTextSegments = referenceTextSegments.subList(index, segmentCount);
            resolvedElement = GradleDslExpression.resolveReferenceInSameModule(searchStartElement, referenceTextSegments);
        }
        GradleDslFile dslFile2 = searchStartElement.getDslFile();
        if (resolvedElement == null) {
            resolvedElement = GradleDslExpression.resolveReferenceInParentModules(dslFile2, referenceTextSegments);
        }
        if ("rootDir".equals(fullTextReference = String.join((CharSequence)".", referenceTextSegments))) {
            return new GradleDslGlobalValue(dslFile2, Projects.getBaseDirPath((Project)dslFile2.getProject()).getPath());
        }
        if ("projectDir".equals(fullTextReference)) {
            return new GradleDslGlobalValue(dslFile2, dslFile2.getDirectoryPath().getPath());
        }
        return resolvedElement;
    }

    @Nullable
    public <T> T resolveReference(@NotNull String referenceText, @NotNull Class<T> clazz) {
        GradleDslElement resolvedElement;
        if (referenceText == null) {
            GradleDslExpression.$$$reportNull$$$0(5);
        }
        if (clazz == null) {
            GradleDslExpression.$$$reportNull$$$0(6);
        }
        if ((resolvedElement = this.resolveReference(referenceText)) != null) {
            T result = null;
            if (clazz.isInstance(resolvedElement)) {
                result = clazz.cast(resolvedElement);
            } else if (resolvedElement instanceof GradleDslExpression) {
                result = ((GradleDslExpression)resolvedElement).getValue(clazz);
            }
            if (result != null) {
                return result;
            }
        }
        if (clazz.isAssignableFrom(String.class)) {
            return clazz.cast(referenceText);
        }
        return null;
    }

    @Nullable
    private static GradleDslFile resolveProjectReference(GradleDslElement startElement, @NotNull String projectReference) {
        GradleDslFile dslFile;
        if (projectReference == null) {
            GradleDslExpression.$$$reportNull$$$0(7);
        }
        if ("project".equals(projectReference)) {
            return dslFile;
        }
        if ("parent".equals(projectReference)) {
            return dslFile.getParentModuleDslFile();
        }
        if ("rootProject".equals(projectReference)) {
            for (dslFile = startElement.getDslFile(); dslFile != null && !FileUtil.filesEqual((File)dslFile.getDirectoryPath(), (File)VfsUtilCore.virtualToIoFile((VirtualFile)dslFile.getProject().getBaseDir())); dslFile = dslFile.getParentModuleDslFile()) {
            }
            return dslFile;
        }
        String standardProjectKey = ProjectPropertiesDslElement.getStandardProjectKey(projectReference);
        if (standardProjectKey != null) {
            String modulePath = standardProjectKey.substring(standardProjectKey.indexOf(39) + 1, standardProjectKey.lastIndexOf(39));
            GradleSettingsModel model = GradleSettingsModelImpl.get(dslFile.getProject());
            if (model == null) {
                return null;
            }
            File moduleDirectory = model.moduleDirectory(modulePath);
            if (moduleDirectory == null) {
                return null;
            }
            while (dslFile != null && !FileUtil.filesEqual((File)dslFile.getDirectoryPath(), (File)VfsUtilCore.virtualToIoFile((VirtualFile)dslFile.getProject().getBaseDir()))) {
                dslFile = dslFile.getParentModuleDslFile();
            }
            if (dslFile == null) {
                return null;
            }
            return GradleDslExpression.findDslFile(dslFile, moduleDirectory);
        }
        return null;
    }

    @NotNull
    private static String stripQuotes(@NotNull String index) {
        if (index == null) {
            GradleDslExpression.$$$reportNull$$$0(8);
        }
        if (index.startsWith(SINGLE_QUOTES) && index.endsWith(SINGLE_QUOTES) || index.startsWith(DOUBLE_QUOTES) && index.endsWith(DOUBLE_QUOTES)) {
            String string = index.substring(1, index.length() - 1);
            if (string == null) {
                GradleDslExpression.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = index;
        if (string == null) {
            GradleDslExpression.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    private static GradleDslElement extractElementFromProperties(@NotNull GradlePropertiesDslElement properties, @NotNull String name, boolean sameScope) {
        Matcher indexMatcher;
        if (properties == null) {
            GradleDslExpression.$$$reportNull$$$0(11);
        }
        if (name == null) {
            GradleDslExpression.$$$reportNull$$$0(12);
        }
        if (!(indexMatcher = INDEX_PATTERN.matcher(name)).find()) {
            return sameScope ? properties.getVariableElement(name) : properties.getPropertyElement(name);
        }
        if (indexMatcher.groupCount() != 2) {
            return null;
        }
        String elementName = indexMatcher.group(0);
        if (elementName == null) {
            return null;
        }
        GradleDslElement element = sameScope ? properties.getVariableElement(elementName) : properties.getPropertyElement(elementName);
        ArrayDeque<String> indexParts = new ArrayDeque<String>();
        while (indexMatcher.find()) {
            if (indexMatcher.groupCount() != 2) {
                return null;
            }
            indexParts.add(indexMatcher.group(1));
        }
        while (!indexParts.isEmpty()) {
            String index = (String)indexParts.pop();
            if (element == null) {
                return null;
            }
            if (element instanceof GradleDslExpressionList) {
                int offset;
                try {
                    offset = Integer.parseInt(index);
                }
                catch (NumberFormatException e) {
                    return null;
                }
                GradleDslExpressionList list = (GradleDslExpressionList)element;
                element = list.getExpressions().get(offset);
                continue;
            }
            if (element instanceof GradleDslExpressionMap) {
                GradleDslExpressionMap map = (GradleDslExpressionMap)element;
                index = GradleDslExpression.stripQuotes(index);
                element = map.getPropertyElement(index);
                continue;
            }
            if (element instanceof GradleDslReference) {
                GradleDslReference reference = (GradleDslReference)element;
                GradleReferenceInjection injection = reference.getReferenceInjection();
                element = injection == null ? null : injection.getToBeInjected();
                indexParts.push(index);
                continue;
            }
            return null;
        }
        return element;
    }

    @Nullable
    private static GradleDslElement resolveReferenceOnPropertiesElement(@NotNull GradlePropertiesDslElement properties, @NotNull List<String> nameParts) {
        if (properties == null) {
            GradleDslExpression.$$$reportNull$$$0(13);
        }
        if (nameParts == null) {
            GradleDslExpression.$$$reportNull$$$0(14);
        }
        for (int i = 0; i < nameParts.size() - 1; ++i) {
            GradleDslElement element = GradleDslExpression.extractElementFromProperties(properties, nameParts.get(i), i == 0);
            if (element == null || !(element instanceof GradlePropertiesDslElement)) {
                return null;
            }
            properties = (GradlePropertiesDslElement)element;
        }
        return GradleDslExpression.extractElementFromProperties(properties, nameParts.get(nameParts.size() - 1), nameParts.size() == 1);
    }

    @Nullable
    private static GradleDslElement resolveReferenceOnElement(GradleDslElement element, @NotNull List<String> nameParts) {
        if (nameParts == null) {
            GradleDslExpression.$$$reportNull$$$0(15);
        }
        while (element != null) {
            if (element instanceof GradlePropertiesDslElement) {
                GradleDslElement propertyElement = GradleDslExpression.resolveReferenceOnPropertiesElement((GradlePropertiesDslElement)element, nameParts);
                if (propertyElement != null) {
                    return propertyElement;
                }
                if (element instanceof GradleDslFile) {
                    GradleDslElement extPropertyElement;
                    ExtDslElement extDslElement = ((GradleDslFile)element).getPropertyElement("ext", ExtDslElement.class);
                    if (extDslElement == null || (extPropertyElement = GradleDslExpression.resolveReferenceOnPropertiesElement(extDslElement, nameParts)) == null) break;
                    return extPropertyElement;
                }
            }
            element = element.getParent();
        }
        return null;
    }

    @Nullable
    private static GradleDslElement resolveReferenceInSameModule(GradleDslElement startElement, @NotNull List<String> referenceText) {
        GradleDslFile parentModuleDslFile;
        GradleDslElement element;
        if (referenceText == null) {
            GradleDslExpression.$$$reportNull$$$0(16);
        }
        if ((element = GradleDslExpression.resolveReferenceOnElement(startElement, referenceText)) != null) {
            return element;
        }
        String text = String.join((CharSequence)".", referenceText);
        GradleDslFile dslFile = startElement.getDslFile();
        GradleDslElement propertyElement = GradleDslExpression.resolveReferenceInPropertiesFile(dslFile, text);
        if (propertyElement != null) {
            return propertyElement;
        }
        if (dslFile.getParentModuleDslFile() == null) {
            return null;
        }
        GradleDslFile rootProjectDslFile = dslFile;
        while ((parentModuleDslFile = rootProjectDslFile.getParentModuleDslFile()) != null) {
            rootProjectDslFile = parentModuleDslFile;
        }
        return GradleDslExpression.resolveReferenceInPropertiesFile(rootProjectDslFile, text);
    }

    @Nullable
    private static GradleDslElement resolveReferenceInParentModules(@NotNull GradleDslFile dslFile, @NotNull List<String> referenceText) {
        if (dslFile == null) {
            GradleDslExpression.$$$reportNull$$$0(17);
        }
        if (referenceText == null) {
            GradleDslExpression.$$$reportNull$$$0(18);
        }
        for (GradleDslFile parentDslFile = dslFile.getParentModuleDslFile(); parentDslFile != null; parentDslFile = parentDslFile.getParentModuleDslFile()) {
            GradleDslElement extPropertyElement;
            ExtDslElement extDslElement = parentDslFile.getPropertyElement("ext", ExtDslElement.class);
            if (extDslElement != null && (extPropertyElement = GradleDslExpression.resolveReferenceOnPropertiesElement(extDslElement, referenceText)) != null) {
                return extPropertyElement;
            }
            if (parentDslFile.getParentModuleDslFile() == null) {
                return null;
            }
            GradleDslElement propertyElement = GradleDslExpression.resolveReferenceInPropertiesFile(parentDslFile, String.join((CharSequence)".", referenceText));
            if (propertyElement == null) continue;
            return propertyElement;
        }
        return null;
    }

    @Nullable
    private static GradleDslElement resolveReferenceInPropertiesFile(@NotNull GradleDslFile buildDslFile, @NotNull String referenceText) {
        GradleDslFile propertiesDslFile;
        if (buildDslFile == null) {
            GradleDslExpression.$$$reportNull$$$0(19);
        }
        if (referenceText == null) {
            GradleDslExpression.$$$reportNull$$$0(20);
        }
        return (propertiesDslFile = buildDslFile.getSiblingDslFile()) != null ? propertiesDslFile.getPropertyElement(referenceText) : null;
    }

    @Nullable
    private static GradleDslFile findDslFile(GradleDslFile rootModuleDslFile, File moduleDirectory) {
        if (FileUtil.filesEqual((File)rootModuleDslFile.getDirectoryPath(), (File)moduleDirectory)) {
            return rootModuleDslFile;
        }
        for (GradleDslFile dslFile : rootModuleDslFile.getChildModuleDslFiles()) {
            if (FileUtil.filesEqual((File)dslFile.getDirectoryPath(), (File)moduleDirectory)) {
                return dslFile;
            }
            GradleDslFile childDslFile = GradleDslExpression.findDslFile(dslFile, moduleDirectory);
            if (childDslFile == null) continue;
            return dslFile;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslExpression";
                break;
            }
            case 4: 
            case 5: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectReference";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameParts";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dslFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildDslFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslExpression";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedVariables";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "stripQuotes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setExpression";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveProjectReference";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "stripQuotes";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "extractElementFromProperties";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceOnPropertiesElement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceOnElement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceInSameModule";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceInParentModules";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceInPropertiesFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

