/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dependencies;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.google.common.base.Objects;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleDependencyManager {
    private static final String ADD_DEPENDENCY = "Add Dependency";

    @NotNull
    public static GradleDependencyManager getInstance(@NotNull Project project) {
        if (project == null) {
            GradleDependencyManager.$$$reportNull$$$0(0);
        }
        GradleDependencyManager gradleDependencyManager = (GradleDependencyManager)ServiceManager.getService((Project)project, GradleDependencyManager.class);
        if (gradleDependencyManager == null) {
            GradleDependencyManager.$$$reportNull$$$0(1);
        }
        return gradleDependencyManager;
    }

    @NotNull
    public List<GradleCoordinate> findMissingDependencies(@NotNull Module module, @NotNull Iterable<GradleCoordinate> dependencies) {
        if (module == null) {
            GradleDependencyManager.$$$reportNull$$$0(2);
        }
        if (dependencies == null) {
            GradleDependencyManager.$$$reportNull$$$0(3);
        }
        AndroidModuleModel gradleModel = AndroidModuleModel.get(module);
        GradleBuildModel buildModel = GradleBuildModel.get(module);
        if (gradleModel == null && buildModel == null) {
            List<GradleCoordinate> list = Collections.emptyList();
            if (list == null) {
                GradleDependencyManager.$$$reportNull$$$0(4);
            }
            return list;
        }
        String configurationName = GradleUtil.mapConfigurationName("compile", GradleUtil.getAndroidGradleModelVersionInUse(module), false);
        List<ArtifactDependencyModel> compileDependencies = buildModel != null ? buildModel.dependencies().artifacts(configurationName) : null;
        GradleVersion appCompatVersion = null;
        if (compileDependencies != null) {
            for (ArtifactDependencyModel dependency : compileDependencies) {
                if (!Objects.equal((Object)"com.android.support", dependency.group().value()) || Objects.equal((Object)"multidex", (Object)dependency.name().value())) continue;
                String s = (String)dependency.version().value();
                if (s == null) break;
                appCompatVersion = GradleVersion.tryParse((String)s);
                break;
            }
        }
        Project project = module.getProject();
        RepositoryUrlManager manager = RepositoryUrlManager.get();
        ArrayList<GradleCoordinate> missingLibraries = new ArrayList<GradleCoordinate>();
        for (GradleCoordinate coordinate : dependencies) {
            String groupId = coordinate.getGroupId();
            String artifactId = coordinate.getArtifactId();
            if (artifactId == null || groupId == null) continue;
            GradleCoordinate resolvedCoordinate = manager.resolveDynamicCoordinate(coordinate, project);
            if (appCompatVersion != null && coordinate.acceptsGreaterRevisions() && "com.android.support".equals(groupId) && !artifactId.equals("multidex")) {
                resolvedCoordinate = GradleCoordinate.parseCoordinateString((String)(groupId + ":" + artifactId + ":" + appCompatVersion.toString()));
            }
            if (resolvedCoordinate != null) {
                coordinate = resolvedCoordinate;
            }
            boolean dependencyFound = false;
            if (gradleModel != null && GradleUtil.dependsOn(gradleModel, String.format("%s:%s", groupId, artifactId))) {
                dependencyFound = true;
            } else if (compileDependencies != null) {
                for (ArtifactDependencyModel dependency : compileDependencies) {
                    if (!Objects.equal((Object)groupId, dependency.group().value()) || !Objects.equal((Object)artifactId, (Object)dependency.name().value())) continue;
                    dependencyFound = true;
                    break;
                }
            }
            if (dependencyFound) continue;
            missingLibraries.add(coordinate);
        }
        ArrayList<GradleCoordinate> arrayList = missingLibraries;
        if (arrayList == null) {
            GradleDependencyManager.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public boolean addDependenciesAndSync(@NotNull Module module, @NotNull Iterable<GradleCoordinate> dependencies, @Nullable Runnable callback) {
        if (module == null) {
            GradleDependencyManager.$$$reportNull$$$0(6);
        }
        if (dependencies == null) {
            GradleDependencyManager.$$$reportNull$$$0(7);
        }
        return this.addDependenciesInTransaction(module, dependencies, true, callback);
    }

    public boolean addDependenciesWithoutSync(@NotNull Module module, @NotNull Iterable<GradleCoordinate> dependencies) {
        if (module == null) {
            GradleDependencyManager.$$$reportNull$$$0(8);
        }
        if (dependencies == null) {
            GradleDependencyManager.$$$reportNull$$$0(9);
        }
        return this.addDependenciesInTransaction(module, dependencies, false, null);
    }

    public boolean updateLibrariesToVersion(@NotNull Module module, @NotNull List<GradleCoordinate> dependencies, @Nullable Runnable callback) {
        GradleBuildModel buildModel;
        if (module == null) {
            GradleDependencyManager.$$$reportNull$$$0(10);
        }
        if (dependencies == null) {
            GradleDependencyManager.$$$reportNull$$$0(11);
        }
        if ((buildModel = GradleBuildModel.get(module)) == null) {
            return false;
        }
        GradleDependencyManager.updateDependenciesInTransaction(buildModel, module, dependencies, callback);
        return true;
    }

    public boolean userWantToAddDependencies(@NotNull Module module, @NotNull Collection<GradleCoordinate> missing) {
        if (module == null) {
            GradleDependencyManager.$$$reportNull$$$0(12);
        }
        if (missing == null) {
            GradleDependencyManager.$$$reportNull$$$0(13);
        }
        String libraryNames2 = StringUtil.join(missing, GradleCoordinate::getArtifactId, (String)", ");
        String message = String.format("This operation requires the %1$s %2$s. \n\nWould you like to add %3$s %1$s now?", StringUtil.pluralize((String)"library", (int)missing.size()), libraryNames2, StringUtil.pluralize((String)"this", (int)missing.size()));
        Project project = module.getProject();
        return Messages.showOkCancelDialog((Project)project, (String)message, (String)"Add Project Dependency", (Icon)Messages.getErrorIcon()) == 0;
    }

    private boolean addDependenciesInTransaction(final @NotNull Module module, final @NotNull Iterable<GradleCoordinate> coordinates, final boolean performSync, final @Nullable Runnable callback) {
        if (module == null) {
            GradleDependencyManager.$$$reportNull$$$0(14);
        }
        if (coordinates == null) {
            GradleDependencyManager.$$$reportNull$$$0(15);
        }
        if (!performSync && callback != null) {
            throw new IllegalArgumentException("Callback must be null if sync is not requested.");
        }
        final GradleBuildModel buildModel = GradleBuildModel.get(module);
        if (buildModel == null) {
            return false;
        }
        final Project project = module.getProject();
        new WriteCommandAction(project, ADD_DEPENDENCY, new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                List<GradleCoordinate> missing;
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((missing = GradleDependencyManager.this.findMissingDependencies(module, coordinates)).isEmpty()) {
                    return;
                }
                GradleDependencyManager.addDependencies(buildModel, module, missing);
                if (performSync) {
                    GradleDependencyManager.requestProjectSync(project, callback);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager$1", "run"));
            }
        }.execute();
        return true;
    }

    private static void addDependencies(@NotNull GradleBuildModel buildModel, @NotNull Module module, @NotNull List<GradleCoordinate> coordinates) {
        if (buildModel == null) {
            GradleDependencyManager.$$$reportNull$$$0(16);
        }
        if (module == null) {
            GradleDependencyManager.$$$reportNull$$$0(17);
        }
        if (coordinates == null) {
            GradleDependencyManager.$$$reportNull$$$0(18);
        }
        ModuleRootModificationUtil.updateModel((Module)module, model -> {
            if (buildModel == null) {
                GradleDependencyManager.$$$reportNull$$$0(28);
            }
            if (coordinates == null) {
                GradleDependencyManager.$$$reportNull$$$0(29);
            }
            if (module == null) {
                GradleDependencyManager.$$$reportNull$$$0(30);
            }
            DependenciesModel dependenciesModel = buildModel.dependencies();
            for (GradleCoordinate coordinate : coordinates) {
                String name = GradleUtil.mapConfigurationName("compile", GradleUtil.getAndroidGradleModelVersionInUse(module), false);
                dependenciesModel.addArtifact(name, coordinate.toString());
            }
            buildModel.applyChanges();
        });
    }

    private static void updateDependenciesInTransaction(final @NotNull GradleBuildModel buildModel, final @NotNull Module module, final @NotNull List<GradleCoordinate> coordinates, final @Nullable Runnable callback) {
        if (buildModel == null) {
            GradleDependencyManager.$$$reportNull$$$0(19);
        }
        if (module == null) {
            GradleDependencyManager.$$$reportNull$$$0(20);
        }
        if (coordinates == null) {
            GradleDependencyManager.$$$reportNull$$$0(21);
        }
        assert (!coordinates.isEmpty());
        final Project project = module.getProject();
        new WriteCommandAction(project, ADD_DEPENDENCY, new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    2.$$$reportNull$$$0(0);
                }
                GradleDependencyManager.updateDependencies(buildModel, module, coordinates);
                GradleDependencyManager.requestProjectSync(project, callback);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager$2", "run"));
            }
        }.execute();
    }

    private static void requestProjectSync(@NotNull Project project, @Nullable Runnable callback) {
        if (project == null) {
            GradleDependencyManager.$$$reportNull$$$0(22);
        }
        if (callback != null) {
            GradleBuildInvoker.getInstance(project).add(new GradleCompletionTask(project, callback));
        }
        GradleSyncInvoker.Request request = GradleSyncInvoker.Request.projectModified();
        request.generateSourcesOnSuccess = true;
        GradleSyncInvoker.getInstance().requestProjectSync(project, request);
    }

    private static void updateDependencies(@NotNull GradleBuildModel buildModel, @NotNull Module module, @NotNull List<GradleCoordinate> coordinates) {
        if (buildModel == null) {
            GradleDependencyManager.$$$reportNull$$$0(23);
        }
        if (module == null) {
            GradleDependencyManager.$$$reportNull$$$0(24);
        }
        if (coordinates == null) {
            GradleDependencyManager.$$$reportNull$$$0(25);
        }
        ModuleRootModificationUtil.updateModel((Module)module, model -> {
            if (buildModel == null) {
                GradleDependencyManager.$$$reportNull$$$0(26);
            }
            if (coordinates == null) {
                GradleDependencyManager.$$$reportNull$$$0(27);
            }
            DependenciesModel dependenciesModel = buildModel.dependencies();
            for (GradleCoordinate gc : coordinates) {
                ArrayList<ArtifactDependencyModel> artifacts = new ArrayList<ArtifactDependencyModel>(dependenciesModel.artifacts());
                for (ArtifactDependencyModel m : artifacts) {
                    if (gc.getGroupId() == null || !gc.getGroupId().equals(m.group().value()) || gc.getArtifactId() == null || !gc.getArtifactId().equals(m.name().value()) || gc.getRevision().equals(m.version().value())) continue;
                    dependenciesModel.remove(m);
                    dependenciesModel.addArtifact(m.configurationName(), gc.toString());
                }
            }
            buildModel.applyChanges();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dependencies/GradleDependencyManager";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "missing";
                break;
            }
            case 15: 
            case 18: 
            case 21: 
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coordinates";
                break;
            }
            case 16: 
            case 19: 
            case 23: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dependencies/GradleDependencyManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findMissingDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findMissingDependencies";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addDependenciesAndSync";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addDependenciesWithoutSync";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateLibrariesToVersion";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "userWantToAddDependencies";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addDependenciesInTransaction";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addDependencies";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateDependenciesInTransaction";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "requestProjectSync";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "updateDependencies";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateDependencies$1";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addDependencies$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GradleCompletionTask
    implements GradleBuildInvoker.AfterGradleInvocationTask {
        private final Project myProject;
        private final Runnable myCallback;

        private GradleCompletionTask(@NotNull Project project, @NotNull Runnable callback) {
            if (project == null) {
                GradleCompletionTask.$$$reportNull$$$0(0);
            }
            if (callback == null) {
                GradleCompletionTask.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myCallback = callback;
        }

        @Override
        public void execute(@NotNull GradleInvocationResult result) {
            if (result == null) {
                GradleCompletionTask.$$$reportNull$$$0(2);
            }
            GradleBuildInvoker.getInstance(this.myProject).remove(this);
            this.myCallback.run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/dependencies/GradleDependencyManager$GradleCompletionTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

