/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.project.importing.GradleProjectImporter;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.google.common.collect.Lists;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CleanImportProjectAction
extends DumbAwareAction {
    private static final String MESSAGE_FORMAT = "This action will:\n1. Close project '%1$s'\n2. Delete all project files (.idea folder and .iml files)\n3. Import the project\n\nYou will lose custom project-wide settings. Are you sure you want to continue?";
    private static final String TITLE = "Close, Clean and Re-Import Project";
    private static final Logger LOG = Logger.getInstance(CleanImportProjectAction.class);

    public CleanImportProjectAction() {
        super(TITLE);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        String projectName;
        int answer;
        Project project;
        if (e == null) {
            CleanImportProjectAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) != null && CleanImportProjectAction.isGradleProjectIfNotNull(project) && (answer = Messages.showYesNoDialog((Project)project, (String)String.format(MESSAGE_FORMAT, projectName = project.getName()), (String)TITLE, null)) == 0) {
            LOG.info(String.format("Closing, cleaning and re-importing project '%1$s'...", projectName));
            List<File> filesToDelete = CleanImportProjectAction.collectFilesToDelete(project);
            File projectDirPath = Projects.getBaseDirPath((Project)project);
            CleanImportProjectAction.close(project);
            CleanImportProjectAction.deleteFiles(filesToDelete, projectName);
            try {
                LOG.info(String.format("About to import project '%1$s'.", projectName));
                GradleProjectImporter.getInstance().importProject(projectName, projectDirPath, null);
                LOG.info(String.format("Done importing project '%1$s'.", projectName));
            }
            catch (Exception error) {
                String title = CleanImportProjectAction.getErrorMessageTitle(error);
                Messages.showErrorDialog((String)error.getMessage(), (String)title);
                LOG.info(String.format("Failed to import project '%1$s'.", projectName));
            }
        }
    }

    @NotNull
    private static List<File> collectFilesToDelete(@NotNull Project project) {
        if (project == null) {
            CleanImportProjectAction.$$$reportNull$$$0(1);
        }
        ArrayList filesToDelete = Lists.newArrayList();
        String projectFilePath = project.getProjectFilePath();
        if (projectFilePath != null) {
            CleanImportProjectAction.addFileIfExists(filesToDelete, new File(PathUtil.getParentPath((String)projectFilePath)));
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            CleanImportProjectAction.addFileIfExists(filesToDelete, new File(module.getModuleFilePath()));
        }
        ArrayList arrayList = filesToDelete;
        if (arrayList == null) {
            CleanImportProjectAction.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static void addFileIfExists(@NotNull List<File> list, @NotNull File file) {
        if (list == null) {
            CleanImportProjectAction.$$$reportNull$$$0(3);
        }
        if (file == null) {
            CleanImportProjectAction.$$$reportNull$$$0(4);
        }
        if (file.exists()) {
            list.add(file);
        }
    }

    private static void close(@NotNull Project project) {
        if (project == null) {
            CleanImportProjectAction.$$$reportNull$$$0(5);
        }
        String projectName = project.getName();
        ProjectUtil.closeAndDispose((Project)project);
        RecentProjectsManager.getInstance().updateLastProjectPath();
        WelcomeFrame.showIfNoProjectOpened();
        LOG.info(String.format("Closed project '%1$s'.", projectName));
    }

    private static void deleteFiles(final @NotNull List<File> files, @NotNull String projectName) {
        if (files == null) {
            CleanImportProjectAction.$$$reportNull$$$0(6);
        }
        if (projectName == null) {
            CleanImportProjectAction.$$$reportNull$$$0(7);
        }
        Project project = ProjectManager.getInstance().getDefaultProject();
        String title = String.format("Cleaning up project '%1$s", projectName);
        ProgressManager.getInstance().run((Task)new Task.Modal(project, title, false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setFraction(0.0);
                int fileCount = files.size();
                for (int i = 0; i < fileCount; ++i) {
                    File file = (File)files.get(i);
                    String path = file.getPath();
                    LOG.info(String.format("About to delete file '%1$s'", path));
                    if (!FileUtil.delete((File)file)) {
                        LOG.info(String.format("Failed to delete file '%1$s'", path));
                    }
                    indicator.setFraction((double)i / (double)fileCount);
                }
                indicator.setFraction(1.0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/gradle/actions/CleanImportProjectAction$1", "run"));
            }
        });
    }

    @NotNull
    private static String getErrorMessageTitle(@NotNull Exception e) {
        if (e == null) {
            CleanImportProjectAction.$$$reportNull$$$0(8);
        }
        if (e instanceof ConfigurationException) {
            String string = ((ConfigurationException)((Object)e)).getTitle();
            if (string == null) {
                CleanImportProjectAction.$$$reportNull$$$0(9);
            }
            return string;
        }
        if (TITLE == null) {
            CleanImportProjectAction.$$$reportNull$$$0(10);
        }
        return TITLE;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CleanImportProjectAction.$$$reportNull$$$0(11);
        }
        boolean isGradleProject = CleanImportProjectAction.isGradleProjectIfNotNull(e.getProject());
        Presentation presentation = e.getPresentation();
        presentation.setVisible(isGradleProject);
        presentation.setEnabled(isGradleProject);
    }

    private static boolean isGradleProjectIfNotNull(@Nullable Project project) {
        return project != null && GradleProjects.isBuildWithGradle(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/actions/CleanImportProjectAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/actions/CleanImportProjectAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFilesToDelete";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessageTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectFilesToDelete";
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addFileIfExists";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "close";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deleteFiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessageTitle";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

