/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.actions.GoToApkLocationTask;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.gradle.run.OutputBuildAction;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BuildApkAction
extends DumbAwareAction {
    private static final String ACTION_TEXT = "Build APK(s)";

    public BuildApkAction() {
        super(ACTION_TEXT);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            BuildApkAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        e.getPresentation().setEnabledAndVisible(project != null && GradleProjectInfo.getInstance(project).isBuildWithGradle());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ImmutableList<Module> appModules;
        Project project;
        if (e == null) {
            BuildApkAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) != null && GradleProjectInfo.getInstance(project).isBuildWithGradle() && !(appModules = ProjectStructure.getInstance(project).getAppModules()).isEmpty()) {
            GradleBuildInvoker gradleBuildInvoker = GradleBuildInvoker.getInstance(project);
            gradleBuildInvoker.add(new GoToApkLocationTask((Collection<Module>)appModules, ACTION_TEXT));
            Module[] modulesToBuild = (Module[])appModules.toArray((Object[])new Module[appModules.size()]);
            gradleBuildInvoker.assemble(modulesToBuild, TestCompileType.ALL, Collections.emptyList(), new OutputBuildAction(BuildApkAction.getModuleGradlePaths(appModules)));
        }
    }

    @NotNull
    private static List<String> getModuleGradlePaths(@NotNull List<Module> modules) {
        if (modules == null) {
            BuildApkAction.$$$reportNull$$$0(2);
        }
        ArrayList<String> gradlePaths = new ArrayList<String>();
        for (Module module : modules) {
            String gradlePath = GradleUtil.getGradlePath(module);
            if (gradlePath == null) continue;
            gradlePaths.add(gradlePath);
        }
        ArrayList<String> arrayList = gradlePaths;
        if (arrayList == null) {
            BuildApkAction.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/actions/BuildApkAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/actions/BuildApkAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleGradlePaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModuleGradlePaths";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

