/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.level2.Library;
import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.model.ClassJarProvider;
import com.android.utils.ImmutableCollectors;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidGradleClassJarProvider
extends ClassJarProvider {
    @Override
    @Nullable
    public VirtualFile findModuleClassFile(@NotNull String className, @NotNull Module module) {
        AndroidModuleModel model;
        if (className == null) {
            AndroidGradleClassJarProvider.$$$reportNull$$$0(0);
        }
        if (module == null) {
            AndroidGradleClassJarProvider.$$$reportNull$$$0(1);
        }
        if ((model = AndroidModuleModel.get(module)) == null) {
            return null;
        }
        for (VirtualFile outputDir : AndroidGradleClassJarProvider.getCompilerOutputRoots(model)) {
            VirtualFile file = ClassJarProvider.findClassFileInPath(outputDir, className);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    @NotNull
    private static Collection<VirtualFile> getCompilerOutputRoots(@NotNull AndroidModuleModel model) {
        File outFolder;
        File file;
        if (model == null) {
            AndroidGradleClassJarProvider.$$$reportNull$$$0(2);
        }
        IdeVariant variant = model.getSelectedVariant();
        String variantName = variant.getName();
        IdeAndroidArtifact mainArtifactInfo = model.getMainArtifact();
        File classesFolder = mainArtifactInfo.getClassesFolder();
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        if (classesFolder == null) {
            AndroidArtifactOutput output = GradleUtil.getOutput((AndroidArtifact)mainArtifactInfo);
            file = output.getMainOutputFile().getOutputFile();
            File buildFolder = file.getParentFile().getParentFile();
            classesFolder = new File(buildFolder, "classes");
        }
        if ((outFolder = new File(classesFolder, variantName.replace('-', File.separatorChar))).exists() && (file = VfsUtil.findFileByIoFile((File)outFolder, (boolean)true)) != null) {
            listBuilder.add((Object)file);
        }
        for (File additionalFolder : mainArtifactInfo.getAdditionalClassesFolders()) {
            VirtualFile file2 = VfsUtil.findFileByIoFile((File)additionalFolder, (boolean)true);
            if (file2 == null) continue;
            listBuilder.add((Object)file2);
        }
        ImmutableList immutableList = listBuilder.build();
        if (immutableList == null) {
            AndroidGradleClassJarProvider.$$$reportNull$$$0(3);
        }
        return immutableList;
    }

    @Override
    @NotNull
    public List<File> getModuleExternalLibraries(@NotNull Module module) {
        AndroidModuleModel model;
        if (module == null) {
            AndroidGradleClassJarProvider.$$$reportNull$$$0(4);
        }
        if ((model = AndroidModuleModel.get(module)) == null) {
            List list = Lists.transform(AndroidRootUtil.getExternalLibraries(module), VfsUtilCore::virtualToIoFile);
            if (list == null) {
                AndroidGradleClassJarProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        List list = (List)Stream.concat(model.getSelectedMainCompileLevel2Dependencies().getAndroidLibraries().stream().flatMap(library -> Stream.concat(Stream.of(library.getJarFile()), library.getLocalJars().stream())).map(jar -> new File((String)jar)), model.getSelectedMainCompileLevel2Dependencies().getJavaLibraries().stream().map(Library::getArtifact)).collect(ImmutableCollectors.toImmutableList());
        if (list == null) {
            AndroidGradleClassJarProvider.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/AndroidGradleClassJarProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/AndroidGradleClassJarProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerOutputRoots";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleExternalLibraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findModuleClassFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerOutputRoots";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getModuleExternalLibraries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

