/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.adbimpl;

import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileSystem;
import com.android.tools.idea.explorer.adbimpl.AdbFileListingEntry;
import com.android.tools.idea.explorer.fs.DeviceFileEntry;
import com.android.tools.idea.explorer.fs.DeviceFileSystem;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AdbDeviceFileEntry
implements DeviceFileEntry {
    public static final String SYMBOLIC_LINK_INFO_PREFIX = "-> ";
    @NotNull
    protected final AdbDeviceFileSystem myDevice;
    @NotNull
    protected final AdbFileListingEntry myEntry;
    @Nullable
    protected final AdbDeviceFileEntry myParent;

    public AdbDeviceFileEntry(@NotNull AdbDeviceFileSystem device, @NotNull AdbFileListingEntry entry, @Nullable AdbDeviceFileEntry parent) {
        if (device == null) {
            AdbDeviceFileEntry.$$$reportNull$$$0(0);
        }
        if (entry == null) {
            AdbDeviceFileEntry.$$$reportNull$$$0(1);
        }
        this.myDevice = device;
        this.myEntry = entry;
        this.myParent = parent;
    }

    public String toString() {
        return this.myEntry.toString();
    }

    @Override
    @NotNull
    public DeviceFileSystem getFileSystem() {
        AdbDeviceFileSystem adbDeviceFileSystem = this.myDevice;
        if (adbDeviceFileSystem == null) {
            AdbDeviceFileEntry.$$$reportNull$$$0(2);
        }
        return adbDeviceFileSystem;
    }

    @Override
    @Nullable
    public AdbDeviceFileEntry getParent() {
        return this.myParent;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myEntry.getName();
        if (string == null) {
            AdbDeviceFileEntry.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFullPath() {
        String string = this.myEntry.getFullPath();
        if (string == null) {
            AdbDeviceFileEntry.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public DeviceFileEntry.Permissions getPermissions() {
        AdbPermissions adbPermissions = new AdbPermissions(this.myEntry.getPermissions());
        if (adbPermissions == null) {
            AdbDeviceFileEntry.$$$reportNull$$$0(5);
        }
        return adbPermissions;
    }

    @Override
    @NotNull
    public DeviceFileEntry.DateTime getLastModifiedDate() {
        AdbDateTime adbDateTime = new AdbDateTime(this.myEntry.getDate(), this.myEntry.getTime());
        if (adbDateTime == null) {
            AdbDeviceFileEntry.$$$reportNull$$$0(6);
        }
        return adbDateTime;
    }

    @Override
    public long getSize() {
        return this.myEntry.getSize();
    }

    @Override
    public boolean isDirectory() {
        return this.myEntry.isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.myEntry.isFile();
    }

    @Override
    public boolean isSymbolicLink() {
        return this.myEntry.isSymbolicLink();
    }

    @Override
    @Nullable
    public String getSymbolicLinkTarget() {
        if (!this.isSymbolicLink()) {
            return null;
        }
        String info = this.myEntry.getInfo();
        if (StringUtil.isEmpty((String)info) || !info.startsWith(SYMBOLIC_LINK_INFO_PREFIX)) {
            return null;
        }
        return info.substring(SYMBOLIC_LINK_INFO_PREFIX.length());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/explorer/adbimpl/AdbDeviceFileEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/explorer/adbimpl/AdbDeviceFileEntry";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPermissions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastModifiedDate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class AdbDateTime
    implements DeviceFileEntry.DateTime {
        private final String myDate;
        private final String myTime;

        public AdbDateTime(String date, String time2) {
            this.myDate = date;
            this.myTime = time2;
        }

        @Override
        @NotNull
        public String getText() {
            if (StringUtil.isEmpty((String)this.myDate)) {
                if ("" == null) {
                    AdbDateTime.$$$reportNull$$$0(0);
                }
                return "";
            }
            if (StringUtil.isEmpty((String)this.myTime)) {
                String string = this.myDate;
                if (string == null) {
                    AdbDateTime.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = this.myDate + " " + this.myTime;
            if (string == null) {
                AdbDateTime.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/explorer/adbimpl/AdbDeviceFileEntry$AdbDateTime", "getText"));
        }
    }

    public static class AdbPermissions
    implements DeviceFileEntry.Permissions {
        private final String myValue;

        public AdbPermissions(String value) {
            this.myValue = value;
        }

        @Override
        @NotNull
        public String getText() {
            String string = StringUtil.notNullize((String)this.myValue);
            if (string == null) {
                AdbPermissions.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/explorer/adbimpl/AdbDeviceFileEntry$AdbPermissions", "getText"));
        }
    }
}

