/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer;

import com.android.tools.idea.explorer.DeviceExplorerModelListener;
import com.android.tools.idea.explorer.fs.DeviceFileSystem;
import com.android.tools.idea.explorer.fs.DeviceState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceExplorerModel {
    @NotNull
    private final List<DeviceExplorerModelListener> myListeners = new ArrayList<DeviceExplorerModelListener>();
    @NotNull
    private final List<DeviceFileSystem> myDevices = new ArrayList<DeviceFileSystem>();
    @Nullable
    private DeviceFileSystem myActiveDevice;
    @Nullable
    private DeviceState myActiveDeviceLastKnownState;
    @Nullable
    private DefaultTreeModel myTreeModel;
    @Nullable
    private DefaultTreeSelectionModel myTreeSelectionModel;

    @NotNull
    public List<DeviceFileSystem> getDevices() {
        List<DeviceFileSystem> list = this.myDevices;
        if (list == null) {
            DeviceExplorerModel.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    public DeviceFileSystem getActiveDevice() {
        return this.myActiveDevice;
    }

    public void setActiveDevice(@Nullable DeviceFileSystem activeDevice) {
        this.myActiveDevice = activeDevice;
        this.myActiveDeviceLastKnownState = activeDevice == null ? null : activeDevice.getDeviceState();
        this.myListeners.forEach(x -> x.activeDeviceChanged(this.myActiveDevice));
        this.setActiveDeviceTreeModel(activeDevice, null, null);
    }

    @Nullable
    public DeviceState getActiveDeviceLastKnownState(@NotNull DeviceFileSystem device) {
        if (device == null) {
            DeviceExplorerModel.$$$reportNull$$$0(1);
        }
        if (!Objects.equals(device, this.myActiveDevice)) {
            return null;
        }
        return this.myActiveDeviceLastKnownState;
    }

    public void setActiveDeviceLastKnownState(@NotNull DeviceFileSystem device) {
        if (device == null) {
            DeviceExplorerModel.$$$reportNull$$$0(2);
        }
        if (!Objects.equals(device, this.myActiveDevice)) {
            return;
        }
        this.myActiveDeviceLastKnownState = device.getDeviceState();
    }

    @Nullable
    public DefaultTreeModel getTreeModel() {
        return this.myTreeModel;
    }

    @Nullable
    public DefaultTreeSelectionModel getTreeSelectionModel() {
        return this.myTreeSelectionModel;
    }

    public void addListener(@NotNull DeviceExplorerModelListener listener) {
        if (listener == null) {
            DeviceExplorerModel.$$$reportNull$$$0(3);
        }
        this.myListeners.add(listener);
    }

    public void removeListener(@NotNull DeviceExplorerModelListener listener) {
        if (listener == null) {
            DeviceExplorerModel.$$$reportNull$$$0(4);
        }
        this.myListeners.remove(listener);
    }

    public void setActiveDeviceTreeModel(@Nullable DeviceFileSystem device, @Nullable DefaultTreeModel treeModel, @Nullable DefaultTreeSelectionModel treeSelectionModel) {
        if (!Objects.equals(this.myActiveDevice, device)) {
            return;
        }
        if (Objects.equals(this.myTreeModel, treeModel)) {
            return;
        }
        this.myTreeModel = treeModel;
        this.myTreeSelectionModel = treeSelectionModel;
        this.myListeners.forEach(x -> x.treeModelChanged(treeModel, treeSelectionModel));
    }

    public void addDevice(@NotNull DeviceFileSystem device) {
        if (device == null) {
            DeviceExplorerModel.$$$reportNull$$$0(5);
        }
        if (this.myDevices.contains(device)) {
            return;
        }
        this.myDevices.add(device);
        this.myListeners.forEach(l -> {
            if (device == null) {
                DeviceExplorerModel.$$$reportNull$$$0(10);
            }
            l.deviceAdded(device);
        });
    }

    public void removeDevice(@NotNull DeviceFileSystem device) {
        if (device == null) {
            DeviceExplorerModel.$$$reportNull$$$0(6);
        }
        if (!this.myDevices.contains(device)) {
            return;
        }
        this.myListeners.forEach(l -> {
            if (device == null) {
                DeviceExplorerModel.$$$reportNull$$$0(9);
            }
            l.deviceRemoved(device);
        });
        this.myDevices.remove(device);
    }

    public void removeAllDevices() {
        this.myDevices.clear();
        this.setActiveDevice(null);
        this.setActiveDeviceTreeModel(null, null, null);
        this.myListeners.forEach(DeviceExplorerModelListener::allDevicesRemoved);
    }

    public void updateDevice(@NotNull DeviceFileSystem device) {
        if (device == null) {
            DeviceExplorerModel.$$$reportNull$$$0(7);
        }
        if (!this.myDevices.contains(device)) {
            return;
        }
        this.myListeners.forEach(l -> {
            if (device == null) {
                DeviceExplorerModel.$$$reportNull$$$0(8);
            }
            l.deviceUpdated(device);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/explorer/DeviceExplorerModel";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevices";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/explorer/DeviceExplorerModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getActiveDeviceLastKnownState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setActiveDeviceLastKnownState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addDevice";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeDevice";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateDevice";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateDevice$4";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$removeDevice$3";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addDevice$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

