/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof;

import com.android.tools.idea.actions.BrowserHelpAction;
import com.android.tools.idea.editors.hprof.HprofEditor;
import com.android.tools.idea.editors.hprof.views.ClassesTreeView;
import com.android.tools.idea.editors.hprof.views.GoToInstanceListener;
import com.android.tools.idea.editors.hprof.views.InstanceReferenceTreeView;
import com.android.tools.idea.editors.hprof.views.InstancesTreeView;
import com.android.tools.idea.editors.hprof.views.SelectionModel;
import com.android.tools.perflib.heap.ArrayInstance;
import com.android.tools.perflib.heap.ClassInstance;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.Snapshot;
import com.intellij.designer.LightFillLayout;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HprofView
implements Disposable {
    public static final String TOOLBAR_NAME = "HprofActionToolbar";
    private static final int DIVIDER_WIDTH = 4;
    @NotNull
    private JPanel myContainer;
    private Snapshot mySnapshot;
    @NotNull
    private SelectionModel mySelectionModel;

    public HprofView(@NotNull Project project, @NotNull HprofEditor editor, @NotNull Snapshot snapshot) {
        if (project == null) {
            HprofView.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            HprofView.$$$reportNull$$$0(1);
        }
        if (snapshot == null) {
            HprofView.$$$reportNull$$$0(2);
        }
        JBPanel treePanel = new JBPanel((LayoutManager)new BorderLayout());
        treePanel.setBackground(JBColor.background());
        this.mySnapshot = snapshot;
        assert (!this.mySnapshot.getHeaps().isEmpty());
        Heap currentHeap = null;
        for (Heap heap : this.mySnapshot.getHeaps()) {
            if ("app".equals(heap.getName())) {
                currentHeap = heap;
                break;
            }
            if (currentHeap != null) continue;
            currentHeap = heap;
        }
        if (currentHeap == null) {
            editor.setInvalid();
            throw new IllegalStateException("Invalid heap given to HprofViewPanel.");
        }
        this.mySelectionModel = new SelectionModel(currentHeap);
        Disposer.register((Disposable)this, (Disposable)this.mySelectionModel);
        DefaultActionGroup group = new DefaultActionGroup(new AnAction[]{new ComboBoxAction(){

            @NotNull
            protected DefaultActionGroup createPopupActionGroup(JComponent button) {
                DefaultActionGroup group = new DefaultActionGroup();
                assert (HprofView.this.mySnapshot != null);
                for (final Heap heap : HprofView.this.mySnapshot.getHeaps()) {
                    if ("default".equals(heap.getName()) && heap.getClasses().isEmpty() && heap.getInstancesCount() == 0) continue;
                    group.add(new AnAction(StringUtil.capitalize((String)(heap.getName() + " heap"))){

                        public void actionPerformed(@NotNull AnActionEvent e) {
                            if (e == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            HprofView.this.mySelectionModel.setHeap(heap);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/editors/hprof/HprofView$1$1", "actionPerformed"));
                        }
                    });
                }
                DefaultActionGroup defaultActionGroup = group;
                if (defaultActionGroup == null) {
                    1.$$$reportNull$$$0(0);
                }
                return defaultActionGroup;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.update(e);
                if (HprofView.this.mySnapshot != null) {
                    this.getTemplatePresentation().setText(StringUtil.capitalize((String)(HprofView.this.mySelectionModel.getHeap().getName() + " heap")));
                    e.getPresentation().setText(StringUtil.capitalize((String)(HprofView.this.mySelectionModel.getHeap().getName() + " heap")));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/idea/editors/hprof/HprofView$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createPopupActionGroup";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/idea/editors/hprof/HprofView$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }});
        InstanceReferenceTreeView referenceTree = new InstanceReferenceTreeView(project, this.mySelectionModel);
        treePanel.add((Component)referenceTree.getComponent(), (Object)"Center");
        final InstancesTreeView instancesTreeView = new InstancesTreeView(project, this.mySelectionModel);
        Disposer.register((Disposable)this, (Disposable)instancesTreeView);
        final ClassesTreeView classesTreeView = new ClassesTreeView(project, group, this.mySelectionModel);
        JBSplitter splitter = HprofView.createNavigationSplitter(classesTreeView.getComponent(), instancesTreeView.getComponent());
        Disposer.register((Disposable)this, (Disposable)classesTreeView);
        GoToInstanceListener goToInstanceListener = new GoToInstanceListener(){

            @Override
            public void goToInstance(@NotNull Instance instance) {
                if (instance == null) {
                    2.$$$reportNull$$$0(0);
                }
                ClassObj classObj = instance instanceof ClassObj ? (ClassObj)instance : instance.getClassObj();
                HprofView.this.mySelectionModel.setHeap(instance.getHeap());
                HprofView.this.mySelectionModel.setClassObj(classObj);
                classesTreeView.requestFocus();
                if (instance instanceof ClassInstance || instance instanceof ArrayInstance) {
                    HprofView.this.mySelectionModel.setInstance(instance);
                    instancesTreeView.requestFocus();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/android/tools/idea/editors/hprof/HprofView$2", "goToInstance"));
            }
        };
        referenceTree.addGoToInstanceListener(goToInstanceListener);
        instancesTreeView.addGoToInstanceListener(goToInstanceListener);
        JBPanel classPanel = new JBPanel((LayoutManager)new BorderLayout());
        classPanel.add((Component)splitter, (Object)"Center");
        JBSplitter mainSplitter = new JBSplitter(true);
        mainSplitter.setFirstComponent((JComponent)classPanel);
        mainSplitter.setSecondComponent((JComponent)treePanel);
        mainSplitter.setDividerWidth(4);
        this.myContainer = new JPanel((LayoutManager)new LightFillLayout());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("AndroidHprofView", (ActionGroup)group, true);
        toolbar.getComponent().setName(TOOLBAR_NAME);
        this.myContainer.add((Component)toolbar.getComponent(), "North");
        this.myContainer.add((Component)mainSplitter);
        group.add((AnAction)new Separator());
        group.add((AnAction)new BrowserHelpAction("Hprof Viewer", "http://developer.android.com/r/studio-ui/am-hprof.html"));
    }

    @NotNull
    public static JBSplitter createNavigationSplitter(@Nullable JComponent leftPanelContents, @Nullable JComponent rightPanelContents) {
        JBPanel navigationPanel = new JBPanel((LayoutManager)new BorderLayout());
        navigationPanel.setBackground(JBColor.background());
        if (leftPanelContents != null) {
            navigationPanel.add((Component)leftPanelContents, (Object)"Center");
        }
        JBPanel contextInformationPanel = new JBPanel((LayoutManager)new BorderLayout());
        contextInformationPanel.setBackground(JBColor.background());
        if (rightPanelContents != null) {
            contextInformationPanel.add((Component)rightPanelContents, (Object)"Center");
        }
        JBSplitter navigationSplitter = new JBSplitter(false);
        navigationSplitter.setFirstComponent((JComponent)navigationPanel);
        navigationSplitter.setSecondComponent((JComponent)contextInformationPanel);
        navigationSplitter.setDividerWidth(4);
        JBSplitter jBSplitter = navigationSplitter;
        if (jBSplitter == null) {
            HprofView.$$$reportNull$$$0(3);
        }
        return jBSplitter;
    }

    @NotNull
    public JPanel getComponent() {
        JPanel jPanel = this.myContainer;
        if (jPanel == null) {
            HprofView.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        SelectionModel selectionModel = this.mySelectionModel;
        if (selectionModel == null) {
            HprofView.$$$reportNull$$$0(5);
        }
        return selectionModel;
    }

    public void dispose() {
        this.myContainer.removeAll();
        this.mySnapshot = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshot";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/hprof/HprofView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/hprof/HprofView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createNavigationSplitter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

