/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.screenshot;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.RawImage;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.ExceptionUtil;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenshotTask
extends Task.Modal {
    private final IDevice myDevice;
    private String myError;
    private BufferedImage myImage;

    public ScreenshotTask(@NotNull Project project, @NotNull IDevice device) {
        if (project == null) {
            ScreenshotTask.$$$reportNull$$$0(0);
        }
        if (device == null) {
            ScreenshotTask.$$$reportNull$$$0(1);
        }
        super(project, AndroidBundle.message("android.ddms.actions.screenshot", new Object[0]), true);
        this.myDevice = device;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        RawImage rawImage;
        if (indicator == null) {
            ScreenshotTask.$$$reportNull$$$0(2);
        }
        indicator.setIndeterminate(true);
        indicator.setText(AndroidBundle.message("android.ddms.screenshot.task.step.obtain", new Object[0]));
        ScreenshotRetrieverTask retrieverTask = new ScreenshotRetrieverTask(this.myDevice);
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)retrieverTask);
        Future<RawImage> image = retrieverTask.getRawImage();
        while (true) {
            try {
                rawImage = image.get(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                this.myError = AndroidBundle.message("android.ddms.screenshot.task.error1", ExceptionUtil.getMessage((Throwable)e));
                return;
            }
            catch (ExecutionException e) {
                this.myError = AndroidBundle.message("android.ddms.screenshot.task.error1", ExceptionUtil.getMessage((Throwable)e));
                return;
            }
            catch (TimeoutException e) {
                if (!indicator.isCanceled()) continue;
                return;
            }
            break;
        }
        if (rawImage.bpp != 16 && rawImage.bpp != 32) {
            this.myError = AndroidBundle.message("android.ddms.screenshot.task.error.invalid.bpp", rawImage.bpp);
            return;
        }
        indicator.setText(AndroidBundle.message("android.ddms.screenshot.task.step.load", new Object[0]));
        this.myImage = this.createImage(rawImage);
        for (int y = 0; y < rawImage.height; ++y) {
            for (int x = 0; x < rawImage.width; ++x) {
                int argb = rawImage.getARGB((x + y * rawImage.width) * (rawImage.bpp / 8));
                this.myImage.setRGB(x, y, argb);
            }
        }
    }

    @NotNull
    private BufferedImage createImage(RawImage rawImage) {
        String profileName = ScreenshotTask.getProfileName(rawImage);
        if (profileName == null) {
            BufferedImage bufferedImage = new BufferedImage(rawImage.width, rawImage.height, 2);
            if (bufferedImage == null) {
                ScreenshotTask.$$$reportNull$$$0(3);
            }
            return bufferedImage;
        }
        ICC_Profile profile = ICC_Profile.getInstance(1000);
        try {
            profile = ICC_Profile.getInstance(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("colorProfiles/" + profileName));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ICC_ColorSpace colorSpace = new ICC_ColorSpace(profile);
        DirectColorModel colorModel = new DirectColorModel(colorSpace, 32, 0xFF0000, 65280, 255, -16777216, false, 3);
        WritableRaster raster = ((ColorModel)colorModel).createCompatibleWritableRaster(rawImage.width, rawImage.height);
        BufferedImage bufferedImage = new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), null);
        if (bufferedImage == null) {
            ScreenshotTask.$$$reportNull$$$0(4);
        }
        return bufferedImage;
    }

    @Nullable
    private static String getProfileName(RawImage image) {
        switch (image.colorSpace) {
            case 0: {
                return null;
            }
            case 1: {
                return "sRGB.icc";
            }
            case 2: {
                return "DisplayP3.icc";
            }
        }
        return null;
    }

    public BufferedImage getScreenshot() {
        return this.myImage;
    }

    public String getError() {
        return this.myError;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ddms/screenshot/ScreenshotTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ddms/screenshot/ScreenshotTask";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createImage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ScreenshotRetrieverTask
    implements Runnable {
        private final IDevice myDevice;
        private final SettableFuture<RawImage> myFuture;

        ScreenshotRetrieverTask(@NotNull IDevice device) {
            if (device == null) {
                ScreenshotRetrieverTask.$$$reportNull$$$0(0);
            }
            this.myDevice = device;
            this.myFuture = SettableFuture.create();
        }

        @Override
        public void run() {
            try {
                RawImage image = this.myDevice.getScreenshot(10L, TimeUnit.SECONDS);
                this.myFuture.set((Object)image);
            }
            catch (Throwable t) {
                this.myFuture.setException(t);
            }
        }

        public Future<RawImage> getRawImage() {
            return this.myFuture;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/ddms/screenshot/ScreenshotTask$ScreenshotRetrieverTask", "<init>"));
        }
    }
}

