/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.configurations.ThemeSelectionDialog;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import icons.StudioIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeMenuAction
extends DropDownAction {
    private final ConfigurationHolder myRenderContext;

    public ThemeMenuAction(@NotNull ConfigurationHolder renderContext) {
        if (renderContext == null) {
            ThemeMenuAction.$$$reportNull$$$0(0);
        }
        super("", "Theme in Editor", StudioIcons.LayoutEditor.Toolbar.THEME_BUTTON);
        this.myRenderContext = renderContext;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ThemeMenuAction.$$$reportNull$$$0(1);
        }
        super.update(e);
        this.updatePresentation(e.getPresentation());
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    private void updatePresentation(Presentation presentation) {
        boolean visible;
        Configuration configuration = this.myRenderContext.getConfiguration();
        boolean bl = visible = configuration != null;
        if (visible) {
            String brief = ThemeMenuAction.getThemeLabel(configuration.getTheme(), true);
            this.getTemplatePresentation().setText(brief, false);
            presentation.setText(brief, false);
        }
        if (visible != presentation.isVisible()) {
            presentation.setVisible(visible);
        }
    }

    @NotNull
    public static String getThemeLabel(@Nullable String theme, boolean brief) {
        int index;
        if (theme == null) {
            if ("" == null) {
                ThemeMenuAction.$$$reportNull$$$0(2);
            }
            return "";
        }
        theme = ResourceHelper.styleToTheme(theme);
        if (brief && (index = theme.lastIndexOf(46)) < theme.length() - 1) {
            String string = theme.substring(index + 1);
            if (string == null) {
                ThemeMenuAction.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = theme;
        if (string == null) {
            ThemeMenuAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        String theme;
        ThemeSelectionDialog dialog;
        Configuration configuration;
        if (e == null) {
            ThemeMenuAction.$$$reportNull$$$0(5);
        }
        if ((configuration = this.myRenderContext.getConfiguration()) != null && (dialog = new ThemeSelectionDialog(configuration)).showAndGet() && (theme = dialog.getTheme()) != null) {
            configuration.setTheme(theme);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderContext";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/configurations/ThemeMenuAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/configurations/ThemeMenuAction";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getThemeLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

