/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import com.android.tools.idea.uibuilder.graphics.NlIcon;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ColorSet;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.Icon;

public class DrawAction
extends DrawRegion {
    private final NlIcon myIcon;
    private boolean myIsOver;
    private int mySrcX;
    private int mySrcY;
    private int mySrcWidth;
    private int mySrcHeight;
    int myMode;
    protected Font mFont = new Font("Helvetica", 0, 14);

    @Override
    public int getLevel() {
        return 1010;
    }

    public DrawAction(int x, int y, int width, int height, int src_x, int src_y, int src_width, int src_height, NlIcon icon, boolean isOver) {
        super(x, y, width, height);
        this.myIcon = icon;
        this.myIsOver = isOver;
        this.mySrcX = src_x;
        this.mySrcY = src_y;
        this.mySrcWidth = src_width;
        this.mySrcHeight = src_height;
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        int r = (int)((double)this.width * 0.3);
        float distance = DrawAction.distance(sceneContext.getMouseX(), sceneContext.getMouseY(), this.mySrcX, this.mySrcY, this.mySrcWidth, this.y + this.height - this.mySrcY);
        if (distance > 20.0f) {
            return;
        }
        ColorSet colorSet = sceneContext.getColorSet();
        g.setColor(colorSet.getComponentObligatoryBackground());
        g.fillRoundRect(this.x - 2, this.y - 2, this.width + 4, this.height + 4, r, r);
        if (this.myIsOver) {
            g.setColor(colorSet.getSelectedBackground());
            g.fillRoundRect(this.x, this.y, this.width, this.height, r, r);
            g.setColor(colorSet.getFrames());
            g.drawRoundRect(this.x, this.y, this.width, this.height, r, r);
        } else {
            g.setColor(colorSet.getFrames());
            g.fillRoundRect(this.x, this.y, this.width, this.height, r, r);
        }
        Color color = colorSet.getText();
        g.setColor(color);
        Icon icon = this.myIcon.getSelectedIcon(sceneContext);
        g.setFont(this.mFont);
        FontMetrics fontMetrics = g.getFontMetrics();
        int iw = icon.getIconWidth();
        int ih = icon.getIconHeight();
        if (iw > this.width || ih > this.height) {
            double scale = Math.min((double)this.width / (double)iw, (double)this.height / (double)ih);
            Graphics2D g2 = (Graphics2D)g.create();
            double tx = (double)this.x + ((double)this.width - (double)iw * scale) / 2.0;
            double ty = (double)this.y + ((double)this.height - (double)ih * scale) / 2.0;
            g2.translate(tx, ty);
            g2.scale(scale, scale);
            icon.paintIcon(null, g2, 0, 0);
        } else {
            int tx = this.x + (this.width - iw) / 2;
            int ty = this.y + (this.height - ih) / 2;
            icon.paintIcon(null, g, tx, ty);
        }
    }

    @Override
    public String serialize() {
        return super.serialize() + "," + this.myMode;
    }

    public static void add(DisplayList list, SceneContext transform2, float left, float top, float right, float bottom, Rectangle src, NlIcon icon, boolean isOver) {
        int l = transform2.getSwingXDip(left);
        int t = transform2.getSwingYDip(top);
        int w = transform2.getSwingDimensionDip(right - left);
        int h = transform2.getSwingDimensionDip(bottom - top);
        src.x = transform2.getSwingXDip(src.x);
        src.y = transform2.getSwingYDip(src.y);
        src.width = transform2.getSwingDimensionDip(src.width);
        src.height = transform2.getSwingDimensionDip(src.height);
        list.add(new DrawAction(l, t, w, h, src.x, src.y, src.width, src.height, icon, isOver));
    }
}

