/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.analytics;

import com.android.sdklib.devices.State;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.common.analytics.NlUsageTracker;
import com.android.tools.idea.common.analytics.NopTracker;
import com.android.tools.idea.common.analytics.UsageTrackerUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderErrorModelFactory;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.android.tools.idea.uibuilder.property.NlPropertiesPanel;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LayoutAttributeChangeEvent;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.google.wireless.android.sdk.stats.LayoutEditorRenderResult;
import com.google.wireless.android.sdk.stats.LayoutEditorState;
import com.google.wireless.android.sdk.stats.LayoutFavoriteAttributeChangeEvent;
import com.google.wireless.android.sdk.stats.LayoutPaletteEvent;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.UIUtil;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlUsageTrackerManager
implements NlUsageTracker {
    static final NlUsageTracker NOP_TRACKER = new NopTracker();
    private static final int LOG_RENDER_PERCENT = 10;
    private static final Cache<DesignSurface, NlUsageTracker> sTrackersCache = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private static final Executor ourExecutorService = new ThreadPoolExecutor(0, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(10));
    private static final Random sRandom = new Random();
    private final Executor myExecutor;
    private final WeakReference<DesignSurface> myDesignSurfaceRef;
    private final UsageTracker myUsageTracker;

    NlUsageTrackerManager(@NotNull Executor executor, @Nullable DesignSurface surface, @NotNull UsageTracker usageTracker) {
        if (executor == null) {
            NlUsageTrackerManager.$$$reportNull$$$0(0);
        }
        if (usageTracker == null) {
            NlUsageTrackerManager.$$$reportNull$$$0(1);
        }
        this.myExecutor = executor;
        this.myDesignSurfaceRef = new WeakReference<DesignSurface>(surface);
        this.myUsageTracker = usageTracker;
    }

    @NotNull
    static NlUsageTracker getInstanceInner(@Nullable DesignSurface surface) {
        NlUsageTracker nlUsageTracker;
        if (surface == null) {
            NlUsageTracker nlUsageTracker2 = NOP_TRACKER;
            if (nlUsageTracker2 == null) {
                NlUsageTrackerManager.$$$reportNull$$$0(2);
            }
            return nlUsageTracker2;
        }
        try {
            nlUsageTracker = (NlUsageTracker)sTrackersCache.get((Object)surface, () -> new NlUsageTrackerManager(ourExecutorService, surface, UsageTracker.getInstance()));
        }
        catch (ExecutionException e) {
            assert (false);
            NlUsageTracker nlUsageTracker3 = NOP_TRACKER;
            if (nlUsageTracker3 == null) {
                NlUsageTrackerManager.$$$reportNull$$$0(4);
            }
            return nlUsageTracker3;
        }
        if (nlUsageTracker == null) {
            NlUsageTrackerManager.$$$reportNull$$$0(3);
        }
        return nlUsageTracker;
    }

    @NotNull
    public static NlUsageTracker getInstance(@Nullable DesignSurface surface) {
        NlUsageTracker nlUsageTracker = UsageTracker.getInstance().getAnalyticsSettings().hasOptedIn() ? NlUsageTrackerManager.getInstanceInner(surface) : NOP_TRACKER;
        if (nlUsageTracker == null) {
            NlUsageTrackerManager.$$$reportNull$$$0(5);
        }
        return nlUsageTracker;
    }

    public static void setInstanceForTest(@NotNull DesignSurface surface, @NotNull NlUsageTracker tracker) {
        if (surface == null) {
            NlUsageTrackerManager.$$$reportNull$$$0(6);
        }
        if (tracker == null) {
            NlUsageTrackerManager.$$$reportNull$$$0(7);
        }
        sTrackersCache.put((Object)surface, (Object)tracker);
    }

    public static void cleanAfterTesting(@NotNull DesignSurface surface) {
        if (surface == null) {
            NlUsageTrackerManager.$$$reportNull$$$0(8);
        }
        sTrackersCache.put((Object)surface, (Object)NOP_TRACKER);
        sTrackersCache.invalidate((Object)surface);
    }

    @NotNull
    static LayoutEditorState getState(@Nullable DesignSurface surface) {
        Configuration configuration;
        LayoutEditorState.Builder builder = LayoutEditorState.newBuilder();
        if (surface == null) {
            LayoutEditorState layoutEditorState = builder.build();
            if (layoutEditorState == null) {
                NlUsageTrackerManager.$$$reportNull$$$0(9);
            }
            return layoutEditorState;
        }
        switch (surface.getLayoutType()) {
            case LAYOUT: {
                builder.setType(LayoutEditorState.Type.LAYOUT);
                break;
            }
            case MENU: {
                builder.setType(LayoutEditorState.Type.MENU);
                break;
            }
            case PREFERENCE_SCREEN: {
                builder.setType(LayoutEditorState.Type.PREFERENCE_SCREEN);
                break;
            }
            case VECTOR: {
                break;
            }
        }
        double scale = surface.getScale();
        if (SystemInfo.isMac && UIUtil.isRetina()) {
            scale *= 2.0;
        }
        if ((configuration = surface.getConfiguration()) != null) {
            State deviceState = configuration.getDeviceState();
            if (deviceState != null) {
                switch (deviceState.getOrientation()) {
                    case PORTRAIT: {
                        builder.setConfigOrientation(LayoutEditorState.Orientation.PORTRAIT);
                        break;
                    }
                    case LANDSCAPE: {
                        builder.setConfigOrientation(LayoutEditorState.Orientation.LANDSCAPE);
                        break;
                    }
                }
            }
            if (configuration.getTarget() != null) {
                builder.setConfigApiLevel(configuration.getTarget().getVersion().getApiString());
            }
        }
        if (scale >= 0.0) {
            builder.setConfigZoomLevel((int)(scale * 100.0));
        }
        if (surface instanceof NlDesignSurface) {
            builder.setMode(((NlDesignSurface)surface).isPreviewSurface() ? LayoutEditorState.Mode.PREVIEW_MODE : LayoutEditorState.Mode.DESIGN_MODE);
            switch (((NlDesignSurface)surface).getSceneMode()) {
                case SCREEN_ONLY: {
                    builder.setSurfaces(LayoutEditorState.Surfaces.SCREEN_SURFACE);
                    break;
                }
                case BLUEPRINT_ONLY: {
                    builder.setSurfaces(LayoutEditorState.Surfaces.BLUEPRINT_SURFACE);
                    break;
                }
                case BOTH: {
                    builder.setSurfaces(LayoutEditorState.Surfaces.BOTH);
                }
            }
        }
        LayoutEditorState layoutEditorState = builder.build();
        if (layoutEditorState == null) {
            NlUsageTrackerManager.$$$reportNull$$$0(10);
        }
        return layoutEditorState;
    }

    boolean shouldLog(int percent) {
        return sRandom.nextInt(100) >= 100 - percent - 1;
    }

    private void logStudioEvent(@NotNull LayoutEditorEvent.LayoutEditorEventType eventType, @Nullable Consumer<LayoutEditorEvent.Builder> consumer) {
        if (eventType == null) {
            NlUsageTrackerManager.$$$reportNull$$$0(11);
        }
        try {
            this.myExecutor.execute(() -> {
                if (eventType == null) {
                    NlUsageTrackerManager.$$$reportNull$$$0(24);
                }
                LayoutEditorEvent.Builder builder = LayoutEditorEvent.newBuilder().setType(eventType).setState(NlUsageTrackerManager.getState((DesignSurface)((Object)((Object)this.myDesignSurfaceRef.get()))));
                if (consumer != null) {
                    consumer.accept(builder);
                }
                AndroidStudioEvent.Builder studioEvent = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.LAYOUT_EDITOR).setKind(AndroidStudioEvent.EventKind.LAYOUT_EDITOR_EVENT).setLayoutEditorEvent(builder.build());
                this.myUsageTracker.log(studioEvent);
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    public void logAction(@NotNull LayoutEditorEvent.LayoutEditorEventType eventType) {
        if (eventType == null) {
            NlUsageTrackerManager.$$$reportNull$$$0(12);
        }
        assert (!LayoutEditorEvent.LayoutEditorEventType.RENDER.equals((Object)eventType)) : "RENDER actions should be logged through logRenderResult";
        assert (!LayoutEditorEvent.LayoutEditorEventType.DROP_VIEW_FROM_PALETTE.equals((Object)eventType)) : "DROP_VIEW_FROM_PALETTE actions should be logged through logDropFromPalette";
        assert (!LayoutEditorEvent.LayoutEditorEventType.ATTRIBUTE_CHANGE.equals((Object)eventType)) : "DROP_VIEW_FROM_PALETTE actions should be logged through logPropertyChange";
        assert (!LayoutEditorEvent.LayoutEditorEventType.FAVORITE_CHANGE.equals((Object)eventType)) : "FAVORITE_CHANGE actions should be logged through logFavoritesChange";
        this.logStudioEvent(eventType, null);
    }

    @Override
    public void logRenderResult(@Nullable LayoutEditorRenderResult.Trigger trigger, @NotNull RenderResult result, long totalRenderTimeMs) {
        if (result == null) {
            NlUsageTrackerManager.$$$reportNull$$$0(13);
        }
        if (!this.shouldLog(10)) {
            return;
        }
        this.logStudioEvent(LayoutEditorEvent.LayoutEditorEventType.RENDER, builder -> {
            void event;
            if (result == null) {
                NlUsageTrackerManager.$$$reportNull$$$0(23);
            }
            LayoutEditorRenderResult.Builder builder2 = LayoutEditorRenderResult.newBuilder().setResultCode(result.getRenderResult().getStatus().ordinal()).setTotalRenderTimeMs(totalRenderTimeMs);
            if (trigger != null) {
                builder2.setTrigger(trigger);
            }
            builder2.setComponentCount((int)result.getRootViews().stream().flatMap(s -> Stream.concat(s.getChildren().stream(), Stream.of(s))).count());
            RenderErrorModel errorModel = RenderErrorModelFactory.createErrorModel(result, null);
            builder2.setTotalIssueCount(errorModel.getIssues().size());
            if (!errorModel.getIssues().isEmpty()) {
                int errorCount = 0;
                int fidelityWarningCount = 0;
                for (RenderErrorModel.Issue issue2 : errorModel.getIssues()) {
                    if (HighlightSeverity.ERROR.getName().equals(issue2.getSeverity().getName())) {
                        ++errorCount;
                        continue;
                    }
                    if (!issue2.getSummary().startsWith("Layout fid")) continue;
                    ++fidelityWarningCount;
                }
                builder2.setErrorCount(errorCount).setFidelityWarningCount(fidelityWarningCount);
            }
            event.setRenderResult(builder2.build());
        });
    }

    @Override
    public void logDropFromPalette(@NotNull String viewTagName, @NotNull String representation, @NotNull String selectedGroup, int filterMatches) {
        if (viewTagName == null) {
            NlUsageTrackerManager.$$$reportNull$$$0(14);
        }
        if (representation == null) {
            NlUsageTrackerManager.$$$reportNull$$$0(15);
        }
        if (selectedGroup == null) {
            NlUsageTrackerManager.$$$reportNull$$$0(16);
        }
        LayoutPaletteEvent.Builder builder = LayoutPaletteEvent.newBuilder().setView(UsageTrackerUtil.convertTagName(viewTagName)).setViewOption(UsageTrackerUtil.convertViewOption(viewTagName, representation)).setSelectedGroup(UsageTrackerUtil.convertGroupName(selectedGroup)).setSearchOption(UsageTrackerUtil.convertFilterMatches(filterMatches));
        this.logStudioEvent(LayoutEditorEvent.LayoutEditorEventType.DROP_VIEW_FROM_PALETTE, event -> event.setPaletteEvent(builder));
    }

    @Override
    public void logPropertyChange(@NotNull NlProperty property2, @NotNull NlPropertiesPanel.PropertiesViewMode propertiesMode, int filterMatches) {
        if (property2 == null) {
            NlUsageTrackerManager.$$$reportNull$$$0(17);
        }
        if (propertiesMode == null) {
            NlUsageTrackerManager.$$$reportNull$$$0(18);
        }
        LayoutAttributeChangeEvent.Builder builder = LayoutAttributeChangeEvent.newBuilder().setAttribute(UsageTrackerUtil.convertAttribute(property2)).setSearchOption(UsageTrackerUtil.convertFilterMatches(filterMatches)).setViewType(UsageTrackerUtil.convertPropertiesMode(propertiesMode));
        for (NlComponent component2 : property2.getComponents()) {
            builder.addView(UsageTrackerUtil.convertTagName(component2.getTagName()));
        }
        this.logStudioEvent(LayoutEditorEvent.LayoutEditorEventType.ATTRIBUTE_CHANGE, event -> event.setAttributeChangeEvent(builder));
    }

    @Override
    public void logFavoritesChange(@NotNull String addedPropertyName, @NotNull String removedPropertyName, @NotNull List<String> currentFavorites, @NotNull AndroidFacet facet) {
        if (addedPropertyName == null) {
            NlUsageTrackerManager.$$$reportNull$$$0(19);
        }
        if (removedPropertyName == null) {
            NlUsageTrackerManager.$$$reportNull$$$0(20);
        }
        if (currentFavorites == null) {
            NlUsageTrackerManager.$$$reportNull$$$0(21);
        }
        if (facet == null) {
            NlUsageTrackerManager.$$$reportNull$$$0(22);
        }
        LayoutFavoriteAttributeChangeEvent.Builder builder = LayoutFavoriteAttributeChangeEvent.newBuilder();
        if (!addedPropertyName.isEmpty()) {
            builder.setAdded(UsageTrackerUtil.convertAttribute(addedPropertyName, facet));
        }
        if (!removedPropertyName.isEmpty()) {
            builder.setRemoved(UsageTrackerUtil.convertAttribute(removedPropertyName, facet));
        }
        for (String propertyName : currentFavorites) {
            builder.addActive(UsageTrackerUtil.convertAttribute(propertyName, facet));
        }
        this.logStudioEvent(LayoutEditorEvent.LayoutEditorEventType.FAVORITE_CHANGE, event -> event.setFavoriteChangeEvent(builder));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageTracker";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/analytics/NlUsageTrackerManager";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 11: 
            case 12: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventType";
                break;
            }
            case 13: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewTagName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "representation";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedGroup";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesMode";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedPropertyName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removedPropertyName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFavorites";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/analytics/NlUsageTrackerManager";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceInner";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setInstanceForTest";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "cleanAfterTesting";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "logStudioEvent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "logAction";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "logRenderResult";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "logDropFromPalette";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "logPropertyChange";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "logFavoritesChange";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$logRenderResult$3";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$logStudioEvent$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

