/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.debugging.editor;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.debugging.DexSourceFiles;
import com.android.tools.idea.apk.debugging.editor.ChooseAndAttachJavaSourcesTask;
import com.android.tools.idea.smali.psi.SmaliFile;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmaliFileNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"apk.smali.file");
    @NotNull
    private final Project myProject;
    @NotNull
    private final DexSourceFiles myDexSourceFiles;

    public SmaliFileNotificationProvider(@NotNull Project project, @NotNull DexSourceFiles dexSourceFiles) {
        if (project == null) {
            SmaliFileNotificationProvider.$$$reportNull$$$0(0);
        }
        if (dexSourceFiles == null) {
            SmaliFileNotificationProvider.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myDexSourceFiles = dexSourceFiles;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            SmaliFileNotificationProvider.$$$reportNull$$$0(2);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        File filePath;
        File outputFolderPath;
        Module module;
        if (file == null) {
            SmaliFileNotificationProvider.$$$reportNull$$$0(3);
        }
        if (fileEditor == null) {
            SmaliFileNotificationProvider.$$$reportNull$$$0(4);
        }
        if ((module = ProjectFileIndex.getInstance((Project)this.myProject).getModuleForFile(file)) != null && ApkFacet.getInstance(module) != null && this.myDexSourceFiles.isSmaliFile(file) && FileUtil.isAncestor((File)(outputFolderPath = this.myDexSourceFiles.getDefaultSmaliOutputFolderPath()), (File)(filePath = VfsUtilCore.virtualToIoFile((VirtualFile)file)), (boolean)false)) {
            String classFqn;
            EditorNotificationPanel panel = new EditorNotificationPanel();
            panel.setText("Disassembled classes.dex file. To set up breakpoints for debugging, please attach Java source files.");
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
            if (psiFile instanceof SmaliFile && StringUtil.isNotEmpty((String)(classFqn = this.myDexSourceFiles.findJavaClassName((SmaliFile)psiFile)))) {
                PsiClass javaPsiClass = this.myDexSourceFiles.findJavaPsiClass(classFqn);
                if (javaPsiClass != null) {
                    panel.createActionLabel("Open Java file", () -> NavigationUtil.openFileWithPsiElement((PsiElement)javaPsiClass, (boolean)true, (boolean)true));
                } else {
                    panel.createActionLabel("Attach Java Sources...", (Runnable)new ChooseAndAttachJavaSourcesTask(classFqn, module, this.myDexSourceFiles));
                }
            }
            return panel;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dexSourceFiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/debugging/editor/SmaliFileNotificationProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/debugging/editor/SmaliFileNotificationProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

