/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder;

import com.intellij.gwt.uiBinder.UiBinderUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptorsProvider;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import com.intellij.xml.util.XmlUtil;

public class GwtHtmlAttributeDescriptorProvider
implements XmlAttributeDescriptorsProvider {
    public XmlAttributeDescriptor[] getAttributeDescriptors(XmlTag context) {
        if (!GwtHtmlAttributeDescriptorProvider.isInUiXmlFile(context)) {
            return XmlAttributeDescriptor.EMPTY;
        }
        String prefix = context.getPrefixByNamespace("urn:ui:com.google.gwt.uibinder");
        if (prefix != null) {
            return new XmlAttributeDescriptor[]{new AnyXmlAttributeDescriptor(prefix + ":" + "field")};
        }
        return XmlAttributeDescriptor.EMPTY;
    }

    private static boolean isInUiXmlFile(XmlTag context) {
        PsiFile file = context.getContainingFile();
        return file instanceof XmlFile && UiBinderUtil.isUiXmlFile((XmlFile)file);
    }

    public XmlAttributeDescriptor getAttributeDescriptor(String attributeName, XmlTag context) {
        String localName = XmlUtil.findLocalNameByQualifiedName((String)attributeName);
        if (!"field".equals(localName) || !GwtHtmlAttributeDescriptorProvider.isInUiXmlFile(context)) {
            return null;
        }
        String prefix = XmlUtil.findPrefixByQualifiedName((String)attributeName);
        String namespace = context.getNamespaceByPrefix(prefix);
        if ("urn:ui:com.google.gwt.uibinder".equals(namespace)) {
            return new AnyXmlAttributeDescriptor(attributeName);
        }
        return null;
    }
}

