/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.run;

import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.update.RunningApplicationUpdater;
import com.intellij.execution.update.RunningApplicationUpdaterProvider;
import com.intellij.gwt.run.GwtCommandLineState;
import com.intellij.gwt.run.HostedModeWarDirectoryGenerator;
import com.intellij.gwt.run.remoteUi.RemoteUiConnection;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import icons.GwtStudioIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DevModeUpdaterProvider
implements RunningApplicationUpdaterProvider {
    public RunningApplicationUpdater createUpdater(@NotNull Project project, @NotNull ProcessHandler process) {
        if (project == null) {
            DevModeUpdaterProvider.$$$reportNull$$$0(0);
        }
        if (process == null) {
            DevModeUpdaterProvider.$$$reportNull$$$0(1);
        }
        HostedModeWarDirectoryGenerator devModeGenerator = (HostedModeWarDirectoryGenerator)process.getUserData(GwtCommandLineState.GWT_GENERATOR_KEY);
        GwtCommandLineState state = (GwtCommandLineState)((Object)process.getUserData(GwtCommandLineState.GWT_CONFIGURATION_STATE_KEY));
        if (devModeGenerator != null && state != null) {
            return new DevModeUpdater(project, devModeGenerator, state);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "process";
                break;
            }
        }
        objectArray[1] = "com/intellij/gwt/run/DevModeUpdaterProvider";
        objectArray[2] = "createUpdater";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DevModeUpdater
    implements RunningApplicationUpdater {
        private final Project myProject;
        private final HostedModeWarDirectoryGenerator myDevModeGenerator;
        private final GwtCommandLineState myConfigurationState;

        DevModeUpdater(Project project, HostedModeWarDirectoryGenerator devModeGenerator, GwtCommandLineState state) {
            this.myProject = project;
            this.myDevModeGenerator = devModeGenerator;
            this.myConfigurationState = state;
        }

        public String getDescription() {
            return "Update '" + this.myConfigurationState.getRunConfigurationName() + "'";
        }

        public String getShortName() {
            return this.myConfigurationState.getRunConfigurationName();
        }

        public Icon getIcon() {
            return GwtStudioIcons.Google_small;
        }

        public void performUpdate() {
            this.myDevModeGenerator.updateResources(this.myProject, this.myConfigurationState.getRunConfigurationName());
            new Task.Backgroundable(this.myProject, "Looking for Changed Classes...", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ModuleCompileScope scope = new ModuleCompileScope(myConfigurationState.getModule(), false);
                    CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
                    if (!compilerManager.isUpToDate((CompileScope)scope)) {
                        ApplicationManager.getApplication().invokeLater(() -> compilerManager.make(myConfigurationState.getModule(), new CompileStatusNotification(){

                            public void finished(boolean aborted, int errors, int warnings, @NotNull CompileContext compileContext) {
                                if (compileContext == null) {
                                    DevModeUpdater.1.$$$reportNull$$$0(0);
                                }
                                RemoteUiConnection connection = myConfigurationState.getUiConnection();
                                if (!aborted && errors == 0 && connection != null) {
                                    ApplicationManager.getApplication().invokeLater(() -> {
                                        myDevModeGenerator.updateResources(myProject, null);
                                        connection.sendRestartServerRequest();
                                    });
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compileContext", "com/intellij/gwt/run/DevModeUpdaterProvider$DevModeUpdater$1$1", "finished"));
                            }
                        }));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/gwt/run/DevModeUpdaterProvider$DevModeUpdater$1", "run"));
                }
            }.queue();
        }
    }
}

