/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.refactorings;

import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.i18n.GwtI18nManager;
import com.intellij.gwt.i18n.GwtI18nUtil;
import com.intellij.gwt.rpc.RemoteServiceUtil;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.RefactoringFactory;
import com.intellij.refactoring.RenameRefactoring;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtRefactoringListenerProvider
implements RefactoringElementListenerProvider {
    private final Project myProject;
    private static final ThreadLocal<Boolean> myInsideGwtListener = ThreadLocal.withInitial(() -> false);

    public GwtRefactoringListenerProvider(Project project) {
        this.myProject = project;
    }

    @Nullable
    public RefactoringElementListener getListener(PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null || !GwtFacet.isInModuleWithGwtFacet(element.getProject(), containingFile.getVirtualFile())) {
            return null;
        }
        RefactoringElementListener listener = null;
        if (element instanceof PsiClass) {
            listener = this.getServiceClassListener((PsiClass)element);
        } else if (element instanceof PsiMethod) {
            listener = this.getServiceMethodListener((PsiMethod)element);
        }
        if (listener != null) {
            return listener;
        }
        return this.getPropertiesClassListener(element);
    }

    @Nullable
    private RefactoringElementListener getServiceMethodListener(PsiMethod method) {
        final PsiMethod asyncMethod = RemoteServiceUtil.findAsynchronousMethod(method);
        if (asyncMethod == null) {
            return null;
        }
        return new RefactoringElementListenerBase(){

            @Override
            public void elementRenamed(@NotNull PsiElement newElement) {
                if (newElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                GwtRefactoringListenerProvider.this.rename((PsiElement)asyncMethod, ((PsiMethod)newElement).getName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/gwt/refactorings/GwtRefactoringListenerProvider$1", "elementRenamed"));
            }
        };
    }

    @Nullable
    private RefactoringElementListener getServiceClassListener(PsiClass psiClass) {
        if (!RemoteServiceUtil.isRemoteServiceInterface(psiClass)) {
            return null;
        }
        final PsiClass async = RemoteServiceUtil.findAsynchronousInterface(psiClass);
        if (async == null) {
            return null;
        }
        return new RefactoringElementListenerBase(){

            @Override
            public void elementRenamed(@NotNull PsiElement newElement) {
                if (newElement == null) {
                    2.$$$reportNull$$$0(0);
                }
                GwtRefactoringListenerProvider.this.rename((PsiElement)async, ((PsiClass)newElement).getName() + "Async");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/gwt/refactorings/GwtRefactoringListenerProvider$2", "elementRenamed"));
            }
        };
    }

    @Nullable
    private RefactoringElementListener getPropertiesClassListener(PsiElement element) {
        IProperty property;
        PsiMethod method;
        GwtI18nManager i18nManager = GwtI18nManager.getInstance(this.myProject);
        final HashMap<Object, Function> elementsToRename = new HashMap<Object, Function>(1);
        if (element instanceof IProperty && (method = i18nManager.getMethod(property = (IProperty)element)) != null && Comparing.equal((String)property.getUnescapedKey(), (String)method.getName())) {
            elementsToRename.put(method, FunctionUtil.id());
        }
        if (element instanceof PsiMethod) {
            IProperty[] properties;
            PsiMethod method2 = (PsiMethod)element;
            for (IProperty property2 : properties = i18nManager.getProperties(method2)) {
                if (!Comparing.equal((String)property2.getUnescapedKey(), (String)method2.getName())) continue;
                elementsToRename.put((PsiNamedElement)property2.getPsiElement(), FunctionUtil.id());
            }
        }
        if (element instanceof PsiClass) {
            PropertiesFile[] files;
            PsiClass psiClass = (PsiClass)element;
            String className = psiClass.getName();
            for (PropertiesFile file : files = i18nManager.getPropertiesFiles(psiClass)) {
                String fileName = file.getName();
                if (className == null || !fileName.startsWith(className)) continue;
                String suffix = fileName.substring(className.length());
                elementsToRename.put(file.getContainingFile(), s -> s + suffix);
            }
        }
        if (!elementsToRename.isEmpty()) {
            return new RefactoringElementListenerBase(){

                @Override
                public void elementRenamed(@NotNull PsiElement newElement) {
                    if (newElement == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    for (Map.Entry entry : elementsToRename.entrySet()) {
                        PsiNamedElement psiElement = (PsiNamedElement)entry.getKey();
                        String newName = ((PsiNamedElement)newElement).getName();
                        if (psiElement instanceof PsiMethod && !PsiNameHelper.getInstance((Project)GwtRefactoringListenerProvider.this.myProject).isIdentifier(newName)) {
                            GwtFacet gwtFacet = GwtFacet.findFacetBySourceFile(GwtRefactoringListenerProvider.this.myProject, psiElement.getContainingFile().getVirtualFile());
                            if (gwtFacet == null || newName == null) continue;
                            GwtI18nUtil.addKeyAnnotationOrJavaDoc((PsiMethod)psiElement, newName, gwtFacet.getSdkVersion(), JavaPsiFacade.getInstance((Project)GwtRefactoringListenerProvider.this.myProject).getElementFactory());
                            continue;
                        }
                        GwtRefactoringListenerProvider.this.rename((PsiElement)psiElement, (String)((Function)entry.getValue()).fun((Object)newName));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/gwt/refactorings/GwtRefactoringListenerProvider$3", "elementRenamed"));
                }
            };
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rename(PsiElement element, String newName) {
        if (Boolean.TRUE.equals(myInsideGwtListener.get())) {
            return;
        }
        try {
            myInsideGwtListener.set(true);
            RenameRefactoring rename = RefactoringFactory.getInstance((Project)this.myProject).createRename(element, newName);
            rename.setSearchInComments(false);
            rename.setSearchInNonJavaFiles(false);
            rename.setPreviewUsages(false);
            UsageInfo[] usage = rename.findUsages();
            if (rename.preprocessUsages(new Ref((Object)usage))) {
                rename.doRefactoring(usage);
            }
        }
        finally {
            myInsideGwtListener.set(false);
        }
    }

    private static abstract class RefactoringElementListenerBase
    implements RefactoringElementListener {
        private RefactoringElementListenerBase() {
        }

        public void elementMoved(@NotNull PsiElement newElement) {
            if (newElement == null) {
                RefactoringElementListenerBase.$$$reportNull$$$0(0);
            }
        }

        public void elementRenamed(@NotNull PsiElement newElement) {
            if (newElement == null) {
                RefactoringElementListenerBase.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "newElement";
            objectArray2[1] = "com/intellij/gwt/refactorings/GwtRefactoringListenerProvider$RefactoringElementListenerBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "elementMoved";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "elementRenamed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

