/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections.eventListeners;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFix;
import com.intellij.gwt.inspections.eventListeners.DeprecatedListener;
import com.intellij.gwt.inspections.eventListeners.DeprecatedListenerUsages;
import com.intellij.gwt.inspections.eventListeners.EventHandlerInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ListenerUsageInfo {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.inspections.eventListeners.ListenerUsageInfo");
    private final PsiTypeElement myDeclarationTypeElement;
    private final DeprecatedListener myListener;
    private boolean myCannotBeFixed;
    private final Set<PsiJavaCodeReferenceElement> myReferences;
    private final Set<PsiJavaCodeReferenceElement> myProcessedReferences;
    private final List<PsiMethodCallExpression> myAddListenerExpressions;
    private PsiNewExpression myAnonymousCreationExpression;
    private PsiJavaCodeReferenceElement myListenerInterfaceInExtendsOrImplementsList;
    private PsiClass myListenerImplementation;
    private EventHandlerInfo myHandler;
    private PsiMethod myEventMethod;
    private boolean myInExtendsList;
    private static final String FAMILY_NAME_REPLACE_LISTENER = GwtBundle.message("quickfix.family.name.replace.listener.with.handler", new Object[0]);

    ListenerUsageInfo(@NotNull DeprecatedListener listener, @Nullable PsiTypeElement declarationTypeElement) {
        if (listener == null) {
            ListenerUsageInfo.$$$reportNull$$$0(0);
        }
        this.myReferences = new THashSet();
        this.myProcessedReferences = new THashSet();
        this.myAddListenerExpressions = new ArrayList<PsiMethodCallExpression>();
        this.myListener = listener;
        this.myDeclarationTypeElement = declarationTypeElement;
    }

    @NotNull
    public DeprecatedListener getListener() {
        DeprecatedListener deprecatedListener = this.myListener;
        if (deprecatedListener == null) {
            ListenerUsageInfo.$$$reportNull$$$0(1);
        }
        return deprecatedListener;
    }

    public void setCannotBeFixed() {
        this.myCannotBeFixed = true;
    }

    public void setListenerAddedOrRemoved(boolean added, PsiMethodCallExpression methodCallExpression) {
        if (added) {
            this.myAddListenerExpressions.add(methodCallExpression);
        } else {
            this.setCannotBeFixed();
        }
    }

    public void registerProcessedReference(PsiExpression listenerReference) {
        if (listenerReference instanceof PsiJavaCodeReferenceElement) {
            this.myProcessedReferences.add((PsiJavaCodeReferenceElement)listenerReference);
        }
    }

    public void registerReference(@NotNull PsiJavaCodeReferenceElement reference) {
        if (reference == null) {
            ListenerUsageInfo.$$$reportNull$$$0(2);
        }
        this.myReferences.add(reference);
    }

    public void setCreatedAsAnonymous(@NotNull PsiNewExpression newExpression, @NotNull PsiAnonymousClass anonymousClass) {
        if (newExpression == null) {
            ListenerUsageInfo.$$$reportNull$$$0(3);
        }
        if (anonymousClass == null) {
            ListenerUsageInfo.$$$reportNull$$$0(4);
        }
        this.setListenerImplementation((PsiClass)anonymousClass);
        this.myAnonymousCreationExpression = newExpression;
    }

    public void setCreatedAsInner(PsiJavaCodeReferenceElement listenerInterfaceReference, PsiClass listenerImplementation, boolean isInExtendsList) {
        this.setListenerImplementation(listenerImplementation);
        this.myInExtendsList = isInExtendsList;
        this.myListenerInterfaceInExtendsOrImplementsList = listenerInterfaceReference;
    }

    private void setListenerImplementation(@NotNull PsiClass listenerImplementation) {
        if (listenerImplementation == null) {
            ListenerUsageInfo.$$$reportNull$$$0(5);
        }
        if (this.myListenerImplementation != null) {
            this.setCannotBeFixed();
        }
        this.myListenerImplementation = listenerImplementation;
        for (String methodName : this.myListener.getMethodNames()) {
            PsiMethod[] methods = this.myListenerImplementation.findMethodsByName(methodName, false);
            if (methods.length > 1) {
                this.setCannotBeFixed();
                break;
            }
            if (methods.length != 1) continue;
            if (this.myEventMethod != null) {
                this.setCannotBeFixed();
                break;
            }
            this.myEventMethod = methods[0];
            this.myHandler = this.myListener.getHandler(methodName);
        }
    }

    public boolean canBeFixed(DeprecatedListenerUsages usages) {
        if (this.myCannotBeFixed) {
            return false;
        }
        this.myReferences.removeAll(this.myProcessedReferences);
        if (!this.myReferences.isEmpty()) {
            return false;
        }
        return this.myListenerImplementation != null && this.myEventMethod != null && !usages.getMethodsWhichParametersAreUsed().contains(this.myEventMethod) && this.myHandler != null;
    }

    public ProblemDescriptor createProblemDescriptor(InspectionManager manager, boolean isOnTheFly) {
        String message = "'" + StringUtil.getShortName((String)this.myListener.getListenerClass()) + "' is deprecated in GWT 1.6";
        Object place = this.myDeclarationTypeElement != null && this.myListener.isListenerOrAdapterType(this.myDeclarationTypeElement.getType()) ? this.myDeclarationTypeElement : (this.myAnonymousCreationExpression != null ? this.myAnonymousCreationExpression.getClassOrAnonymousClassReference() : (this.myListenerInterfaceInExtendsOrImplementsList != null ? this.myListenerInterfaceInExtendsOrImplementsList : this.myListenerImplementation.getNameIdentifier()));
        if (place == null) {
            place = this.myListenerImplementation;
        }
        ReplaceListenerWithHandlerFix fix = new ReplaceListenerWithHandlerFix();
        return manager.createProblemDescriptor((PsiElement)place, message, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/inspections/eventListeners/ListenerUsageInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anonymousClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listenerImplementation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/inspections/eventListeners/ListenerUsageInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerReference";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setCreatedAsAnonymous";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setListenerImplementation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ReplaceListenerWithHandlerFix
    extends BaseGwtLocalQuickFix {
        private ReplaceListenerWithHandlerFix() {
            super(GwtBundle.message("quickfix.name.replace.0.with.1", StringUtil.getShortName((String)ListenerUsageInfo.this.myListener.getListenerClass()), StringUtil.getShortName((String)ListenerUsageInfo.this.myHandler.getHandlerClass())));
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = FAMILY_NAME_REPLACE_LISTENER;
            if (string == null) {
                ReplaceListenerWithHandlerFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                ReplaceListenerWithHandlerFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ReplaceListenerWithHandlerFix.$$$reportNull$$$0(2);
            }
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            GlobalSearchScope scope = ListenerUsageInfo.this.myListenerImplementation.getResolveScope();
            if (ListenerUsageInfo.this.myDeclarationTypeElement != null) {
                PsiClassType type = factory.createTypeByFQClassName(ListenerUsageInfo.this.myHandler.getHandlerClass(), scope);
                codeStyleManager.shortenClassReferences(ListenerUsageInfo.this.myDeclarationTypeElement.replace((PsiElement)factory.createTypeElement((PsiType)type)));
            }
            PsiJavaCodeReferenceElement handlerClassReference = factory.createFQClassNameReferenceElement(ListenerUsageInfo.this.myHandler.getHandlerClass(), scope);
            if (ListenerUsageInfo.this.myAnonymousCreationExpression != null) {
                PsiJavaCodeReferenceElement anonymousClassReference = ListenerUsageInfo.this.myAnonymousCreationExpression.getClassOrAnonymousClassReference();
                LOG.assertTrue(anonymousClassReference != null);
                codeStyleManager.shortenClassReferences(anonymousClassReference.replace((PsiElement)handlerClassReference));
            } else if (ListenerUsageInfo.this.myListenerInterfaceInExtendsOrImplementsList != null) {
                PsiElement referenceElement;
                if (ListenerUsageInfo.this.myInExtendsList) {
                    ListenerUsageInfo.this.myListenerInterfaceInExtendsOrImplementsList.delete();
                    referenceElement = ListenerUsageInfo.this.myListenerImplementation.getImplementsList().add((PsiElement)handlerClassReference);
                } else {
                    referenceElement = ListenerUsageInfo.this.myListenerInterfaceInExtendsOrImplementsList.replace((PsiElement)handlerClassReference);
                }
                codeStyleManager.shortenClassReferences(referenceElement);
            }
            LOG.assertTrue(ListenerUsageInfo.this.myEventMethod != null);
            PsiClass handlerClass = psiFacade.findClass(ListenerUsageInfo.this.myHandler.getHandlerClass(), scope);
            LOG.assertTrue(handlerClass != null);
            String handlerMethodName = ListenerUsageInfo.this.myHandler.getHandlerMethod();
            PsiMethod handlerMethod = handlerClass.findMethodsByName(handlerMethodName, false)[0];
            PsiMethod newMethod = GenerateMembersUtil.substituteGenericMethod((PsiMethod)handlerMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiElement newParametersList = ListenerUsageInfo.this.myEventMethod.getParameterList().replace((PsiElement)newMethod.getParameterList());
            codeStyleManager.shortenClassReferences(newParametersList);
            if (!handlerMethodName.equals(ListenerUsageInfo.this.myEventMethod.getName())) {
                PsiIdentifier nameIdentifier = ListenerUsageInfo.this.myEventMethod.getNameIdentifier();
                LOG.assertTrue(nameIdentifier != null);
                nameIdentifier.replace((PsiElement)factory.createIdentifier(handlerMethodName));
            }
            this.removeOverrideAnnotationIfNeeded(ListenerUsageInfo.this.myEventMethod);
            for (PsiMethodCallExpression addListenerExpression : ListenerUsageInfo.this.myAddListenerExpressions) {
                PsiElement methodNameElement = addListenerExpression.getMethodExpression().getReferenceNameElement();
                if (methodNameElement == null) continue;
                methodNameElement.replace((PsiElement)factory.createIdentifier(ListenerUsageInfo.this.myHandler.getAddHandlerMethod()));
            }
        }

        private void removeOverrideAnnotationIfNeeded(PsiMethod eventMethod) {
            PsiAnnotation annotation = eventMethod.getModifierList().findAnnotation("java.lang.Override");
            if (annotation != null && PsiUtil.getLanguageLevel((PsiElement)eventMethod) == LanguageLevel.JDK_1_5) {
                annotation.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/gwt/inspections/eventListeners/ListenerUsageInfo$ReplaceListenerWithHandlerFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/gwt/inspections/eventListeners/ListenerUsageInfo$ReplaceListenerWithHandlerFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

