/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections.eventListeners;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.inspections.eventListeners.DeprecatedListenerUsages;
import com.intellij.gwt.inspections.eventListeners.EventListenersUsagesCollector;
import com.intellij.gwt.inspections.eventListeners.ListenerUsageInfo;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GwtDeprecatedEventListenersInspection
extends BaseGwtInspection {
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            GwtDeprecatedEventListenersInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            GwtDeprecatedEventListenersInspection.$$$reportNull$$$0(1);
        }
        if (file.getFileType() != StdFileTypes.JAVA) {
            return null;
        }
        GwtFacet gwtFacet = GwtDeprecatedEventListenersInspection.getFacet((PsiElement)file);
        if (gwtFacet == null || !gwtFacet.getSdkVersion().isEventHandlersSupported()) {
            return null;
        }
        EventListenersUsagesCollector collector = new EventListenersUsagesCollector();
        file.accept((PsiElementVisitor)collector);
        DeprecatedListenerUsages usages = collector.getListenerUsages();
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>();
        for (ListenerUsageInfo usageInfo : usages.getUsages()) {
            if (!usageInfo.canBeFixed(usages)) continue;
            problems.add(usageInfo.createProblemDescriptor(manager, isOnTheFly));
        }
        return problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            GwtDeprecatedEventListenersInspection.$$$reportNull$$$0(2);
        }
        return highlightDisplayLevel;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Deprecated event listeners" == null) {
            GwtDeprecatedEventListenersInspection.$$$reportNull$$$0(3);
        }
        return "Deprecated event listeners";
    }

    @NotNull
    public String getShortName() {
        if ("GwtDeprecatedEventListeners" == null) {
            GwtDeprecatedEventListenersInspection.$$$reportNull$$$0(4);
        }
        return "GwtDeprecatedEventListeners";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/inspections/eventListeners/GwtDeprecatedEventListenersInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/inspections/eventListeners/GwtDeprecatedEventListenersInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

