/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ReferenceNameExpression;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.references.GwtToHtmlTagReference;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtToHtmlTagReferencesInspection
extends BaseGwtInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            GwtToHtmlTagReferencesInspection.$$$reportNull$$$0(0);
        }
        if (!GwtToHtmlTagReferencesInspection.hasGwtFacets(holder.getManager().getProject())) {
            PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
            if (psiElementVisitor == null) {
                GwtToHtmlTagReferencesInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitLiteralExpression(PsiLiteralExpression expression) {
                PsiReference[] references;
                for (PsiReference reference : references = expression.getReferences()) {
                    if (!(reference instanceof GwtToHtmlTagReference) || reference.resolve() != null) continue;
                    holder.registerProblem((PsiElement)expression, GwtBundle.message("problem.description.html.tag.with.id.0.is.not.found", expression.getValue()), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[]{new GwtToHtmlTagRenameReferenceQuickFix(expression)});
                }
            }
        };
        if (javaElementVisitor == null) {
            GwtToHtmlTagReferencesInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.name.unresolved.references.to.html.tags", new Object[0]);
        if (string == null) {
            GwtToHtmlTagReferencesInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("GwtToHtmlReferences" == null) {
            GwtToHtmlTagReferencesInspection.$$$reportNull$$$0(4);
        }
        return "GwtToHtmlReferences";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/inspections/GwtToHtmlTagReferencesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/inspections/GwtToHtmlTagReferencesInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GwtToHtmlTagRenameReferenceQuickFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        GwtToHtmlTagRenameReferenceQuickFix(@NotNull PsiLiteralExpression element) {
            if (element == null) {
                GwtToHtmlTagRenameReferenceQuickFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)element);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                GwtToHtmlTagRenameReferenceQuickFix.$$$reportNull$$$0(1);
            }
            if (file == null) {
                GwtToHtmlTagRenameReferenceQuickFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                GwtToHtmlTagRenameReferenceQuickFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                GwtToHtmlTagRenameReferenceQuickFix.$$$reportNull$$$0(4);
            }
            if (editor == null) {
                return;
            }
            TemplateBuilderImpl builder = (TemplateBuilderImpl)TemplateBuilderFactory.getInstance().createTemplateBuilder(startElement);
            TextRange textRange = TextRange.from((int)1, (int)(startElement.getTextLength() - 2));
            GwtToHtmlTagReference reference = (GwtToHtmlTagReference)((Object)ContainerUtil.findInstance((Object[])startElement.getReferences(), GwtToHtmlTagReference.class));
            if (reference == null) {
                return;
            }
            LookupElement[] items = (LookupElement[])Arrays.stream(reference.getVariants()).map(LookupElementBuilder::create).toArray(LookupElement[]::new);
            builder.replaceElement(startElement, textRange, (Expression)new ReferenceNameExpression(items, StringUtil.unquoteString((String)startElement.getText())));
            editor.getCaretModel().moveToOffset(startElement.getTextOffset());
            Template template = builder.buildInlineTemplate();
            TemplateManager.getInstance((Project)project).startTemplate(editor, template);
        }

        @NotNull
        public String getText() {
            String string = GwtBundle.message("quick.fix.name.rename.reference", new Object[0]);
            if (string == null) {
                GwtToHtmlTagRenameReferenceQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = CodeInsightBundle.message((String)"rename.element.family", (Object[])new Object[0]);
            if (string == null) {
                GwtToHtmlTagRenameReferenceQuickFix.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/gwt/inspections/GwtToHtmlTagReferencesInspection$GwtToHtmlTagRenameReferenceQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/gwt/inspections/GwtToHtmlTagReferencesInspection$GwtToHtmlTagRenameReferenceQuickFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

