/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFix;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFixOnPsiElement;
import com.intellij.gwt.rpc.RemoteServiceUtil;
import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtInconsistentAsyncInterfaceInspection
extends BaseGwtInspection {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.inspections.GwtInconsistentAsyncInterfaceInspection");

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        GwtFacet gwtFacet;
        if (aClass == null) {
            GwtInconsistentAsyncInterfaceInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            GwtInconsistentAsyncInterfaceInspection.$$$reportNull$$$0(1);
        }
        if ((gwtFacet = GwtInconsistentAsyncInterfaceInspection.getFacet((PsiElement)aClass)) == null) {
            return null;
        }
        GwtVersion gwtVersion = gwtFacet.getSdkVersion();
        if (RemoteServiceUtil.isRemoteServiceInterface(aClass)) {
            return GwtInconsistentAsyncInterfaceInspection.checkRemoteServiceForAsync(aClass, gwtVersion, manager, isOnTheFly);
        }
        PsiClass sync = RemoteServiceUtil.findSynchronousInterface(aClass);
        if (sync != null) {
            return GwtInconsistentAsyncInterfaceInspection.checkAsyncServiceForRemote(sync, aClass, gwtVersion, manager, isOnTheFly);
        }
        return null;
    }

    @Nullable
    private static ProblemDescriptor[] checkAsyncServiceForRemote(PsiClass sync, PsiClass async, GwtVersion gwtVersion, InspectionManager manager, boolean onTheFly) {
        SmartList problems = new SmartList();
        SmartList methodsToCopy = new SmartList();
        for (PsiMethod method : sync.getMethods()) {
            if (RemoteServiceUtil.isMethodPresentedInAsync(method, async)) continue;
            methodsToCopy.add(method);
        }
        for (PsiMethod asyncMethod : async.getMethods()) {
            PsiType returnType;
            if (!RemoteServiceUtil.isMethodPresentedInSync(asyncMethod, sync)) {
                String message = GwtBundle.message("problem.description.async.method.does.not.have.sync.variant", asyncMethod.getName());
                CopyMethodToSyncQuickFix quickFix = new CopyMethodToSyncQuickFix(sync, asyncMethod);
                problems.add(manager.createProblemDescriptor(GwtInconsistentAsyncInterfaceInspection.getElementToHighlight(asyncMethod), message, (LocalQuickFix)quickFix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
            }
            if ((returnType = asyncMethod.getReturnType()) != null && (returnType.equals(PsiType.VOID) || returnType.getCanonicalText().equals("com.google.gwt.http.client.Request") || returnType.getCanonicalText().equals("com.google.gwt.http.client.RequestBuilder"))) continue;
            String message = GwtBundle.message("problem.description.the.asynchronous.version.of.method.0.must.have.a.return.type.void", asyncMethod.getName());
            MakeMethodReturnVoid fix = new MakeMethodReturnVoid(asyncMethod);
            problems.add(manager.createProblemDescriptor(GwtInconsistentAsyncInterfaceInspection.getElementToHighlight(asyncMethod), message, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
        }
        if (!methodsToCopy.isEmpty()) {
            String message = GwtBundle.message("problem.description.methods.of.async.remote.service.0.isn.t.synchronized.with.1", async.getName(), sync.getName());
            ArrayList<BaseGwtLocalQuickFix> quickFixesList = new ArrayList<BaseGwtLocalQuickFix>();
            for (PsiMethod method : methodsToCopy) {
                quickFixesList.add(new CopyMethodToAsyncQuickFix(async, method, gwtVersion));
            }
            quickFixesList.add(new SynchronizeAllMethodsInAsyncQuickFix(async, sync, gwtVersion));
            LocalQuickFix[] fixes = quickFixesList.toArray(LocalQuickFix.EMPTY_ARRAY);
            problems.add(manager.createProblemDescriptor(GwtInconsistentAsyncInterfaceInspection.getElementToHighlight(async), message, onTheFly, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
        }
        return problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static ProblemDescriptor[] checkRemoteServiceForAsync(PsiClass aClass, GwtVersion gwtVersion, InspectionManager manager, boolean onTheFly) {
        GlobalSearchScope scope = aClass.getResolveScope();
        PsiClass async = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(aClass.getQualifiedName() + "Async", scope);
        if (async == null) {
            String description = GwtBundle.message("problem.description.remote.service.0.does.not.have.corresponding.async.variant", aClass.getName());
            return new ProblemDescriptor[]{manager.createProblemDescriptor(GwtInconsistentAsyncInterfaceInspection.getElementToHighlight(aClass), description, (LocalQuickFix)new CreateAsyncClassQuickFix(aClass, gwtVersion), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly)};
        }
        ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>(0);
        for (PsiMethod method : aClass.getMethods()) {
            if (RemoteServiceUtil.isMethodPresentedInAsync(method, async)) continue;
            CopyMethodToAsyncQuickFix fix = new CopyMethodToAsyncQuickFix(async, method, gwtVersion);
            String message = GwtBundle.message("problem.description.async.remote.service.0.does.not.define.corresponding.method", async.getName());
            result.add(manager.createProblemDescriptor(GwtInconsistentAsyncInterfaceInspection.getElementToHighlight(method), message, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
        }
        return result.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.name.inconsistent.gwt.remote.service", new Object[0]);
        if (string == null) {
            GwtInconsistentAsyncInterfaceInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("GWTRemoteServiceAsyncCheck" == null) {
            GwtInconsistentAsyncInterfaceInspection.$$$reportNull$$$0(3);
        }
        return "GWTRemoteServiceAsyncCheck";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/inspections/GwtInconsistentAsyncInterfaceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/inspections/GwtInconsistentAsyncInterfaceInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CreateAsyncClassQuickFix
    extends BaseGwtLocalQuickFixOnPsiElement {
        private static final String FAMILY_NAME = GwtBundle.message("quickfix.family.name.create.interface", new Object[0]);
        private final GwtVersion myGwtVersion;

        CreateAsyncClassQuickFix(PsiClass remoteServiceInterface, GwtVersion gwtVersion) {
            super(FAMILY_NAME, GwtBundle.message("quickfix.name.create.interface.0", remoteServiceInterface.getName() + "Async"), (PsiElement)remoteServiceInterface);
            this.myGwtVersion = gwtVersion;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                CreateAsyncClassQuickFix.$$$reportNull$$$0(0);
            }
            if (file == null) {
                CreateAsyncClassQuickFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                CreateAsyncClassQuickFix.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                CreateAsyncClassQuickFix.$$$reportNull$$$0(3);
            }
            if (!(startElement instanceof PsiClass)) {
                return;
            }
            PsiClass remoteServiceInterface = (PsiClass)startElement;
            try {
                PsiJavaFile classFile = (PsiJavaFile)remoteServiceInterface.getContainingFile();
                LOG.assertTrue(classFile != null);
                String name = remoteServiceInterface.getName() + "Async";
                PsiTypeParameterList typeParameterList = remoteServiceInterface.getTypeParameterList();
                PsiPackageStatement packageStatement = classFile.getPackageStatement();
                StringBuilder source = new StringBuilder();
                source.append(packageStatement != null ? packageStatement.getText() : "").append("\n\n");
                PsiImportList psiImportList = classFile.getImportList();
                source.append(psiImportList != null ? psiImportList.getText() : "");
                source.append("public interface ").append(name);
                if (typeParameterList != null) {
                    source.append(typeParameterList.getText());
                }
                source.append("\n{\n}\n");
                PsiJavaFile asyncFile = (PsiJavaFile)PsiFileFactory.getInstance((Project)project).createFileFromText(name + ".java", source.toString());
                PsiClass async = asyncFile.getClasses()[0];
                RemoteServiceUtil.copyAllMethodsToAsync(remoteServiceInterface, async, this.myGwtVersion);
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)asyncFile);
                PsiDirectory directory = classFile.getContainingDirectory();
                LOG.assertTrue(directory != null);
                directory.add((PsiElement)asyncFile);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "endElement";
                    break;
                }
            }
            objectArray[1] = "com/intellij/gwt/inspections/GwtInconsistentAsyncInterfaceInspection$CreateAsyncClassQuickFix";
            objectArray[2] = "invoke";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SynchronizeAllMethodsInAsyncQuickFix
    extends BaseGwtLocalQuickFix {
        private static final String FAMILY_NAME = GwtBundle.message("quickfix.family.name.create.missing.methods", new Object[0]);
        private final SmartPsiElementPointer<PsiClass> myAsync;
        private final SmartPsiElementPointer<PsiClass> myRemoteServiceInterface;
        private final GwtVersion myGwtVersion;

        SynchronizeAllMethodsInAsyncQuickFix(PsiClass async, PsiClass remoteServiceInterface, GwtVersion gwtVersion) {
            super(GwtBundle.message("quick.fix.name.synchronize.all.methods.of.0.with.1", async.getName(), remoteServiceInterface.getName()));
            this.myAsync = SmartPointerManager.createPointer((PsiElement)async);
            this.myRemoteServiceInterface = SmartPointerManager.createPointer((PsiElement)remoteServiceInterface);
            this.myGwtVersion = gwtVersion;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = FAMILY_NAME;
            if (string == null) {
                SynchronizeAllMethodsInAsyncQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                SynchronizeAllMethodsInAsyncQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                SynchronizeAllMethodsInAsyncQuickFix.$$$reportNull$$$0(2);
            }
            PsiClass async = (PsiClass)this.myAsync.getElement();
            PsiClass remoteServiceInterface = (PsiClass)this.myRemoteServiceInterface.getElement();
            if (async == null || remoteServiceInterface == null) {
                return;
            }
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)async.getContainingFile())) {
                return;
            }
            try {
                RemoteServiceUtil.copyAllMethodsToAsync(remoteServiceInterface, async, this.myGwtVersion);
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)async);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/gwt/inspections/GwtInconsistentAsyncInterfaceInspection$SynchronizeAllMethodsInAsyncQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/gwt/inspections/GwtInconsistentAsyncInterfaceInspection$SynchronizeAllMethodsInAsyncQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CopyMethodToAsyncQuickFix
    extends BaseGwtLocalQuickFix {
        private static final String FAMILY_NAME = GwtBundle.message("quickfix.family.name.create.async.variant", new Object[0]);
        private final SmartPsiElementPointer<PsiClass> myAsync;
        private final SmartPsiElementPointer<PsiMethod> myMethod;
        private final GwtVersion myGwtVersion;

        private CopyMethodToAsyncQuickFix(PsiClass async, PsiMethod method, GwtVersion gwtVersion) {
            super(GwtBundle.message("quickfix.name.create.async.method.for.sync.0", PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2)));
            this.myAsync = SmartPointerManager.createPointer((PsiElement)async);
            this.myMethod = SmartPointerManager.createPointer((PsiElement)method);
            this.myGwtVersion = gwtVersion;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = FAMILY_NAME;
            if (string == null) {
                CopyMethodToAsyncQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                CopyMethodToAsyncQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                CopyMethodToAsyncQuickFix.$$$reportNull$$$0(2);
            }
            PsiClass async = (PsiClass)this.myAsync.getElement();
            PsiMethod method = (PsiMethod)this.myMethod.getElement();
            if (async == null || method == null) {
                return;
            }
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)async.getContainingFile())) {
                return;
            }
            try {
                PsiMethod newMethod = RemoteServiceUtil.copyMethodToAsync(method, async, this.myGwtVersion);
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)newMethod);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/gwt/inspections/GwtInconsistentAsyncInterfaceInspection$CopyMethodToAsyncQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/gwt/inspections/GwtInconsistentAsyncInterfaceInspection$CopyMethodToAsyncQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MakeMethodReturnVoid
    extends BaseGwtLocalQuickFixOnPsiElement {
        private static final String FAMILY_NAME = GwtBundle.message("quickfix.family.name.make.method.return.void", new Object[0]);

        MakeMethodReturnVoid(PsiMethod method) {
            super(FAMILY_NAME, GwtBundle.message("quickfix.name.make.0.return.void", method.getName()), (PsiElement)method);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                MakeMethodReturnVoid.$$$reportNull$$$0(0);
            }
            if (file == null) {
                MakeMethodReturnVoid.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                MakeMethodReturnVoid.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                MakeMethodReturnVoid.$$$reportNull$$$0(3);
            }
            if (!(startElement instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)startElement;
            PsiTypeElement returnTypeElement = method.getReturnTypeElement();
            if (returnTypeElement != null) {
                returnTypeElement.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createTypeElement((PsiType)PsiType.VOID));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "endElement";
                    break;
                }
            }
            objectArray[1] = "com/intellij/gwt/inspections/GwtInconsistentAsyncInterfaceInspection$MakeMethodReturnVoid";
            objectArray[2] = "invoke";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CopyMethodToSyncQuickFix
    extends BaseGwtLocalQuickFix {
        private static final String FAMILY_NAME = GwtBundle.message("quickfix.family.name.create.sync.variant", new Object[0]);
        private final SmartPsiElementPointer<PsiClass> mySync;
        private final SmartPsiElementPointer<PsiMethod> myMethod;

        private CopyMethodToSyncQuickFix(PsiClass sync, PsiMethod method) {
            super(GwtBundle.message("quickfix.name.create.sync.method.for.async.0", PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2)));
            this.mySync = SmartPointerManager.createPointer((PsiElement)sync);
            this.myMethod = SmartPointerManager.createPointer((PsiElement)method);
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = FAMILY_NAME;
            if (string == null) {
                CopyMethodToSyncQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                CopyMethodToSyncQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                CopyMethodToSyncQuickFix.$$$reportNull$$$0(2);
            }
            PsiClass sync = (PsiClass)this.mySync.getElement();
            PsiMethod psiMethod = (PsiMethod)this.myMethod.getElement();
            if (sync == null || psiMethod == null) {
                return;
            }
            VirtualFile file = sync.getContainingFile().getVirtualFile();
            if (file == null || ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{file}).hasReadonlyFiles()) {
                return;
            }
            try {
                PsiMethod method = RemoteServiceUtil.copyMethodToSync(psiMethod, sync);
                PsiElement reformatted = CodeStyleManager.getInstance((Project)project).reformat((PsiElement)method);
                OpenFileDescriptor fileDescriptor = new OpenFileDescriptor(project, file);
                Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(fileDescriptor, true);
                if (editor != null) {
                    PsiTypeElement returnTypeElement;
                    editor.getCaretModel().moveToOffset(reformatted.getTextRange().getStartOffset());
                    if (reformatted instanceof PsiMethod && (returnTypeElement = ((PsiMethod)reformatted).getReturnTypeElement()) != null) {
                        TextRange typeRange = returnTypeElement.getTextRange();
                        editor.getSelectionModel().setSelection(typeRange.getStartOffset(), typeRange.getEndOffset());
                    }
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/gwt/inspections/GwtInconsistentAsyncInterfaceInspection$CopyMethodToSyncQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/gwt/inspections/GwtInconsistentAsyncInterfaceInspection$CopyMethodToSyncQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

