/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.codeInsight.navigation;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.gwt.codeInsight.navigation.GutterIconMultipleNavigationHandler;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Function;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class MultipleNavigationLineMarkerFactory {
    private MultipleNavigationLineMarkerFactory() {
    }

    public static <T extends NavigatablePsiElement> RelatedItemLineMarkerInfo<PsiElement> create(T element, @NotNull PsiIdentifier identifier, Icon icon, List<? extends GotoRelatedItem> targets, GutterIconMultipleNavigationHandler<T> handler, int pass, boolean showContainingModules) {
        if (identifier == null) {
            MultipleNavigationLineMarkerFactory.$$$reportNull$$$0(0);
        }
        MultipleNavigationTooltipProvider<T> tooltipProvider = new MultipleNavigationTooltipProvider<T>(handler, element, targets);
        MultipleNavigationHandler<T> navigateHandler = new MultipleNavigationHandler<T>(handler, element, targets, showContainingModules);
        return new RelatedItemLineMarkerInfo((PsiElement)identifier, identifier.getTextRange(), icon, pass, tooltipProvider, navigateHandler, GutterIconRenderer.Alignment.CENTER, targets);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/gwt/codeInsight/navigation/MultipleNavigationLineMarkerFactory", "create"));
    }

    private static class MultipleNavigationTooltipProvider<T extends PsiElement>
    implements Function<PsiElement, String> {
        private final GutterIconMultipleNavigationHandler<T> myHandler;
        private final T mySource;
        private final List<? extends GotoRelatedItem> myTargets;

        MultipleNavigationTooltipProvider(GutterIconMultipleNavigationHandler<T> handler, T source, List<? extends GotoRelatedItem> targets) {
            this.myHandler = handler;
            this.mySource = source;
            this.myTargets = targets;
        }

        public String fun(PsiElement s) {
            return this.myHandler.getGutterTooltip(this.mySource, this.myTargets);
        }
    }

    private static class MultipleNavigationHandler<T extends PsiElement>
    implements GutterIconNavigationHandler<PsiElement> {
        private final GutterIconMultipleNavigationHandler<T> myGutterIconNavigationHandler;
        private final T mySource;
        private final List<? extends GotoRelatedItem> myTargets;
        private final boolean myShowContainingModules;

        MultipleNavigationHandler(GutterIconMultipleNavigationHandler<T> gutterIconNavigationHandler, T source, List<? extends GotoRelatedItem> targets, boolean showContainingModules) {
            this.myGutterIconNavigationHandler = gutterIconNavigationHandler;
            this.mySource = source;
            this.myTargets = targets;
            this.myShowContainingModules = showContainingModules;
        }

        public void navigate(MouseEvent e, PsiElement elt) {
            if (this.myTargets.size() == 1) {
                this.myTargets.get(0).navigate();
            } else {
                String title = this.myGutterIconNavigationHandler.getPopupChooserTitle(this.mySource, this.myTargets);
                JBPopup popup = NavigationUtil.getRelatedItemsPopup(this.myTargets, (String)title, (boolean)this.myShowContainingModules);
                popup.show(new RelativePoint(e));
            }
        }
    }
}

