/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.codeInsight;

import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nullable;

public class GwtReferenceUtil {
    private GwtReferenceUtil() {
    }

    @Nullable
    public static GwtModule findGwtModule(PsiElement element) {
        return GwtReferenceUtil.findGwtModule(element, GwtModulesManager.getInstance(element.getProject()));
    }

    @Nullable
    public static GwtModule findGwtModule(PsiElement element, GwtModulesManager modulesManager) {
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        return modulesManager.findGwtModuleByClientSourceFile(virtualFile);
    }
}

